/*
 * Decompiled with CFR 0.152.
 */
package techguns.entities.projectiles;

import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import techguns.TGPackets;
import techguns.api.damagesystem.DamageType;
import techguns.damagesystem.TGDamageSource;
import techguns.deatheffects.EntityDeathUtils;
import techguns.entities.projectiles.AbstractBeamProjectile;
import techguns.entities.projectiles.EnumBulletFirePos;
import techguns.items.guns.GenericGun;
import techguns.items.guns.IProjectileFactory;
import techguns.packets.PacketSpawnParticle;

public class LaserProjectile
extends AbstractBeamProjectile {
    public LaserProjectile(World worldIn, double posX, double posY, double posZ, float yaw, float pitch, float damage, float speed, int TTL, float spread, float dmgDropStart, float dmgDropEnd, float dmgMin, float penetration, boolean blockdamage, EnumBulletFirePos leftGun) {
        super(worldIn, posX, posY, posZ, yaw, pitch, damage, speed, TTL, spread, dmgDropStart, dmgDropEnd, dmgMin, penetration, blockdamage, leftGun);
        this.trace();
    }

    public LaserProjectile(World par2World, EntityLivingBase p, float damage, float speed, int TTL, float spread, float dmgDropStart, float dmgDropEnd, float dmgMin, float penetration, boolean blockdamage, EnumBulletFirePos leftGun) {
        super(par2World, p, damage, speed, TTL, spread, dmgDropStart, dmgDropEnd, dmgMin, penetration, blockdamage, leftGun);
        this.trace();
    }

    public LaserProjectile(World worldIn) {
        super(worldIn);
    }

    @Override
    protected void doImpactEffects(Material mat, RayTraceResult rayTraceResult, SoundType sound) {
        if (!this.field_70170_p.field_72995_K) {
            Vec3d hitVec = rayTraceResult.field_72307_f;
            TGPackets.network.sendToAllAround((IMessage)new PacketSpawnParticle("LaserGunImpact", hitVec.field_72450_a, hitVec.field_72448_b, hitVec.field_72449_c), TGPackets.targetPointAroundEnt(this, 35.0));
        }
    }

    @Override
    public void func_70071_h_() {
        --this.ticksToLive;
        if (this.ticksToLive <= 0) {
            this.func_70106_y();
        }
    }

    @Override
    protected TGDamageSource getProjectileDamageSource() {
        TGDamageSource src = TGDamageSource.causeEnergyDamage(this, (Entity)this.shooter, EntityDeathUtils.DeathType.LASER);
        src.goreChance = 1.0f;
        src.armorPenetration = this.penetration;
        src.setNoKnockback();
        return src;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    public static class Factory
    implements IProjectileFactory<LaserProjectile> {
        @Override
        public LaserProjectile createProjectile(GenericGun gun, World world, EntityLivingBase p, float damage, float speed, int TTL, float spread, float dmgDropStart, float dmgDropEnd, float dmgMin, float penetration, boolean blockdamage, EnumBulletFirePos firePos, float radius, double gravity) {
            return new LaserProjectile(world, p, damage, speed, 7, spread, dmgDropStart, dmgDropEnd, dmgMin, penetration, blockdamage, firePos);
        }

        @Override
        public DamageType getDamageType() {
            return DamageType.ENERGY;
        }
    }
}

