/*
 * Decompiled with CFR 0.152.
 */
package techguns.entities.projectiles;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import techguns.TGPackets;
import techguns.Techguns;
import techguns.api.damagesystem.DamageType;
import techguns.capabilities.TGExtendedPlayer;
import techguns.client.ClientProxy;
import techguns.damagesystem.TGExplosion;
import techguns.entities.projectiles.EnumBulletFirePos;
import techguns.entities.projectiles.RocketProjectile;
import techguns.items.guns.GenericGun;
import techguns.items.guns.IChargedProjectileFactory;
import techguns.packets.PacketSpawnParticle;
import techguns.util.MathUtil;

public class GuidedMissileProjectile
extends RocketProjectile {
    public static final double MAX_TURN_ANGLE = 0.15707963267948966;
    public Entity target;

    public GuidedMissileProjectile(World par2World, EntityLivingBase p, float damage, float speed, int TTL, float spread, float dmgDropStart, float dmgDropEnd, float dmgMin, float penetration, boolean blockdamage, EnumBulletFirePos leftGun, float radius, double gravity) {
        super(par2World, p, damage, speed, TTL, spread, dmgDropStart, dmgDropEnd, dmgMin, penetration, blockdamage, leftGun, radius, gravity);
    }

    public GuidedMissileProjectile(World par2World, EntityLivingBase p, float damage, float speed, int TTL, float spread, float dmgDropStart, float dmgDropEnd, float dmgMin, float penetration, boolean blockdamage, EnumBulletFirePos leftGun, float radius, Entity target) {
        super(par2World, p, damage, speed, TTL, spread, dmgDropStart, dmgDropEnd, dmgMin, penetration, blockdamage, leftGun, radius, 0.0);
        this.target = target;
    }

    public GuidedMissileProjectile(World worldIn) {
        super(worldIn);
    }

    @Override
    protected void createTrailFX() {
        ClientProxy.get().createFXOnEntity("GuidedMissileExhaust", this);
    }

    @Override
    protected void explodeRocket() {
        if (!this.field_70170_p.field_72995_K) {
            TGPackets.network.sendToAllAround((IMessage)new PacketSpawnParticle("GuidedMissileExplosion", this.field_70165_t, this.field_70163_u, this.field_70161_v), TGPackets.targetPointAroundEnt(this, 50.0));
            TGExplosion explosion = new TGExplosion(this.field_70170_p, (Entity)this.shooter, this, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.damage, this.damageMin, this.damageDropStart, this.damageDropEnd, this.blockdamage ? 0.25 : 0.0);
            explosion.doExplosion(true);
        } else {
            Techguns.proxy.createLightPulse(this.field_70165_t, this.field_70163_u, this.field_70161_v, 5, 15, 10.0f, 1.0f, 1.0f, 0.9f, 0.5f);
        }
        this.func_70106_y();
    }

    @Override
    public void readSpawnData(ByteBuf additionalData) {
        super.readSpawnData(additionalData);
        int entityID = additionalData.readInt();
        if (entityID != -1) {
            this.target = this.field_70170_p.func_73045_a(entityID);
        }
    }

    @Override
    public void writeSpawnData(ByteBuf buffer) {
        super.writeSpawnData(buffer);
        if (this.target != null) {
            buffer.writeInt(this.target.func_145782_y());
        } else {
            buffer.writeInt(-1);
        }
    }

    @Override
    public void func_70071_h_() {
        if (this.target != null) {
            Vec3d motion = new Vec3d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            double speed = motion.func_72433_c();
            Vec3d v2 = new Vec3d(this.target.field_70165_t, this.target.field_70163_u + (double)(this.target.field_70131_O * 0.5f), this.target.field_70161_v).func_178788_d(new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v)).func_72432_b();
            Vec3d v1 = motion.func_72432_b();
            double angle = Math.acos(v1.func_72430_b(v2));
            Vec3d axis = v1.func_72431_c(v2).func_72432_b();
            motion = angle < 0.15707963267948966 ? v2.func_186678_a(speed) : MathUtil.rotateVector(v1, axis, 0.15707963267948966).func_186678_a(speed);
            this.field_70159_w = motion.field_72450_a;
            this.field_70181_x = motion.field_72448_b;
            this.field_70179_y = motion.field_72449_c;
        }
        super.func_70071_h_();
    }

    public static class Factory
    implements IChargedProjectileFactory<GuidedMissileProjectile> {
        @Override
        public GuidedMissileProjectile createProjectile(GenericGun gun, World world, EntityLivingBase p, float damage, float speed, int TTL, float spread, float dmgDropStart, float dmgDropEnd, float dmgMin, float penetration, boolean blockdamage, EnumBulletFirePos firePos, float radius, double gravity) {
            Entity target = null;
            if (p instanceof EntityPlayer) {
                TGExtendedPlayer epc = TGExtendedPlayer.get((EntityPlayer)p);
                if (epc.lockOnEntity != null && epc.lockOnTicks >= ((GenericGun)p.func_184607_cu().func_77973_b()).getLockOnTicks()) {
                    target = epc.lockOnEntity;
                }
            }
            if (target != null) {
                return new GuidedMissileProjectile(world, p, damage, speed, TTL, spread, dmgDropStart, dmgDropEnd, dmgMin, penetration, blockdamage, firePos, radius, target);
            }
            return new GuidedMissileProjectile(world, p, damage, speed, TTL, spread, dmgDropStart, dmgDropEnd, dmgMin, penetration, blockdamage, firePos, radius, 0.01f);
        }

        @Override
        public DamageType getDamageType() {
            return DamageType.EXPLOSION;
        }

        @Override
        public GuidedMissileProjectile createChargedProjectile(World world, EntityLivingBase p, float damage, float speed, int TTL, float spread, float dmgDropStart, float dmgDropEnd, float dmgMin, float penetration, boolean blockdamage, EnumBulletFirePos firePos, float radius, double gravity, float charge, int ammoConsumed) {
            return null;
        }
    }
}

