/*
 * Decompiled with CFR 0.152.
 */
package techguns.entities.projectiles;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import io.netty.buffer.ByteBuf;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import techguns.TGPackets;
import techguns.api.damagesystem.DamageType;
import techguns.api.npc.INPCTechgunsShooter;
import techguns.api.npc.factions.ITGNpcTeam;
import techguns.damagesystem.DamageSystem;
import techguns.damagesystem.TGDamageSource;
import techguns.deatheffects.EntityDeathUtils;
import techguns.entities.projectiles.EnumBulletFirePos;
import techguns.factions.TGNpcFactions;
import techguns.items.guns.GenericGun;
import techguns.items.guns.IProjectileFactory;
import techguns.packets.PacketGunImpactFX;

public class GenericProjectile
extends Entity
implements IProjectile,
IEntityAdditionalSpawnData {
    public static final Predicate<Entity> BULLET_TARGETS = Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_188444_d, EntitySelectors.field_94557_a, new Predicate<Entity>(){

        public boolean apply(@Nullable Entity ent) {
            return ent.func_70067_L();
        }
    }});
    float damage;
    public float speed = 1.0f;
    protected int ticksToLive = 100;
    protected int lifetime = 100;
    float damageDropStart;
    float damageDropEnd;
    float damageMin;
    protected EntityLivingBase shooter;
    float penetration = 0.0f;
    boolean silenced = false;
    protected boolean blockdamage = false;
    boolean posInitialized = false;
    double startX;
    double startY;
    double startZ;
    float radius = 0.0f;
    double gravity = 0.0;

    public GenericProjectile(World worldIn) {
        super(worldIn);
        this.field_70178_ae = true;
        this.func_189654_d(true);
        this.field_70131_O = 0.5f;
        this.func_70105_a(0.25f, 0.25f);
    }

    public GenericProjectile(World par2World, EntityLivingBase p, float damage, float speed, int TTL, float spread, float dmgDropStart, float dmgDropEnd, float dmgMin, float penetration, boolean blockdamage, EnumBulletFirePos firePos) {
        this(par2World);
        this.shooter = p;
        this.initProjectile(par2World, p.field_70165_t, p.field_70163_u + (double)p.func_70047_e(), p.field_70161_v, p.field_70759_as, p.field_70125_A, damage, speed, TTL, spread, dmgDropStart, dmgDropEnd, dmgMin, penetration, blockdamage, firePos);
    }

    public GenericProjectile(World worldIn, double posX, double posY, double posZ, float yaw, float pitch, float damage, float speed, int TTL, float spread, float dmgDropStart, float dmgDropEnd, float dmgMin, float penetration, boolean blockdamage, EnumBulletFirePos firePos) {
        this(worldIn);
        this.shooter = null;
        this.initProjectile(worldIn, posX, posY, posZ, yaw, pitch, damage, speed, TTL, spread, dmgDropStart, dmgDropEnd, dmgMin, penetration, blockdamage, firePos);
    }

    private void initProjectile(World worldIn, double posX, double posY, double posZ, float yaw, float pitch, float damage, float speed, int TTL, float spread, float dmgDropStart, float dmgDropEnd, float dmgMin, float penetration, boolean blockdamage, EnumBulletFirePos firePos) {
        float offsetSide = 0.16f;
        float offsetHeight = 0.0f;
        if (this.shooter != null && this.shooter instanceof INPCTechgunsShooter) {
            INPCTechgunsShooter tgshooter = (INPCTechgunsShooter)this.shooter;
            offsetSide += tgshooter.getBulletOffsetSide();
            offsetHeight += tgshooter.getBulletOffsetHeight();
        }
        this.func_70012_b(posX, posY, posZ, yaw + (float)((double)spread - 2.0 * Math.random() * (double)spread) * 40.0f, pitch + (float)((double)spread - 2.0 * Math.random() * (double)spread) * 40.0f);
        if (firePos == EnumBulletFirePos.RIGHT) {
            this.field_70165_t -= (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * offsetSide);
            this.field_70161_v -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * offsetSide);
        } else if (firePos == EnumBulletFirePos.LEFT) {
            this.field_70165_t += (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * offsetSide);
            this.field_70161_v += (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * offsetSide);
        }
        this.field_70163_u += (double)-0.1f + (double)offsetHeight;
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        float f = 0.4f;
        this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * f;
        this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * f;
        this.field_70181_x = -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * f;
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, 1.5f, 1.0f);
        Vec3d motion = new Vec3d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        motion.func_72432_b();
        this.field_70159_w = motion.field_72450_a;
        this.field_70181_x = motion.field_72448_b;
        this.field_70179_y = motion.field_72449_c;
        this.field_70159_w *= (double)speed;
        this.field_70181_x *= (double)speed;
        this.field_70179_y *= (double)speed;
        this.damage = damage;
        this.speed = speed;
        this.ticksToLive = TTL;
        this.lifetime = TTL;
        this.penetration = penetration;
        this.damageMin = dmgMin;
        this.damageDropStart = dmgDropStart;
        this.damageDropEnd = dmgDropEnd;
        this.blockdamage = blockdamage;
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
        float f = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
        x /= (double)f;
        y /= (double)f;
        z /= (double)f;
        x += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        y += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        z += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        this.field_70159_w = x *= (double)velocity;
        this.field_70181_x = y *= (double)velocity;
        this.field_70179_y = z *= (double)velocity;
        float f1 = MathHelper.func_76133_a((double)(x * x + z * z));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.29577951308232);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f1) * 57.29577951308232);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
    }

    public void func_70071_h_() {
        RayTraceResult raytraceresultEntity;
        if (!this.posInitialized && !this.field_70170_p.field_72995_K) {
            this.initStartPos();
        }
        this.field_70142_S = this.field_70165_t;
        this.field_70137_T = this.field_70163_u;
        this.field_70136_U = this.field_70161_v;
        super.func_70071_h_();
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y) * 57.29577951308232);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)f) * 57.29577951308232);
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
        }
        --this.ticksToLive;
        Vec3d vec3d1 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d vec3d = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        RayTraceResult raytraceresult = this.field_70170_p.func_147447_a(vec3d1, vec3d, false, true, false);
        vec3d1 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        vec3d = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        if (raytraceresult != null) {
            vec3d = new Vec3d(raytraceresult.field_72307_f.field_72450_a, raytraceresult.field_72307_f.field_72448_b, raytraceresult.field_72307_f.field_72449_c);
        }
        if ((raytraceresultEntity = this.findEntityOnPath(vec3d1, vec3d)) != null) {
            raytraceresult = raytraceresultEntity;
        }
        if (raytraceresult != null && raytraceresult.field_72308_g != null && raytraceresult.field_72308_g instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)raytraceresult.field_72308_g;
            if (this.shooter instanceof EntityPlayer && !((EntityPlayer)this.shooter).func_96122_a(entityplayer)) {
                raytraceresult = null;
            }
        }
        if (raytraceresult != null) {
            this.onHit(raytraceresult);
        }
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        float f4 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y) * 57.29577951308232);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)f4) * 57.29577951308232);
        if (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        if (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        if (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        if (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
        this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
        float f1 = 0.99f;
        f1 = this.inWaterUpdateBehaviour(f1);
        this.field_70159_w *= (double)f1;
        this.field_70181_x *= (double)f1;
        this.field_70179_y *= (double)f1;
        if (this.gravity != 0.0) {
            this.field_70181_x -= this.gravity;
        }
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.func_145775_I();
        if (this.ticksToLive <= 0) {
            this.func_70106_y();
        }
    }

    protected float inWaterUpdateBehaviour(float f1) {
        if (this.func_70090_H()) {
            for (int i = 0; i < 4; ++i) {
                float f3 = 0.25f;
                this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - this.field_70159_w * 0.25, this.field_70163_u - this.field_70181_x * 0.25, this.field_70161_v - this.field_70179_y * 0.25, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
            }
            f1 = 0.85f;
        }
        if (this.func_70026_G()) {
            this.func_70066_B();
        }
        return f1;
    }

    protected void initStartPos() {
        this.startX = this.field_70165_t;
        this.startY = this.field_70163_u;
        this.startZ = this.field_70161_v;
        this.posInitialized = true;
    }

    @Nullable
    protected RayTraceResult findEntityOnPath(Vec3d start, Vec3d end) {
        Entity entity = null;
        List list = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_186662_g(1.0), BULLET_TARGETS);
        double d0 = 0.0;
        Vec3d hitPos = null;
        for (int i = 0; i < list.size(); ++i) {
            double d1;
            AxisAlignedBB axisalignedbb;
            RayTraceResult raytraceresult;
            Entity entity1 = (Entity)list.get(i);
            if (entity1 == this.shooter || (raytraceresult = (axisalignedbb = entity1.func_174813_aQ().func_186662_g((double)0.3f)).func_72327_a(start, end)) == null || !((d1 = start.func_72436_e(raytraceresult.field_72307_f)) < d0) && d0 != 0.0) continue;
            entity = entity1;
            d0 = d1;
            hitPos = raytraceresult.field_72307_f;
        }
        if (entity != null) {
            return new RayTraceResult(entity, hitPos);
        }
        return null;
    }

    public float func_70047_e() {
        return 0.25f;
    }

    protected void onHit(RayTraceResult raytraceResultIn) {
        if (raytraceResultIn.field_72308_g != null && !this.field_70170_p.field_72995_K) {
            TGDamageSource src = this.getProjectileDamageSource();
            if (raytraceResultIn.field_72308_g instanceof EntityLivingBase) {
                EntityLivingBase ent = (EntityLivingBase)raytraceResultIn.field_72308_g;
                float dmg = DamageSystem.getDamageFactor(this.shooter, ent) * this.getDamage();
                if (dmg > 0.0f) {
                    if (src.knockbackMultiplier == 0.0f) {
                        TGDamageSource knockback = TGDamageSource.getKnockbackDummyDmgSrc(this, (Entity)this.shooter);
                        ent.func_70097_a((DamageSource)knockback, 0.01f);
                    }
                    ent.func_70097_a((DamageSource)src, dmg);
                    if (src.wasSuccessful()) {
                        if (ent instanceof EntityLiving) {
                            this.setAIRevengeTarget((EntityLiving)ent);
                        }
                        this.onHitEffect(ent, raytraceResultIn);
                    }
                }
            } else {
                raytraceResultIn.field_72308_g.func_70097_a((DamageSource)src, this.getDamage());
            }
            this.func_70106_y();
        }
        RayTraceResult.Type cfr_ignored_0 = raytraceResultIn.field_72313_a;
        if (raytraceResultIn.field_72313_a == RayTraceResult.Type.BLOCK) {
            this.hitBlock(raytraceResultIn);
            this.func_70106_y();
        }
    }

    protected void setAIRevengeTarget(EntityLiving ent) {
        boolean shootBack = false;
        if (this.shooter != null) {
            if (this.shooter instanceof ITGNpcTeam && ent instanceof ITGNpcTeam) {
                shootBack = TGNpcFactions.isHostile(((ITGNpcTeam)this.shooter).getTGFaction(), ((ITGNpcTeam)ent).getTGFaction());
            } else if (!(this.shooter instanceof EntityPlayer)) {
                shootBack = true;
            }
        }
        if (shootBack) {
            ent.func_70604_c(this.shooter);
        }
    }

    public void shiftForward(float factor) {
        this.field_70165_t += this.field_70159_w * (double)factor;
        this.field_70163_u += this.field_70181_x * (double)factor;
        this.field_70161_v += this.field_70179_y * (double)factor;
    }

    protected void onHitEffect(EntityLivingBase ent, RayTraceResult rayTraceResultIn) {
    }

    protected void hitBlock(RayTraceResult raytraceResultIn) {
        BlockPos targetPos = raytraceResultIn.func_178782_a();
        IBlockState target = this.field_70170_p.func_180495_p(targetPos);
        Material mat = target.func_185904_a();
        SoundType sound = target.func_177230_c().getSoundType(target, this.field_70170_p, targetPos, (Entity)this);
        this.doImpactEffects(mat, raytraceResultIn, sound);
    }

    protected void doImpactEffects(Material mat, RayTraceResult rayTraceResult, SoundType sound) {
        double x = rayTraceResult.field_72307_f.field_72450_a;
        double y = rayTraceResult.field_72307_f.field_72448_b;
        double z = rayTraceResult.field_72307_f.field_72449_c;
        boolean distdelay = true;
        float pitch = 0.0f;
        float yaw = 0.0f;
        if (rayTraceResult.field_72313_a == RayTraceResult.Type.BLOCK) {
            if (rayTraceResult.field_178784_b == EnumFacing.UP) {
                pitch = -90.0f;
            } else if (rayTraceResult.field_178784_b == EnumFacing.DOWN) {
                pitch = 90.0f;
            } else {
                yaw = rayTraceResult.field_178784_b.func_185119_l();
            }
        } else {
            pitch = -this.field_70125_A;
            yaw = -this.field_70177_z;
        }
        int type = -1;
        if (sound == SoundType.field_185851_d) {
            type = 0;
        } else if (sound == SoundType.field_185848_a || sound == SoundType.field_185857_j) {
            type = 1;
        } else if (sound == SoundType.field_185853_f) {
            type = 2;
        } else if (sound == SoundType.field_185852_e || sound == SoundType.field_185858_k) {
            type = 3;
        } else if (sound == SoundType.field_185849_b || sound == SoundType.field_185855_h) {
            type = 4;
        }
        this.sendImpactFX(x, y, z, pitch, yaw, type);
    }

    protected void sendImpactFX(double x, double y, double z, float pitch, float yaw, int type) {
        this.sendImpactFX(x, y, z, pitch, yaw, type, false);
    }

    protected void sendImpactFX(double x, double y, double z, float pitch, float yaw, int type, boolean incendiary) {
        if (!this.field_70170_p.field_72995_K) {
            TGPackets.network.sendToAllAround((IMessage)new PacketGunImpactFX((short)type, x, y, z, pitch, yaw, incendiary), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.getDimension(), x, y, z, 128.0));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double x, double y, double z) {
    }

    protected TGDamageSource getProjectileDamageSource() {
        TGDamageSource src = TGDamageSource.causeBulletDamage(this, (Entity)this.shooter, EntityDeathUtils.DeathType.GORE);
        src.armorPenetration = this.penetration;
        src.setNoKnockback();
        return src;
    }

    protected double getDistanceTravelled() {
        Vec3d start = new Vec3d(this.startX, this.startY, this.startZ);
        Vec3d end = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        return start.func_72438_d(end);
    }

    public GenericProjectile setSilenced() {
        this.silenced = true;
        return this;
    }

    protected float getDamage() {
        if (this.damageDropEnd == 0.0f) {
            return this.damage;
        }
        double distance = this.getDistanceTravelled();
        if (distance <= (double)this.damageDropStart) {
            return this.damage;
        }
        if (distance > (double)this.damageDropEnd) {
            return this.damageMin;
        }
        float factor = 1.0f - (float)((distance - (double)this.damageDropStart) / (double)(this.damageDropEnd - this.damageDropStart));
        return this.damageMin + (this.damage - this.damageMin) * factor;
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound tags) {
        this.damage = tags.func_74760_g("damage");
        this.speed = tags.func_74760_g("speed");
        this.ticksToLive = tags.func_74765_d("ticksToLive");
        this.lifetime = tags.func_74765_d("lifetime");
        this.damageDropStart = tags.func_74765_d("damageDropStart");
        this.damageDropEnd = tags.func_74765_d("damageDropEnd");
        this.damageMin = tags.func_74760_g("damageMin");
        this.gravity = tags.func_74760_g("gravity");
    }

    protected void func_70014_b(NBTTagCompound tags) {
        tags.func_74776_a("damage", this.damage);
        tags.func_74776_a("speed", this.speed);
        tags.func_74777_a("ticksToLive", (short)this.ticksToLive);
        tags.func_74777_a("lifetime", (short)this.lifetime);
        tags.func_74777_a("damageDropStart", (short)this.damageDropStart);
        tags.func_74777_a("damageDropEnd", (short)this.damageDropEnd);
        tags.func_74776_a("damageMin", this.damageMin);
        if (this.gravity != 0.0) {
            tags.func_74776_a("gravity", (float)this.gravity);
        }
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeFloat(this.speed);
        buffer.writeDouble(this.field_70159_w);
        buffer.writeDouble(this.field_70181_x);
        buffer.writeDouble(this.field_70179_y);
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.speed = additionalData.readFloat();
        this.field_70159_w = additionalData.readDouble();
        this.field_70181_x = additionalData.readDouble();
        this.field_70179_y = additionalData.readDouble();
    }

    public static void burnBlocks(World world, RayTraceResult mop, double chanceToIgnite) {
        if (world.field_72995_K) {
            return;
        }
        if (Math.random() <= chanceToIgnite) {
            BlockPos hit = mop.func_178782_a();
            switch (mop.field_178784_b) {
                case DOWN: {
                    if (!world.func_175623_d(hit.func_177977_b())) break;
                    world.func_175656_a(hit.func_177977_b(), Blocks.field_150480_ab.func_176223_P());
                    break;
                }
                case UP: {
                    if (!world.func_175623_d(hit.func_177984_a())) break;
                    if (world.func_180495_p(hit) == Blocks.field_150458_ak) {
                        world.func_175656_a(hit, Blocks.field_150346_d.func_176223_P());
                    }
                    world.func_175656_a(hit.func_177984_a(), Blocks.field_150480_ab.func_176223_P());
                    break;
                }
                default: {
                    BlockPos p = hit.func_177972_a(mop.field_178784_b);
                    if (!world.func_175623_d(p)) break;
                    world.func_175656_a(p, Blocks.field_150480_ab.func_176223_P());
                }
            }
        }
    }

    public static class Factory
    implements IProjectileFactory<GenericProjectile> {
        @Override
        public GenericProjectile createProjectile(GenericGun gun, World world, EntityLivingBase p, float damage, float speed, int TTL, float spread, float dmgDropStart, float dmgDropEnd, float dmgMin, float penetration, boolean blockdamage, EnumBulletFirePos firePos, float radius, double gravity) {
            return new GenericProjectile(world, p, damage, speed, TTL, spread, dmgDropStart, dmgDropEnd, dmgMin, penetration, blockdamage, firePos);
        }

        @Override
        public DamageType getDamageType() {
            return DamageType.PROJECTILE;
        }
    }
}

