/*
 * Decompiled with CFR 0.152.
 */
package techguns.entities.projectiles;

import elucent.albedo.event.GatherLightsEvent;
import elucent.albedo.lighting.ILightProvider;
import elucent.albedo.lighting.Light;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import techguns.TGPackets;
import techguns.TGSounds;
import techguns.Techguns;
import techguns.api.damagesystem.DamageType;
import techguns.client.ClientProxy;
import techguns.entities.projectiles.AdvancedBulletProjectile;
import techguns.entities.projectiles.EnumBulletFirePos;
import techguns.items.guns.GenericGun;
import techguns.items.guns.IProjectileFactory;
import techguns.packets.PacketSpawnParticle;
import techguns.packets.PacketSpawnParticleOnEntity;
import techguns.util.MathUtil;

@Optional.Interface(iface="elucent.albedo.lighting.ILightProvider", modid="albedo")
public class GaussProjectile
extends AdvancedBulletProjectile
implements ILightProvider {
    public GaussProjectile(World par2World, EntityLivingBase p, float damage, float speed, int TTL, float spread, float dmgDropStart, float dmgDropEnd, float dmgMin, float penetration, boolean blockdamage, EnumBulletFirePos leftGun) {
        super(par2World, p, damage, speed, TTL, spread, dmgDropStart, dmgDropEnd, dmgMin, penetration, blockdamage, leftGun);
    }

    public GaussProjectile(World worldIn) {
        super(worldIn);
        if (worldIn.field_72995_K) {
            ClientProxy.get().createFXOnEntity("GaussProjectileTrail", this);
        }
    }

    @Override
    protected void doImpactEffects(Material mat, RayTraceResult rayTraceResult, SoundType sound) {
        double x = rayTraceResult.field_72307_f.field_72450_a;
        double y = rayTraceResult.field_72307_f.field_72448_b;
        double z = rayTraceResult.field_72307_f.field_72449_c;
        boolean distdelay = true;
        float pitch = 0.0f;
        float yaw = 0.0f;
        if (rayTraceResult.field_72313_a == RayTraceResult.Type.BLOCK) {
            if (rayTraceResult.field_178784_b == EnumFacing.UP) {
                pitch = -90.0f;
            } else if (rayTraceResult.field_178784_b == EnumFacing.DOWN) {
                pitch = 90.0f;
            } else {
                yaw = rayTraceResult.field_178784_b.func_185119_l();
            }
        } else {
            pitch = -this.field_70125_A;
            yaw = -this.field_70177_z;
        }
        if (sound == SoundType.field_185851_d) {
            this.field_70170_p.func_184134_a(x, y, z, TGSounds.BULLET_IMPACT_STONE, SoundCategory.AMBIENT, 1.0f, 1.0f, distdelay);
            Techguns.proxy.createFX("Impact_BulletRock_Blue", this.field_70170_p, x, y, z, 0.0, 0.0, 0.0, pitch, yaw);
        } else if (sound == SoundType.field_185848_a || sound == SoundType.field_185857_j) {
            this.field_70170_p.func_184134_a(x, y, z, TGSounds.BULLET_IMPACT_WOOD, SoundCategory.AMBIENT, 1.0f, 1.0f, distdelay);
            Techguns.proxy.createFX("Impact_BulletWood_Blue", this.field_70170_p, x, y, z, 0.0, 0.0, 0.0, pitch, yaw);
        } else if (sound == SoundType.field_185853_f) {
            this.field_70170_p.func_184134_a(x, y, z, TGSounds.BULLET_IMPACT_GLASS, SoundCategory.AMBIENT, 1.0f, 1.0f, distdelay);
            Techguns.proxy.createFX("Impact_BulletGlass_Blue", this.field_70170_p, x, y, z, 0.0, 0.0, 0.0, pitch, yaw);
        } else if (sound == SoundType.field_185852_e || sound == SoundType.field_185858_k) {
            this.field_70170_p.func_184134_a(x, y, z, TGSounds.BULLET_IMPACT_METAL, SoundCategory.AMBIENT, 1.0f, 1.0f, distdelay);
            Techguns.proxy.createFX("Impact_BulletMetal_Blue", this.field_70170_p, x, y, z, 0.0, 0.0, 0.0, pitch, yaw);
        } else if (sound == SoundType.field_185849_b || sound == SoundType.field_185855_h) {
            this.field_70170_p.func_184134_a(x, y, z, TGSounds.BULLET_IMPACT_DIRT, SoundCategory.AMBIENT, 1.0f, 1.0f, distdelay);
            Techguns.proxy.createFX("Impact_BulletDirt_Blue", this.field_70170_p, x, y, z, 0.0, 0.0, 0.0, pitch, yaw);
        } else {
            this.field_70170_p.func_184134_a(x, y, z, TGSounds.BULLET_IMPACT_DIRT, SoundCategory.AMBIENT, 1.0f, 1.0f, distdelay);
            Techguns.proxy.createFX("Impact_BulletDefault_Blue", this.field_70170_p, x, y, z, 0.0, 0.0, 0.0, pitch, yaw);
        }
    }

    @Override
    protected void onHitEffect(EntityLivingBase ent, RayTraceResult rayTraceResult) {
        super.onHitEffect(ent, rayTraceResult);
        double x = rayTraceResult.field_72307_f.field_72450_a;
        double y = rayTraceResult.field_72307_f.field_72448_b;
        double z = rayTraceResult.field_72307_f.field_72449_c;
        Techguns.proxy.createFX("GaussRifleImpact_Block", this.field_70170_p, x, y, z, 0.0, 0.0, 0.0);
        Techguns.proxy.createLightPulse(x, y, z, 5, 10, 3.0f, 1.0f, 0.5f, 0.75f, 1.0f);
    }

    @Override
    protected void hitBlock(RayTraceResult raytraceResultIn) {
        super.hitBlock(raytraceResultIn);
        double x = raytraceResultIn.field_72307_f.field_72450_a;
        double y = raytraceResultIn.field_72307_f.field_72448_b;
        double z = raytraceResultIn.field_72307_f.field_72449_c;
        if (!this.field_70170_p.field_72995_K) {
            TGPackets.network.sendToAllAround((IMessage)new PacketSpawnParticle("GaussRifleImpact_Block", x, y, z), TGPackets.targetPointAroundEnt(this, 50.0));
        } else {
            Techguns.proxy.createLightPulse(x, y, z, 5, 10, 3.0f, 1.0f, 0.5f, 0.75f, 1.0f);
        }
    }

    @Optional.Method(modid="albedo")
    public Light provideLight() {
        return Light.builder().pos(MathUtil.getInterpolatedEntityPos(this)).color(0.5f, 0.75f, 1.0f).radius(2.5f).build();
    }

    @Optional.Method(modid="albedo")
    public void gatherLights(GatherLightsEvent evt, Entity ent) {
    }

    public static class Factory
    implements IProjectileFactory<GaussProjectile> {
        @Override
        public GaussProjectile createProjectile(GenericGun gun, World world, EntityLivingBase p, float damage, float speed, int TTL, float spread, float dmgDropStart, float dmgDropEnd, float dmgMin, float penetration, boolean blockdamage, EnumBulletFirePos firePos, float radius, double gravity) {
            float offsetX = 0.0f;
            if (firePos == EnumBulletFirePos.RIGHT) {
                offsetX = -0.14f;
            } else if (firePos == EnumBulletFirePos.LEFT) {
                offsetX = 0.14f;
            }
            float offsetY = -0.09f;
            float offsetZ = 0.5f;
            TGPackets.network.sendToAllAround((IMessage)new PacketSpawnParticleOnEntity("GaussFireFX", (Entity)p, offsetX, offsetY, offsetZ, true), TGPackets.targetPointAroundEnt((Entity)p, 25.0));
            return new GaussProjectile(world, p, damage, speed, TTL, spread, dmgDropStart, dmgDropEnd, dmgMin, penetration, blockdamage, firePos);
        }

        @Override
        public DamageType getDamageType() {
            return DamageType.PROJECTILE;
        }
    }
}

