/*
 * Decompiled with CFR 0.152.
 */
package techguns.entities.projectiles;

import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import techguns.TGSounds;
import techguns.Techguns;
import techguns.api.damagesystem.DamageType;
import techguns.entities.projectiles.EnumBulletFirePos;
import techguns.entities.projectiles.GenericProjectile;
import techguns.items.guns.GenericGun;
import techguns.items.guns.IProjectileFactory;

public class AdvancedBulletProjectile
extends GenericProjectile {
    public AdvancedBulletProjectile(World world, EntityLivingBase p, float damage, float speed, int TTL, float spread, float dmgDropStart, float dmgDropEnd, float dmgMin, float penetration, boolean blockdamage, EnumBulletFirePos leftGun) {
        super(world, p, damage, speed, TTL, spread, dmgDropStart, dmgDropEnd, dmgMin, penetration, blockdamage, leftGun);
    }

    public AdvancedBulletProjectile(World worldIn) {
        super(worldIn);
    }

    @Override
    protected void doImpactEffects(Material mat, RayTraceResult rayTraceResult, SoundType sound) {
        double x = rayTraceResult.field_72307_f.field_72450_a;
        double y = rayTraceResult.field_72307_f.field_72448_b;
        double z = rayTraceResult.field_72307_f.field_72449_c;
        boolean distdelay = true;
        float pitch = 0.0f;
        float yaw = 0.0f;
        if (rayTraceResult.field_72313_a == RayTraceResult.Type.BLOCK) {
            if (rayTraceResult.field_178784_b == EnumFacing.UP) {
                pitch = -90.0f;
            } else if (rayTraceResult.field_178784_b == EnumFacing.DOWN) {
                pitch = 90.0f;
            } else {
                yaw = rayTraceResult.field_178784_b.func_185119_l();
            }
        } else {
            pitch = -this.field_70125_A;
            yaw = -this.field_70177_z;
        }
        if (sound == SoundType.field_185851_d) {
            this.field_70170_p.func_184134_a(x, y, z, TGSounds.BULLET_IMPACT_STONE, SoundCategory.AMBIENT, 1.0f, 1.0f, distdelay);
            Techguns.proxy.createFX("Impact_BulletRock_Blue", this.field_70170_p, x, y, z, 0.0, 0.0, 0.0, pitch, yaw);
        } else if (sound == SoundType.field_185848_a || sound == SoundType.field_185857_j) {
            this.field_70170_p.func_184134_a(x, y, z, TGSounds.BULLET_IMPACT_WOOD, SoundCategory.AMBIENT, 1.0f, 1.0f, distdelay);
            Techguns.proxy.createFX("Impact_BulletWood_Blue", this.field_70170_p, x, y, z, 0.0, 0.0, 0.0, pitch, yaw);
        } else if (sound == SoundType.field_185853_f) {
            this.field_70170_p.func_184134_a(x, y, z, TGSounds.BULLET_IMPACT_GLASS, SoundCategory.AMBIENT, 1.0f, 1.0f, distdelay);
            Techguns.proxy.createFX("Impact_BulletGlass_Blue", this.field_70170_p, x, y, z, 0.0, 0.0, 0.0, pitch, yaw);
        } else if (sound == SoundType.field_185852_e || sound == SoundType.field_185858_k) {
            this.field_70170_p.func_184134_a(x, y, z, TGSounds.BULLET_IMPACT_METAL, SoundCategory.AMBIENT, 1.0f, 1.0f, distdelay);
            Techguns.proxy.createFX("Impact_BulletMetal_Blue", this.field_70170_p, x, y, z, 0.0, 0.0, 0.0, pitch, yaw);
        } else if (sound == SoundType.field_185849_b || sound == SoundType.field_185855_h) {
            this.field_70170_p.func_184134_a(x, y, z, TGSounds.BULLET_IMPACT_DIRT, SoundCategory.AMBIENT, 1.0f, 1.0f, distdelay);
            Techguns.proxy.createFX("Impact_BulletDirt_Blue", this.field_70170_p, x, y, z, 0.0, 0.0, 0.0, pitch, yaw);
        } else {
            this.field_70170_p.func_184134_a(x, y, z, TGSounds.BULLET_IMPACT_DIRT, SoundCategory.AMBIENT, 1.0f, 1.0f, distdelay);
            Techguns.proxy.createFX("Impact_BulletDefault_Blue", this.field_70170_p, x, y, z, 0.0, 0.0, 0.0, pitch, yaw);
        }
    }

    public static class Factory
    implements IProjectileFactory<AdvancedBulletProjectile> {
        @Override
        public AdvancedBulletProjectile createProjectile(GenericGun gun, World world, EntityLivingBase p, float damage, float speed, int TTL, float spread, float dmgDropStart, float dmgDropEnd, float dmgMin, float penetration, boolean blockdamage, EnumBulletFirePos firePos, float radius, double gravity) {
            return new AdvancedBulletProjectile(world, p, damage, speed, TTL, spread, dmgDropStart, dmgDropEnd, dmgMin, penetration, blockdamage, firePos);
        }

        @Override
        public DamageType getDamageType() {
            return DamageType.PROJECTILE;
        }
    }
}

