/*
 * Decompiled with CFR 0.152.
 */
package techguns.entities.projectiles;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import techguns.entities.projectiles.EnumBulletFirePos;
import techguns.entities.projectiles.GenericProjectile;

public abstract class AbstractBeamProjectile
extends GenericProjectile {
    public double distance = -1.0;
    public float laserPitch = 0.0f;
    public float laserYaw = 0.0f;
    public short maxTicks = 0;

    public AbstractBeamProjectile(World worldIn) {
        super(worldIn);
    }

    public AbstractBeamProjectile(World par2World, EntityLivingBase p, float damage, float speed, int TTL, float spread, float dmgDropStart, float dmgDropEnd, float dmgMin, float penetration, boolean blockdamage, EnumBulletFirePos leftGun) {
        super(par2World, p, damage, speed, TTL, spread, dmgDropStart, dmgDropEnd, dmgMin, penetration, blockdamage, leftGun);
        this.maxTicks = (short)this.ticksToLive;
    }

    public AbstractBeamProjectile(World worldIn, double posX, double posY, double posZ, float yaw, float pitch, float damage, float speed, int TTL, float spread, float dmgDropStart, float dmgDropEnd, float dmgMin, float penetration, boolean blockdamage, EnumBulletFirePos leftGun) {
        super(worldIn, posX, posY, posZ, yaw, pitch, damage, speed, TTL, spread, dmgDropStart, dmgDropEnd, dmgMin, penetration, blockdamage, leftGun);
        this.maxTicks = (short)this.ticksToLive;
    }

    protected void trace() {
        RayTraceResult rayTraceResultEntity;
        Vec3d vec3d1 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d vec3d = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        RayTraceResult raytraceresult = this.field_70170_p.func_147447_a(vec3d1, vec3d, false, true, false);
        if (raytraceresult != null) {
            vec3d = new Vec3d(raytraceresult.field_72307_f.field_72450_a, raytraceresult.field_72307_f.field_72448_b, raytraceresult.field_72307_f.field_72449_c);
        }
        if ((rayTraceResultEntity = this.findEntityOnPath(vec3d1, vec3d)) != null) {
            raytraceresult = rayTraceResultEntity;
        }
        if (raytraceresult != null && raytraceresult.field_72308_g instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)raytraceresult.field_72308_g;
            if (this.shooter instanceof EntityPlayer && !((EntityPlayer)this.shooter).func_96122_a(entityplayer)) {
                raytraceresult = null;
            }
        }
        if (raytraceresult != null) {
            this.onHit(raytraceresult);
            this.field_70128_L = false;
            Vec3d hitVec = raytraceresult.field_72307_f;
            this.distance = vec3d1.func_72438_d(hitVec);
        }
        this.laserPitch = this.field_70125_A;
        this.laserYaw = this.field_70177_z;
        if (this.distance <= 0.0) {
            this.distance = this.speed;
        }
    }

    @Override
    public void func_70071_h_() {
        --this.ticksToLive;
        if (this.ticksToLive <= 0) {
            this.func_70106_y();
        }
    }

    @Override
    public void writeSpawnData(ByteBuf buffer) {
        super.writeSpawnData(buffer);
        buffer.writeDouble(this.distance);
        buffer.writeFloat(this.laserPitch);
        buffer.writeFloat(this.laserYaw);
        buffer.writeShort((int)this.maxTicks);
    }

    @Override
    public void readSpawnData(ByteBuf additionalData) {
        super.readSpawnData(additionalData);
        this.distance = additionalData.readDouble();
        this.laserPitch = additionalData.readFloat();
        this.laserYaw = additionalData.readFloat();
        this.maxTicks = additionalData.readShort();
    }

    public AxisAlignedBB func_184177_bl() {
        Vec3d pos2 = new Vec3d(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72432_b().func_186678_a(this.distance);
        return new AxisAlignedBB(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70165_t + pos2.field_72449_c, this.field_70163_u + pos2.field_72448_b, this.field_70161_v + pos2.field_72449_c);
    }
}

