/*
 * Decompiled with CFR 0.152.
 */
package techguns.damagesystem;

import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import techguns.TGSounds;
import techguns.api.damagesystem.DamageType;
import techguns.damagesystem.TGDamageSource;

public class ShieldStats {
    public static final HashMap<Item, ShieldStats> SHIELD_STATS = new HashMap();
    protected double dt = 0.0;
    protected double[] rates;
    protected ShieldMaterial mat;
    public static ShieldStats VANILLA_SHIELD = new ShieldStats(ShieldMaterial.WOOD, 0.0, new double[]{1.0, 0.35, 0.35, 0.35, 0.35, 0.35, 0.0, 0.35, 0.35, 0.0, 0.0});
    public static ShieldStats DEFAULT_STATS = new ShieldStats(ShieldMaterial.METAL, 0.0, new double[]{1.0, 0.5, 0.5, 0.5, 0.5, 0.5, 0.0, 0.5, 0.5, 0.25, 0.25});
    public static ShieldStats RIOT_SHIELD_STATS = new ShieldStats(ShieldMaterial.GLASS, 0.0, new double[]{1.0, 0.65, 0.6, 0.6, 0.6, 0.6, 0.0, 0.6, 0.6, 0.4, 0.4});
    public static ShieldStats BALLISTIC_SHIELD_STATS = new ShieldStats(ShieldMaterial.METAL, 1.5, new double[]{1.0, 0.8, 0.7, 0.7, 0.7, 0.7, 0.0, 0.7, 0.7, 0.6, 0.6});
    public static ShieldStats ADVANCED_SHIELD_STATS = new ShieldStats(ShieldMaterial.METAL, 3.0, new double[]{1.0, 0.9, 0.8, 0.8, 0.8, 0.8, 0.0, 0.8, 0.8, 0.75, 0.75});

    public ShieldStats(double dt, double[] rates) {
        this(ShieldMaterial.METAL, dt, rates);
    }

    public ShieldStats(ShieldMaterial mat, double dt, double[] rates) {
        this.mat = mat;
        this.dt = dt;
        this.rates = rates;
    }

    public ShieldStats(double dt, double allrates) {
        this(ShieldMaterial.METAL, dt, allrates);
    }

    public ShieldStats(ShieldMaterial mat, double dt, double allrates) {
        this.mat = mat;
        this.dt = dt;
        this.rates = new double[((DamageType[])DamageType.class.getEnumConstants()).length];
        for (int i = 0; i < this.rates.length; ++i) {
            this.rates[i] = allrates;
        }
    }

    public double getReductionPercentAgainstType(DamageType dt) {
        return this.rates[dt.ordinal()] * 100.0;
    }

    public float getAmount(float amount, TGDamageSource src) {
        double d = (double)amount * (1.0 - this.rates[src.field_76373_n.ordinal()]);
        double effective_dt = Math.max(this.dt - (double)src.armorPenetration * 2.0, 0.0);
        return (float)Math.max(d - effective_dt, 0.0);
    }

    public static void playBlockSound(EntityLivingBase ent, TGDamageSource src) {
        SoundEvent snd;
        ShieldStats s;
        ItemStack active;
        World w = ent.func_130014_f_();
        if (!w.field_72995_K && !(active = ent.func_184607_cu()).func_190926_b() && (s = ShieldStats.getStats(active, ent)) != null && (snd = ShieldStats.getSound(s.mat)) != null) {
            w.func_184148_a(null, ent.field_70165_t, ent.field_70163_u, ent.field_70161_v, snd, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
    }

    protected static SoundEvent getSound(ShieldMaterial mat) {
        switch (mat) {
            case GLASS: {
                return TGSounds.BULLET_IMPACT_GLASS;
            }
            case GROUND: {
                return TGSounds.BULLET_IMPACT_DIRT;
            }
            case METAL: {
                return TGSounds.BULLET_IMPACT_METAL;
            }
            case STONE: {
                return TGSounds.BULLET_IMPACT_STONE;
            }
            case WOOD: {
                return TGSounds.BULLET_IMPACT_WOOD;
            }
        }
        return null;
    }

    @Nullable
    public static ShieldStats getStats(ItemStack stack, EntityLivingBase entity) {
        ShieldStats s = null;
        if (!stack.func_190926_b() && stack.func_77973_b().isShield(stack, entity) && (s = SHIELD_STATS.get(stack.func_77973_b())) == null) {
            s = DEFAULT_STATS;
        }
        return s;
    }

    public static enum ShieldMaterial {
        WOOD,
        STONE,
        METAL,
        GLASS,
        GROUND,
        NONE;

    }
}

