/*
 * Decompiled with CFR 0.152.
 */
package techguns.client.render.tileentities;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import techguns.client.render.TGRenderHelper;
import techguns.client.render.tileentities.TessellatorCube;
import techguns.tileentities.ReactionChamberTileEntMaster;
import techguns.tileentities.operation.ReactionBeamFocus;

public class RenderReactionChamber
extends TileEntitySpecialRenderer<ReactionChamberTileEntMaster> {
    protected static final ResourceLocation heatrayTexture = new ResourceLocation("techguns", "textures/fx/heatray.png");
    private static final double ONE_SIXTEENTH = 0.0625;
    TessellatorCube fluidcube = new TessellatorCube();

    public void render(ReactionChamberTileEntMaster te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (te.isFormed()) {
            BlockPos centerPos = te.func_174877_v().func_177972_a(te.getMultiblockDirection()).func_177984_a();
            int pass = MinecraftForgeClient.getRenderPass();
            if (pass == 0) {
                ItemStack item = ItemStack.field_190927_a;
                item = te.isWorking() ? te.getCurrentReaction().getItemInputI(0) : te.input.get();
                if (!item.func_190926_b()) {
                    double px = x + (double)(-te.func_174877_v().func_177958_n() + centerPos.func_177958_n()) + 0.5;
                    double py = y + (double)(-te.func_174877_v().func_177956_o() + centerPos.func_177956_o()) + 0.5;
                    double pz = z + (double)(-te.func_174877_v().func_177952_p() + centerPos.func_177952_p()) + 0.5;
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179137_b((double)px, (double)py, (double)pz);
                    GlStateManager.func_179114_b((float)(-90.0f * (float)te.getMultiblockDirection().func_176734_d().func_176736_b()), (float)0.0f, (float)1.0f, (float)0.0f);
                    Minecraft.func_71410_x().func_175599_af().func_181564_a(item, ItemCameraTransforms.TransformType.GROUND);
                    GlStateManager.func_179121_F();
                }
            } else if (pass == 1) {
                FluidStack liquid;
                if (te.isWorking()) {
                    GlStateManager.func_179094_E();
                    double px = x + (double)(-te.func_174877_v().func_177958_n() + centerPos.func_177958_n()) + 0.5;
                    double py = y + 0.5;
                    double pz = z + (double)(-te.func_174877_v().func_177952_p() + centerPos.func_177952_p()) + 0.5;
                    GlStateManager.func_179137_b((double)px, (double)py, (double)pz);
                    GlStateManager.func_179132_a((boolean)false);
                    ItemStack stack = te.getInventory().getStackInSlot(1);
                    if (!stack.func_190926_b()) {
                        ReactionBeamFocus focus = ReactionBeamFocus.getBeamFocus(stack);
                        this.renderBeamFocusEffect(focus, te, partialTicks);
                    }
                    GlStateManager.func_179132_a((boolean)true);
                    GlStateManager.func_179121_F();
                }
                if ((liquid = te.inputTank.getFluid()) != null) {
                    this.func_147499_a(TextureMap.field_110575_b);
                    Tessellator tess = Tessellator.func_178181_a();
                    BufferBuilder buf = tess.func_178180_c();
                    double w = 0.9375;
                    double h1 = 0.5;
                    double h2 = 2.9375;
                    double level = (double)te.inputTank.getFluidAmount() / (double)te.inputTank.getCapacity();
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179137_b((double)x, (double)y, (double)z);
                    GlStateManager.func_179147_l();
                    GlStateManager.func_179140_f();
                    TextureAtlasSprite tex = te.isWorking() ? Minecraft.func_71410_x().func_147117_R().getTextureExtry(te.inputTank.getFluid().getFluid().getFlowing().toString()) : Minecraft.func_71410_x().func_147117_R().getTextureExtry(te.inputTank.getFluid().getFluid().getStill().toString());
                    Fluid f = te.inputTank.getFluid().getFluid();
                    int clr = f.getColor(te.inputTank.getFluid());
                    TGRenderHelper.enableFluidGlow(f.getLuminosity(te.inputTank.getFluid()));
                    double dx = 0.0;
                    double dz = 0.0;
                    switch (te.getMultiblockDirection()) {
                        case EAST: {
                            dx = 0.5625;
                            dz = -0.4375;
                            break;
                        }
                        case WEST: {
                            dx = -1.4375;
                            dz = -0.4375;
                            break;
                        }
                        case NORTH: {
                            dx = -0.4375;
                            dz = -1.4375;
                            break;
                        }
                        case SOUTH: {
                            dx = -0.4375;
                            dz = 0.5625;
                        }
                    }
                    this.drawFluidCubeWithTesselator(tex, dx, h1, dz, 2.0 * w, h2 * level, h2, clr);
                    TGRenderHelper.disableFluidGlow();
                    GlStateManager.func_179145_e();
                    GlStateManager.func_179084_k();
                    GlStateManager.func_179121_F();
                }
            }
        }
    }

    private void renderBeamFocusEffect(ReactionBeamFocus focus, ReactionChamberTileEntMaster tile, float ptt) {
        Tessellator tess = Tessellator.func_178181_a();
        TGRenderHelper.enableFXLighting();
        TGRenderHelper.enableBlendMode(TGRenderHelper.RenderType.ADDITIVE);
        GlStateManager.func_179129_p();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(heatrayTexture);
        double d = ((double)(tile.progress % 10) + (double)ptt) / 10.0;
        d = 0.875 + 0.125 * (1.0 - Math.cos(Math.PI * d * 2.0));
        double w = 0.9375 * d;
        double h1 = 0.5;
        double h2 = 2.9375;
        float b = (float)tile.getIntensity() / 10.0f * (float)d - 0.25f;
        double x1 = TileEntityRendererDispatcher.field_147554_b;
        double z1 = TileEntityRendererDispatcher.field_147552_d;
        BlockPos pos = tile.func_174877_v().func_177972_a(tile.getMultiblockDirection());
        float angle = (float)(Math.atan2((double)pos.func_177958_n() + 0.5 - x1, (double)pos.func_177952_p() + 0.5 - z1) * 180.0 / Math.PI);
        GlStateManager.func_179114_b((float)angle, (float)0.0f, (float)1.0f, (float)0.0f);
        BufferBuilder buf = tess.func_178180_c();
        buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buf.func_181662_b(-w, h1, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        buf.func_181662_b(-w, h2, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        buf.func_181662_b(w, h2, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        buf.func_181662_b(w, h1, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        tess.func_78381_a();
        GlStateManager.func_179089_o();
        TGRenderHelper.disableFXLighting();
        TGRenderHelper.disableBlendMode(TGRenderHelper.RenderType.ADDITIVE);
        TGRenderHelper.enableBlendMode(TGRenderHelper.RenderType.ALPHA);
    }

    protected void drawFluidCubeWithTesselator(TextureAtlasSprite tex, double x, double y, double z, double width, double height, double maxHeight, int color) {
        if (tex == null) {
            return;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        int interpV = 16;
        if (height < maxHeight * 0.5) {
            double factor = height / (maxHeight * 0.5);
            interpV = (int)(factor * 16.0);
            this.drawFluidTankPlane(buffer, x, y, z, tex, width, height, 0.0, interpV, color);
            this.drawFluidTankPlane(buffer, x, y, z, tex, 0.0, height, width, interpV, color);
            this.drawFluidTankPlane(buffer, x + width, y, z + width, tex, -width, height, 0.0, interpV, color);
            this.drawFluidTankPlane(buffer, x + width, y, z + width, tex, 0.0, height, -width, interpV, color);
        } else {
            float mhalf = (float)(maxHeight * 0.5);
            this.drawFluidTankPlane(buffer, x, y, z, tex, width, mhalf, 0.0, 16, color);
            this.drawFluidTankPlane(buffer, x, y, z, tex, 0.0, mhalf, width, 16, color);
            this.drawFluidTankPlane(buffer, x + width, y, z + width, tex, -width, mhalf, 0.0, 16, color);
            this.drawFluidTankPlane(buffer, x + width, y, z + width, tex, 0.0, mhalf, -width, 16, color);
            double h = height - (double)mhalf;
            double factor = h / (double)mhalf;
            interpV = (int)(factor * 16.0);
            this.drawFluidTankPlane(buffer, x, y + (double)mhalf, z, tex, width, h, 0.0, interpV, color);
            this.drawFluidTankPlane(buffer, x, y + (double)mhalf, z, tex, 0.0, h, width, interpV, color);
            this.drawFluidTankPlane(buffer, x + width, y + (double)mhalf, z + width, tex, -width, h, 0.0, interpV, color);
            this.drawFluidTankPlane(buffer, x + width, y + (double)mhalf, z + width, tex, 0.0, h, -width, interpV, color);
        }
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        int alpha = color >> 24 & 0xFF;
        buffer.func_181662_b(x, height + 0.5, z).func_187315_a((double)tex.func_94209_e(), (double)tex.func_94206_g()).func_181669_b(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(x, height + 0.5, z + width).func_187315_a((double)tex.func_94209_e(), (double)tex.func_94210_h()).func_181669_b(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(x + width, height + 0.5, z + width).func_187315_a((double)tex.func_94212_f(), (double)tex.func_94210_h()).func_181669_b(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(x + width, height + 0.5, z).func_187315_a((double)tex.func_94212_f(), (double)tex.func_94206_g()).func_181669_b(red, green, blue, alpha).func_181675_d();
        tessellator.func_78381_a();
    }

    protected void drawFluidTankPlane(BufferBuilder buffer, double x, double y, double z, TextureAtlasSprite icon, double w_x, double h, double w_z, int interp_v, int color) {
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        int alpha = color >> 24 & 0xFF;
        buffer.func_181662_b(x + 0.0, y + h, z + w_z).func_187315_a((double)icon.func_94209_e(), (double)icon.func_94207_b((double)interp_v)).func_181669_b(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(x + w_x, y + h, z).func_187315_a((double)icon.func_94212_f(), (double)icon.func_94207_b((double)interp_v)).func_181669_b(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(x + w_x, y + 0.0, z).func_187315_a((double)icon.func_94212_f(), (double)icon.func_94206_g()).func_181669_b(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(x + 0.0, y + 0.0, z + w_z).func_187315_a((double)icon.func_94209_e(), (double)icon.func_94206_g()).func_181669_b(red, green, blue, alpha).func_181675_d();
    }
}

