/*
 * Decompiled with CFR 0.152.
 */
package techguns.client.render.tileentities;

import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import org.lwjgl.opengl.GL11;
import techguns.client.render.tileentities.OreDrillCube;
import techguns.tileentities.OreDrillTileEntMaster;

public class RenderOreDrill
extends TileEntitySpecialRenderer<OreDrillTileEntMaster> {
    private static final int DRILLERCUBESPERBLOCK = 4;
    protected ResourceLocation texture = new ResourceLocation("techguns", "textures/blocks/drillhead.png");
    protected OreDrillCube tessellatorcube = new OreDrillCube(this.texture);
    protected ResourceLocation texture2 = new ResourceLocation("techguns", "textures/blocks/drillhead_obsidian.png");
    private OreDrillCube tessellatorcube2 = new OreDrillCube(this.texture2);
    protected ResourceLocation texture3 = new ResourceLocation("techguns", "textures/blocks/drillhead_carbon.png");
    private OreDrillCube tessellatorcube3 = new OreDrillCube(this.texture3);

    public void render(OreDrillTileEntMaster te, double x, double y, double z, float partialTick, int destroyStage, float alpha) {
        OreDrillTileEntMaster tile = te;
        if (tile.isFormed()) {
            EnumFacing drill_direction = tile.getDrill_direction();
            int[] vec = RenderOreDrill.getNextBlockInDirOffset(0, 0, 0, drill_direction, tile.getEngines() + 1);
            int[] dir = RenderOreDrill.getNextBlockInDirOffset(0, 0, 0, drill_direction, 1);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)x + 0.5f - (float)vec[0]), (float)((float)y + 1.25f - (float)vec[1]), (float)((float)z + 0.5f - (float)vec[2]));
            GL11.glPushMatrix();
            int rot = (int)(tile.func_145831_w().func_82737_E() % 360L);
            if (dir[1] < 0) {
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            } else if (dir[1] > 0) {
                GL11.glTranslatef((float)0.0f, (float)-1.5f, (float)0.0f);
            } else if (dir[0] != 0) {
                GL11.glRotatef((float)(-90.0f * (float)dir[0]), (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glTranslatef((float)((float)dir[0] * 0.75f), (float)0.0f, (float)0.0f);
                GL11.glTranslatef((float)0.0f, (float)-0.75f, (float)0.0f);
            } else if (dir[2] != 0) {
                GL11.glRotatef((float)(90.0f * (float)dir[2]), (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)((float)dir[2] * 0.75f));
                GL11.glTranslatef((float)0.0f, (float)-0.75f, (float)0.0f);
            }
            GL11.glTranslatef((float)0.0f, (float)(2 * (tile.getEngines() + 1)), (float)0.0f);
            if (tile.hasDrill() && tile.isRedstoneEnabled() && tile.hasPower()) {
                GL11.glRotatef((float)((float)rot * 10.0f + 0.027777778f * partialTick), (float)0.0f, (float)1.0f, (float)0.0f);
            }
            Tessellator tess = Tessellator.func_178181_a();
            if (tile.hasDrill()) {
                if (tile.getDrillType() == 1) {
                    this.drawDriller(tile, this.tessellatorcube, tess);
                } else if (tile.getDrillType() == 2) {
                    this.drawDriller(tile, this.tessellatorcube2, tess);
                } else if (tile.getDrillType() == 3) {
                    this.drawDriller(tile, this.tessellatorcube3, tess);
                }
            } else {
                this.drawDrillRod(tile, tess);
            }
            GL11.glPopMatrix();
            GL11.glPopMatrix();
        }
    }

    public static int[] getNextBlockInDirOffset(int x, int y, int z, EnumFacing dir, int offset) {
        int[] pos = new int[]{x, y, z};
        if (dir.func_176743_c() == EnumFacing.AxisDirection.POSITIVE) {
            int n = dir.func_176740_k().ordinal();
            pos[n] = pos[n] + offset;
        } else {
            int n = dir.func_176740_k().ordinal();
            pos[n] = pos[n] - offset;
        }
        return pos;
    }

    public boolean isGlobalRenderer(OreDrillTileEntMaster te) {
        return te.isFormed();
    }

    protected void drawDriller(OreDrillTileEntMaster tile, OreDrillCube cube, Tessellator tess) {
        float height;
        int length = tile.getRods();
        GL11.glPushMatrix();
        int[] axis = RenderOreDrill.getNextBlockInDirOffset(0, 0, 0, tile.getDrill_direction(), 1);
        float pos = height = 0.25f;
        boolean negative = false;
        axis[0] = 0;
        axis[1] = 1;
        axis[2] = 0;
        float max = (float)Math.log((float)(length * 4) + 1.0f);
        float radiusfactor = 1.0f;
        switch (tile.getDrillRadius()) {
            case 0: 
            case 1: {
                radiusfactor = 0.35f;
                break;
            }
            case 2: {
                radiusfactor = 0.5f;
                break;
            }
            case 3: {
                radiusfactor = 0.55f;
                break;
            }
            case 4: {
                radiusfactor = 0.6f;
            }
        }
        BlockPos tilePos = tile.func_174877_v();
        int[] worldpos = RenderOreDrill.getNextBlockInDirOffset(tilePos.func_177958_n(), tilePos.func_177956_o(), tilePos.func_177952_p(), tile.getDrill_direction(), tile.getEngines());
        for (int i = 0; i < length * 4; ++i) {
            boolean rotate = false;
            if (i % 2 == 1) {
                rotate = true;
            }
            float factor = (float)Math.log((float)(length * 4 - i) + 1.0f);
            float size = (tile.getDrillRadius() == 0 ? 1.0f : (float)tile.getDrillRadius() * 1.0f) * factor * (1.0f / max) * radiusfactor;
            GL11.glTranslatef((float)((float)axis[0] * height), (float)((float)axis[1] * height), (float)((float)axis[2] * height));
            if (rotate) {
                GL11.glPushMatrix();
                GL11.glRotatef((float)45.0f, (float)Math.abs(axis[0]), (float)Math.abs(axis[1]), (float)Math.abs(axis[2]));
            }
            if (i % 4 == 0) {
                worldpos = RenderOreDrill.getNextBlockInDirOffset(worldpos[0], worldpos[1], worldpos[2], tile.getDrill_direction(), 1);
            }
            cube.drawCube(axis[0] == 0 ? size : pos, axis[1] == 0 ? size : pos, axis[2] == 0 ? size : pos, tess);
            if (!rotate) continue;
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
    }

    protected void drawDrillRod(OreDrillTileEntMaster tile, Tessellator tess) {
        float height;
        int length = tile.getRods();
        GL11.glPushMatrix();
        int[] axis = RenderOreDrill.getNextBlockInDirOffset(0, 0, 0, tile.getDrill_direction(), 1);
        float pos = height = 0.5f;
        axis[0] = 0;
        axis[1] = 1;
        axis[2] = 0;
        BlockPos tilePos = tile.func_174877_v();
        int[] worldpos = RenderOreDrill.getNextBlockInDirOffset(tilePos.func_177958_n(), tilePos.func_177956_o(), tilePos.func_177952_p(), tile.getDrill_direction(), tile.getEngines());
        float f = -0.4f;
        GL11.glTranslatef((float)((float)axis[0] * height * f), (float)((float)axis[1] * height * f), (float)((float)axis[2] * height * f));
        for (int i = 0; i < length; ++i) {
            float size = 0.2f;
            GL11.glTranslatef((float)((float)axis[0] * height * 2.0f), (float)((float)axis[1] * height * 2.0f), (float)((float)axis[2] * height * 2.0f));
            GL11.glPushMatrix();
            GL11.glRotatef((float)45.0f, (float)Math.abs(axis[0]), (float)Math.abs(axis[1]), (float)Math.abs(axis[2]));
            worldpos = RenderOreDrill.getNextBlockInDirOffset(worldpos[0], worldpos[1], worldpos[2], tile.getDrill_direction(), 1);
            this.tessellatorcube.drawCube(axis[0] == 0 ? size : pos, axis[1] == 0 ? size : pos, axis[2] == 0 ? size : pos, tess);
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
    }
}

