/*
 * Decompiled with CFR 0.152.
 */
package techguns.client.render.item;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import techguns.client.models.ModelMultipart;
import techguns.client.render.item.RenderItemBase;
import techguns.items.guns.GenericGrenade;
import techguns.util.MathUtil;

public class RenderGrenade
extends RenderItemBase {
    protected float baseRotY = 180.0f;

    public RenderGrenade(ModelMultipart model, ResourceLocation texture) {
        super(model, texture);
    }

    public RenderGrenade(ModelMultipart model, ResourceLocation texture, float baseRotationY) {
        super(model, texture);
        this.baseRotY = baseRotationY;
    }

    @Override
    protected void setBaseRotation(ItemCameraTransforms.TransformType transform) {
        GlStateManager.func_179114_b((float)-180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)this.baseRotY, (float)0.0f, (float)1.0f, (float)0.0f);
    }

    @Override
    public void renderItem(ItemCameraTransforms.TransformType transform, ItemStack stack, EntityLivingBase elb, boolean leftHanded) {
        float chargeProgress = 0.0f;
        GlStateManager.func_179094_E();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.texture);
        this.applyTranslation(transform);
        GenericGrenade grenade = (GenericGrenade)stack.func_77973_b();
        if (ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND == transform || ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND == transform) {
            if (!elb.func_184607_cu().func_190926_b() && elb.func_184607_cu() == stack) {
                int dur = stack.func_77973_b().func_77626_a(stack) - elb.func_184605_cv();
                chargeProgress = (float)dur / ((GenericGrenade)stack.func_77973_b()).fullChargeTime;
                chargeProgress = MathUtil.clamp(chargeProgress, 0.0f, 1.0f);
                GlStateManager.func_179114_b((float)(25.0f * chargeProgress), (float)1.0f, (float)0.0f, (float)0.0f);
            }
        } else if (ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND != transform && ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND != transform) {
            if (ItemCameraTransforms.TransformType.GUI == transform) {
                GlStateManager.func_179114_b((float)40.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)20.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            } else if (ItemCameraTransforms.TransformType.GROUND != transform && ItemCameraTransforms.TransformType.FIXED == transform) {
                GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
        }
        this.setBaseScale(elb, transform);
        this.setBaseRotation(transform);
        this.applyBaseTranslation();
        for (int i = 0; i < this.parts; ++i) {
            this.model.render((Entity)elb, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f, 0, 0.0f, transform, i, chargeProgress, chargeProgress);
        }
        GlStateManager.func_179121_F();
    }
}

