/*
 * Decompiled with CFR 0.152.
 */
package techguns.client.render.fx;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import techguns.client.render.TGRenderHelper;
import techguns.client.render.fx.IScreenEffect;

@SideOnly(value=Side.CLIENT)
public class ScreenEffect
implements IScreenEffect {
    protected ResourceLocation fxTexture;
    protected int cols;
    protected int rows;
    protected int numSprites;
    protected TGRenderHelper.RenderType type;
    protected float colorR = 1.0f;
    protected float colorG = 1.0f;
    protected float colorB = 1.0f;
    protected float alpha = 1.0f;
    protected FadeType fadeType = FadeType.NONE;
    protected boolean flipY = false;
    protected boolean flipX = false;

    public ScreenEffect() {
    }

    public ScreenEffect(String fxTexture, int cols, int rows, int numSprites, TGRenderHelper.RenderType type) {
        this.fxTexture = new ResourceLocation("techguns", fxTexture);
        this.cols = cols;
        this.rows = rows;
        this.numSprites = numSprites;
        this.type = type;
    }

    public IScreenEffect setColor(float R, float G, float B, float A) {
        this.colorR = R;
        this.colorG = G;
        this.colorB = B;
        this.alpha = A;
        return this;
    }

    public ScreenEffect setFade(FadeType type) {
        this.fadeType = type;
        return this;
    }

    public IScreenEffect setFlipAxis(boolean x, boolean y) {
        this.flipX = x;
        this.flipY = y;
        return this;
    }

    @Override
    public void doRender(float progress, float offsetX, float offsetY, float offsetZ, float scale, float rot_x, float rot_y, float rot_z, boolean is3p) {
        int currentFrame = (int)((float)this.numSprites * progress);
        if (currentFrame < this.numSprites) {
            float tmp;
            int col = currentFrame % this.cols;
            int row = currentFrame / this.cols;
            float u = 1.0f / (float)this.cols;
            float v = 1.0f / (float)this.rows;
            float U1 = (float)col * u;
            float V1 = (float)row * v;
            float U2 = (float)(col + 1) * u;
            float V2 = (float)(row + 1) * v;
            TGRenderHelper.enableBlendMode(this.type);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(this.fxTexture);
            GlStateManager.func_179114_b((float)rot_x, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)rot_y, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)rot_z, (float)0.0f, (float)0.0f, (float)1.0f);
            if (this.flipX) {
                tmp = U1;
                U1 = U2;
                U2 = tmp;
            }
            if (this.flipY) {
                tmp = V1;
                V1 = V2;
                V2 = tmp;
            }
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            float f = scale / 2.0f;
            float alpha = 0.0f;
            switch (this.fadeType) {
                case FAST: {
                    double d = (1.0 - Math.cos(Math.sqrt(progress) * 2.0 * Math.PI)) * 0.5;
                    alpha = (float)d * this.alpha;
                    break;
                }
                case SMOOTH: {
                    double d2 = Math.sin(Math.PI * (double)progress);
                    alpha = (float)(d2 * d2) * this.alpha;
                    break;
                }
                default: {
                    alpha = this.alpha;
                }
            }
            if (is3p) {
                GlStateManager.func_179132_a((boolean)false);
                GlStateManager.func_179129_p();
            }
            buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            buffer.func_181662_b((double)(offsetX - f), (double)(offsetY + f), (double)offsetZ).func_187315_a((double)U1, (double)V2).func_181666_a(this.colorR, this.colorG, this.colorB, alpha).func_181675_d();
            buffer.func_181662_b((double)(offsetX - f), (double)(offsetY - f), (double)offsetZ).func_187315_a((double)U1, (double)V1).func_181666_a(this.colorR, this.colorG, this.colorB, alpha).func_181675_d();
            buffer.func_181662_b((double)(offsetX + f), (double)(offsetY - f), (double)offsetZ).func_187315_a((double)U2, (double)V1).func_181666_a(this.colorR, this.colorG, this.colorB, alpha).func_181675_d();
            buffer.func_181662_b((double)(offsetX + f), (double)(offsetY + f), (double)offsetZ).func_187315_a((double)U2, (double)V2).func_181666_a(this.colorR, this.colorG, this.colorB, alpha).func_181675_d();
            if (is3p) {
                buffer.func_181662_b((double)(offsetX - f), (double)offsetY, (double)(offsetZ + f)).func_187315_a((double)U1, (double)V2).func_181666_a(this.colorR, this.colorG, this.colorB, alpha).func_181675_d();
                buffer.func_181662_b((double)(offsetX - f), (double)offsetY, (double)(offsetZ - f)).func_187315_a((double)U1, (double)V1).func_181666_a(this.colorR, this.colorG, this.colorB, alpha).func_181675_d();
                buffer.func_181662_b((double)(offsetX + f), (double)offsetY, (double)(offsetZ - f)).func_187315_a((double)U2, (double)V1).func_181666_a(this.colorR, this.colorG, this.colorB, alpha).func_181675_d();
                buffer.func_181662_b((double)(offsetX + f), (double)offsetY, (double)(offsetZ + f)).func_187315_a((double)U2, (double)V2).func_181666_a(this.colorR, this.colorG, this.colorB, alpha).func_181675_d();
                buffer.func_181662_b((double)offsetX, (double)(offsetY - f), (double)(offsetZ + f)).func_187315_a((double)U1, (double)V2).func_181666_a(this.colorR, this.colorG, this.colorB, alpha).func_181675_d();
                buffer.func_181662_b((double)offsetX, (double)(offsetY - f), (double)(offsetZ - f)).func_187315_a((double)U1, (double)V1).func_181666_a(this.colorR, this.colorG, this.colorB, alpha).func_181675_d();
                buffer.func_181662_b((double)offsetX, (double)(offsetY + f), (double)(offsetZ - f)).func_187315_a((double)U2, (double)V1).func_181666_a(this.colorR, this.colorG, this.colorB, alpha).func_181675_d();
                buffer.func_181662_b((double)offsetX, (double)(offsetY + f), (double)(offsetZ + f)).func_187315_a((double)U2, (double)V2).func_181666_a(this.colorR, this.colorG, this.colorB, alpha).func_181675_d();
            }
            tessellator.func_78381_a();
            if (is3p) {
                GlStateManager.func_179089_o();
                GlStateManager.func_179132_a((boolean)true);
            }
            TGRenderHelper.disableBlendMode(this.type);
        }
    }

    static enum FadeType {
        SMOOTH,
        FAST,
        NONE;

    }
}

