/*
 * Decompiled with CFR 0.152.
 */
package techguns.client.render.entities.npcs;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import techguns.client.models.ModelMultipart;
import techguns.client.models.npcs.ModelTurret;
import techguns.debug.Keybinds;
import techguns.entities.npcs.NPCTurret;
import techguns.items.guns.GenericGun;

public class RenderNPCTurret
extends RenderLiving<NPCTurret> {
    private static final ModelMultipart model = new ModelTurret();
    private float gunOffsetY = 0.85f;

    public RenderNPCTurret(RenderManager renderManager) {
        super(renderManager, (ModelBase)model, 0.0f);
    }

    protected ResourceLocation getEntityTexture(NPCTurret entity) {
        return entity.getTexture();
    }

    public void doRender(NPCTurret turret, double x, double y, double z, float entityYaw, float partialTicks) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179091_B();
        EnumFacing facing = EnumFacing.UP;
        if (turret.mountedTileEnt != null) {
            facing = turret.mountedTileEnt.getFacing();
        }
        float mirrorYaw = 1.0f;
        float mirrorPitch = 1.0f;
        float yawOffset = 0.0f;
        if (facing == EnumFacing.DOWN) {
            mirrorYaw = -1.0f;
            mirrorPitch = -1.0f;
            yawOffset = 180.0f;
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(turret.getTexture());
        this.translate(facing, turret);
        this.rotatetoBase(facing);
        GlStateManager.func_179114_b((float)(turret.field_70759_as * mirrorYaw + yawOffset), (float)0.0f, (float)1.0f, (float)0.0f);
        model.render((Entity)turret, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f, 0, 0.0f, ItemCameraTransforms.TransformType.FIXED, 0, 0.0f, 0.0f);
        float rotoffset = 0.9f;
        GlStateManager.func_179109_b((float)0.0f, (float)rotoffset, (float)0.0f);
        GlStateManager.func_179114_b((float)(turret.field_70125_A * mirrorPitch), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)(-rotoffset), (float)0.0f);
        model.render((Entity)turret, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f, 0, 0.0f, ItemCameraTransforms.TransformType.FIXED, 1, 0.0f, 0.0f);
        this.renderEquippedItems(turret);
        GlStateManager.func_179101_C();
        GlStateManager.func_179121_F();
    }

    protected void rotatetoBase(EnumFacing facing) {
        if (facing == EnumFacing.UP) {
            GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        }
    }

    protected void translate(EnumFacing facing, NPCTurret turret) {
        if (facing == EnumFacing.UP) {
            GlStateManager.func_179109_b((float)0.0f, (float)1.5f, (float)0.0f);
        } else if (facing == EnumFacing.DOWN) {
            GlStateManager.func_179109_b((float)0.0f, (float)-0.6f, (float)0.0f);
        }
    }

    protected void renderEquippedItems(NPCTurret turret) {
        ItemStack gunstack = turret.func_184614_ca();
        if (!gunstack.func_190926_b()) {
            GenericGun gun = (GenericGun)gunstack.func_77973_b();
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(gun.turretPosOffsetX + Keybinds.X), (float)(gun.turretPosOffsetY + this.gunOffsetY + Keybinds.Y), (float)(gun.turretPosOffsetZ + Keybinds.Z));
            GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            Minecraft.func_71410_x().func_175597_ag().func_187462_a((EntityLivingBase)turret, gunstack, ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, false);
            GlStateManager.func_179121_F();
        }
    }
}

