/*
 * Decompiled with CFR 0.152.
 */
package techguns.client.particle;

import java.net.URL;
import java.util.HashMap;
import java.util.InputMismatchException;
import java.util.List;
import java.util.Locale;
import java.util.Scanner;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import techguns.client.particle.TGFXType;
import techguns.client.particle.TGParticle;
import techguns.client.particle.TGParticleListType;
import techguns.client.particle.TGParticleSystem;
import techguns.client.particle.TGParticleSystemType;
import techguns.client.render.TGRenderHelper;
import techguns.util.TGLogger;

public class TGFX {
    public static final String FXLIST_DIR = "/assets/techguns/particles/";
    public static String[] FXFILES = new String[]{"fxlist.txt", "nuke.txt", "deathfx.txt", "impactfx.txt", "testfx.txt"};
    public static HashMap<String, TGFXType> FXList = new HashMap();

    public static List<TGParticleSystem> createFX(World world, String fx, double posX, double posY, double posZ, double motionX, double motionY, double motionZ) {
        if (FXList.containsKey(fx.toLowerCase())) {
            TGFXType fxtype = FXList.get(fx.toLowerCase());
            List<TGParticleSystem> list = fxtype.createParticleSystems(world, posX, posY, posZ, motionX, motionY, motionZ);
            return list;
        }
        TGLogger.logger_client.warning("FX '" + fx + "' not found!");
        return null;
    }

    public static List<TGParticleSystem> createFXOnEntity(Entity ent, String fx) {
        if (FXList.containsKey(fx.toLowerCase())) {
            TGFXType fxtype = FXList.get(fx.toLowerCase());
            List<TGParticleSystem> list = fxtype.createParticleSystemsOnEntity(ent);
            return list;
        }
        TGLogger.logger_client.warning("FX '" + fx + "' not found!");
        return null;
    }

    public static List<TGParticleSystem> createFXOnParticle(World worldIn, TGParticle ent, String fx) {
        if (FXList.containsKey(fx.toLowerCase())) {
            TGFXType fxtype = FXList.get(fx.toLowerCase());
            List<TGParticleSystem> list = fxtype.createParticleSystemsOnParticle(worldIn, ent);
            return list;
        }
        TGLogger.logger_client.warning("FX '" + fx + "' not found!");
        return null;
    }

    public static List<TGParticleSystem> createFXOnEntityItemAttached(Entity ent, EnumHand hand, String fx) {
        if (FXList.containsKey(fx.toLowerCase())) {
            TGFXType fxtype = FXList.get(fx.toLowerCase());
            List<TGParticleSystem> list = fxtype.createParticleSystemsOnEntityItemAttached(ent, hand);
            return list;
        }
        TGLogger.logger_client.warning("FX '" + fx + "' not found!");
        return null;
    }

    public static void loadFXList() {
        URL url = TGFX.class.getResource(FXLIST_DIR);
        if (url != null) {
            for (String filename : FXFILES) {
                TGFX.loadFXListFile(FXLIST_DIR + filename);
            }
        }
    }

    public static boolean loadFXListFile(String filename) {
        Scanner sc = new Scanner(TGFX.class.getResourceAsStream(filename));
        sc.useLocale(Locale.ENGLISH);
        sc.useDelimiter("(\\s*=\\s*)|\\s\\{|\\s*//.*|\\r\\n|\\s+");
        String error = "";
        String next = "";
        String value = "";
        int count = 0;
        try {
            while (sc.hasNextLine() && error.equals("") && sc.hasNext()) {
                boolean end;
                TGFXType type;
                String name;
                next = sc.next();
                if (next.toLowerCase().equals("fxlist") && sc.hasNext()) {
                    name = sc.next();
                    type = new TGParticleListType();
                    end = false;
                    while (sc.hasNextLine() && !end && error.equals("")) {
                        if (!sc.hasNext() || (next = sc.next()).equals("")) continue;
                        if (next.equals("}")) {
                            end = true;
                            continue;
                        }
                        ((TGParticleListType)type).addParticleSystem(next.toLowerCase());
                    }
                    ++count;
                    FXList.put(name.toLowerCase(), type);
                    continue;
                }
                if (next.equals("")) continue;
                name = next;
                type = new TGParticleSystemType();
                end = false;
                while (sc.hasNextLine() && !end && error.equals("")) {
                    if (!sc.hasNext() || (next = sc.next()).equals("")) continue;
                    String key = next;
                    block47 : switch (key.toLowerCase()) {
                        case "extends": {
                            value = sc.next();
                            if (FXList.containsKey(value.toLowerCase())) {
                                TGFXType fxtype = FXList.get(value.toLowerCase());
                                if (fxtype instanceof TGParticleSystemType) {
                                    ((TGParticleSystemType)type).extend((TGParticleSystemType)fxtype);
                                    break;
                                }
                                error = "'EXTENDS' must specifiy a ParticleSystem, not an FXList.";
                                break;
                            }
                            error = "ParticleSystem '" + value.toLowerCase() + "' not found. Can't extend.";
                            break;
                        }
                        case "rendertype": {
                            value = sc.next();
                            switch (value.toUpperCase().trim()) {
                                case "ADDITIVE": {
                                    ((TGParticleSystemType)type).renderType = TGRenderHelper.RenderType.ADDITIVE;
                                    break block47;
                                }
                                case "ALPHA": {
                                    ((TGParticleSystemType)type).renderType = TGRenderHelper.RenderType.ALPHA;
                                    break block47;
                                }
                                case "ALPHA_SHADED": {
                                    ((TGParticleSystemType)type).renderType = TGRenderHelper.RenderType.ALPHA_SHADED;
                                    break block47;
                                }
                                case "SOLID": {
                                    ((TGParticleSystemType)type).renderType = TGRenderHelper.RenderType.SOLID;
                                    break block47;
                                }
                                case "NO_Z_TEST": {
                                    ((TGParticleSystemType)type).renderType = TGRenderHelper.RenderType.NO_Z_TEST;
                                    break block47;
                                }
                            }
                            error = name;
                            break;
                        }
                        case "texture": {
                            value = sc.next();
                            ((TGParticleSystemType)type).texture = new ResourceLocation(value);
                            break;
                        }
                        case "rows": {
                            ((TGParticleSystemType)type).rows = sc.nextInt();
                            break;
                        }
                        case "columns": {
                            ((TGParticleSystemType)type).columns = sc.nextInt();
                            break;
                        }
                        case "frames": {
                            ((TGParticleSystemType)type).frames = sc.nextInt();
                            break;
                        }
                        case "hasvariations": {
                            ((TGParticleSystemType)type).hasVariations = sc.nextBoolean();
                            break;
                        }
                        case "angle": {
                            ((TGParticleSystemType)type).angleMin = sc.nextFloat();
                            ((TGParticleSystemType)type).angleMax = sc.nextFloat();
                            break;
                        }
                        case "anglerate": {
                            ((TGParticleSystemType)type).angleRateMin = sc.nextFloat();
                            ((TGParticleSystemType)type).angleRateMax = sc.nextFloat();
                            break;
                        }
                        case "angleratedamping": {
                            ((TGParticleSystemType)type).angleRateDampingMin = sc.nextFloat();
                            ((TGParticleSystemType)type).angleRateDampingMax = sc.nextFloat();
                            break;
                        }
                        case "lifetime": {
                            ((TGParticleSystemType)type).lifetimeMin = sc.nextInt();
                            ((TGParticleSystemType)type).lifetimeMax = sc.nextInt();
                            break;
                        }
                        case "systemlifetime": {
                            ((TGParticleSystemType)type).systemLifetimeMin = sc.nextInt();
                            ((TGParticleSystemType)type).systemLifetimeMax = sc.nextInt();
                            break;
                        }
                        case "animationspeed": {
                            ((TGParticleSystemType)type).animationSpeedMin = sc.nextFloat();
                            ((TGParticleSystemType)type).animationSpeedMax = sc.nextFloat();
                            break;
                        }
                        case "size": {
                            ((TGParticleSystemType)type).sizeMin = sc.nextFloat();
                            ((TGParticleSystemType)type).sizeMax = sc.nextFloat();
                            break;
                        }
                        case "sizerate": {
                            ((TGParticleSystemType)type).sizeRateMin = sc.nextFloat();
                            ((TGParticleSystemType)type).sizeRateMax = sc.nextFloat();
                            break;
                        }
                        case "sizeratedamping": {
                            ((TGParticleSystemType)type).sizeRateDampingMin = sc.nextFloat();
                            ((TGParticleSystemType)type).sizeRateDampingMax = sc.nextFloat();
                            break;
                        }
                        case "startsizerate": {
                            ((TGParticleSystemType)type).startSizeRateMin = sc.nextFloat();
                            ((TGParticleSystemType)type).startSizeRateMax = sc.nextFloat();
                            break;
                        }
                        case "startsizeratedamping": {
                            ((TGParticleSystemType)type).startSizeRateDampingMin = sc.nextFloat();
                            ((TGParticleSystemType)type).startSizeRateDampingMax = sc.nextFloat();
                            break;
                        }
                        case "alpha": {
                            ((TGParticleSystemType)type).alphaEntries.add(new TGParticleSystemType.AlphaEntry(sc.nextFloat(), sc.nextFloat()));
                            break;
                        }
                        case "color": {
                            ((TGParticleSystemType)type).colorEntries.add(new TGParticleSystemType.ColorEntry(sc.nextInt(), sc.nextInt(), sc.nextInt(), sc.nextFloat()));
                            break;
                        }
                        case "particlecount": {
                            ((TGParticleSystemType)type).particleCountMin = sc.nextInt();
                            ((TGParticleSystemType)type).particleCountMax = sc.nextInt();
                            break;
                        }
                        case "initialdelay": {
                            ((TGParticleSystemType)type).initialDelayMin = sc.nextInt();
                            ((TGParticleSystemType)type).initialDelayMax = sc.nextInt();
                            break;
                        }
                        case "spawndelay": {
                            ((TGParticleSystemType)type).spawnDelayMin = sc.nextInt();
                            ((TGParticleSystemType)type).spawnDelayMax = sc.nextInt();
                            break;
                        }
                        case "velocitytype": {
                            value = sc.next();
                            switch (value.toUpperCase()) {
                                case "NONE": {
                                    ((TGParticleSystemType)type).velocityType = TGParticleSystemType.VEL_NONE;
                                    break block47;
                                }
                                case "SPHERICAL": {
                                    ((TGParticleSystemType)type).velocityType = TGParticleSystemType.VEL_SPHERICAL;
                                    break block47;
                                }
                                case "ORTHO": {
                                    ((TGParticleSystemType)type).velocityType = TGParticleSystemType.VEL_ORTHO;
                                    break block47;
                                }
                                case "HEMISPHERICAL": {
                                    ((TGParticleSystemType)type).velocityType = TGParticleSystemType.VEL_HEMISPHERICAL;
                                    break block47;
                                }
                                case "OUTWARD": {
                                    ((TGParticleSystemType)type).velocityType = TGParticleSystemType.VEL_OUTWARD;
                                    break block47;
                                }
                            }
                            error = name;
                            break;
                        }
                        case "velocity1": {
                            ((TGParticleSystemType)type).velocityDataMin[0] = sc.nextFloat();
                            ((TGParticleSystemType)type).velocityDataMax[0] = sc.nextFloat();
                            break;
                        }
                        case "velocity2": {
                            ((TGParticleSystemType)type).velocityDataMin[1] = sc.nextFloat();
                            ((TGParticleSystemType)type).velocityDataMax[1] = sc.nextFloat();
                            break;
                        }
                        case "velocity3": {
                            ((TGParticleSystemType)type).velocityDataMin[2] = sc.nextFloat();
                            ((TGParticleSystemType)type).velocityDataMax[2] = sc.nextFloat();
                            break;
                        }
                        case "velocitydamping": {
                            ((TGParticleSystemType)type).velocityDampingMin = sc.nextFloat();
                            ((TGParticleSystemType)type).velocityDampingMax = sc.nextFloat();
                            break;
                        }
                        case "volumetype": {
                            value = sc.next();
                            switch (value.toUpperCase()) {
                                case "SPHERE": {
                                    ((TGParticleSystemType)type).volumeType = TGParticleSystemType.VOL_SPHERE;
                                    break block47;
                                }
                                case "CYLINDER": {
                                    ((TGParticleSystemType)type).volumeType = TGParticleSystemType.VOL_CYLINDER;
                                    break block47;
                                }
                                case "CYLINDER2": {
                                    ((TGParticleSystemType)type).volumeType = TGParticleSystemType.VOL_CYLINDER2;
                                    break block47;
                                }
                                case "POINT": {
                                    ((TGParticleSystemType)type).volumeType = TGParticleSystemType.VOL_POINT;
                                    break block47;
                                }
                                case "HEMISPHERE": {
                                    ((TGParticleSystemType)type).volumeType = TGParticleSystemType.VOL_HEMISPHERE;
                                    break block47;
                                }
                                case "TRAIL": {
                                    ((TGParticleSystemType)type).volumeType = TGParticleSystemType.VOL_TRAIL;
                                    break block47;
                                }
                            }
                            error = name;
                            break;
                        }
                        case "volume1": {
                            ((TGParticleSystemType)type).volumeData[0] = sc.nextFloat();
                            break;
                        }
                        case "volume2": {
                            ((TGParticleSystemType)type).volumeData[1] = sc.nextFloat();
                            break;
                        }
                        case "volume3": {
                            ((TGParticleSystemType)type).volumeData[2] = sc.nextFloat();
                            break;
                        }
                        case "gravity": {
                            ((TGParticleSystemType)type).gravity = sc.nextFloat();
                            break;
                        }
                        case "ishollow": {
                            ((TGParticleSystemType)type).isHollow = sc.nextBoolean();
                            break;
                        }
                        case "removeonground": {
                            ((TGParticleSystemType)type).removeOnGround = sc.nextBoolean();
                            break;
                        }
                        case "systemvelocityfactor": {
                            ((TGParticleSystemType)type).systemVelocityFactorMin = sc.nextFloat();
                            ((TGParticleSystemType)type).systemVelocityFactorMax = sc.nextFloat();
                            break;
                        }
                        case "velocitydampingonground": {
                            ((TGParticleSystemType)type).velocityDampingOnGroundMin = sc.nextFloat();
                            ((TGParticleSystemType)type).velocityDampingOnGroundMax = sc.nextFloat();
                            break;
                        }
                        case "offset": {
                            float x = sc.nextFloat();
                            float y = sc.nextFloat();
                            float z = sc.nextFloat();
                            ((TGParticleSystemType)type).offset = new Vec3d((double)x, (double)y, (double)z);
                            break;
                        }
                        case "particlesmovewithsystem": {
                            ((TGParticleSystemType)type).particlesMoveWithSystem = sc.nextBoolean();
                            break;
                        }
                        case "particlessticktosystem": {
                            ((TGParticleSystemType)type).particlesStickToSystem = sc.nextBoolean();
                            break;
                        }
                        case "groundaligned": {
                            ((TGParticleSystemType)type).groundAligned = sc.nextBoolean();
                            break;
                        }
                        case "streak": {
                            ((TGParticleSystemType)type).streak = sc.nextBoolean();
                            break;
                        }
                        case "attachedsystem": {
                            ((TGParticleSystemType)type).attachedSystem = sc.next();
                            break;
                        }
                        case "}": {
                            end = true;
                        }
                    }
                }
                if (error.equals("")) {
                    ++count;
                    FXList.put(name.toLowerCase(), type);
                    continue;
                }
                System.err.println("Error(s) while parsing particle " + name + " in file '" + filename + "'.");
                System.err.println("error");
                sc.close();
                return false;
            }
        }
        catch (InputMismatchException e) {
            e.printStackTrace();
            sc.close();
            return false;
        }
        sc.close();
        return true;
    }
}

