/*
 * Decompiled with CFR 0.152.
 */
package techguns.blocks.machines.multiblocks;

import java.util.ArrayList;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import techguns.TGBlocks;
import techguns.blocks.machines.EnumMultiBlockMachineType;
import techguns.blocks.machines.MultiBlockMachine;
import techguns.blocks.machines.multiblocks.MultiBlockMachineSchematic;
import techguns.tileentities.FabricatorTileEntMaster;
import techguns.tileentities.MultiBlockMachineTileEntMaster;

public class FabricatorDefinition
extends MultiBlockMachineSchematic {
    public FabricatorDefinition() {
        super(FabricatorTileEntMaster.class);
    }

    private ArrayList<BlockPos> getBottomRow(BlockPos masterPos, EnumFacing direction) {
        masterPos = masterPos.func_185334_h();
        ArrayList<BlockPos> bottomRow = new ArrayList<BlockPos>();
        BlockPos behind = masterPos.func_177972_a(direction.func_176734_d());
        bottomRow.add(behind);
        EnumFacing left = direction.func_176746_e();
        BlockPos leftFront = masterPos.func_177967_a(left, 1);
        BlockPos leftBehind = behind.func_177967_a(left, 1);
        bottomRow.add(leftFront);
        bottomRow.add(leftBehind);
        return bottomRow;
    }

    private ArrayList<BlockPos> getTopRow(BlockPos masterPos, EnumFacing direction) {
        masterPos = masterPos.func_185334_h();
        BlockPos behind = masterPos.func_177972_a(direction.func_176734_d());
        EnumFacing left = direction.func_176746_e();
        BlockPos leftFront = masterPos.func_177967_a(left, 1);
        BlockPos leftBehind = behind.func_177967_a(left, 1);
        ArrayList<BlockPos> topRow = new ArrayList<BlockPos>();
        topRow.add(masterPos.func_177967_a(EnumFacing.UP, 1));
        topRow.add(behind.func_177967_a(EnumFacing.UP, 1));
        topRow.add(leftFront.func_177967_a(EnumFacing.UP, 1));
        topRow.add(leftBehind.func_177967_a(EnumFacing.UP, 1));
        return topRow;
    }

    @Override
    public boolean checkForm(World w, EntityPlayer ply, BlockPos masterPos, EnumFacing direction) {
        if (this.canFormFromSide(direction)) {
            if (FabricatorDefinition.allBlocksMatch(w, ply, this.getBottomRow(masterPos, direction), TGBlocks.MULTIBLOCK_MACHINE.func_176223_P().func_177226_a((IProperty)TGBlocks.MULTIBLOCK_MACHINE.MACHINE_TYPE, (Comparable)((Object)EnumMultiBlockMachineType.FABRICATOR_HOUSING)).func_177226_a((IProperty)MultiBlockMachine.FORMED, (Comparable)Boolean.valueOf(false)))) {
                if (FabricatorDefinition.allBlocksMatch(w, ply, this.getTopRow(masterPos, direction), TGBlocks.MULTIBLOCK_MACHINE.func_176223_P().func_177226_a((IProperty)TGBlocks.MULTIBLOCK_MACHINE.MACHINE_TYPE, (Comparable)((Object)EnumMultiBlockMachineType.FABRICATOR_GLASS)).func_177226_a((IProperty)MultiBlockMachine.FORMED, (Comparable)Boolean.valueOf(false)))) {
                    return true;
                }
            }
        }
        FabricatorDefinition.sendErrorMSG(w, masterPos, ply, 8);
        return false;
    }

    @Override
    public boolean canFormFromSide(EnumFacing side) {
        return side != null && side != EnumFacing.UP && side != EnumFacing.DOWN;
    }

    @Override
    public boolean form(World w, EntityPlayer player, BlockPos masterPos, EnumFacing direction) {
        TileEntity tile = w.func_175625_s(masterPos);
        if (tile != null && tile instanceof MultiBlockMachineTileEntMaster) {
            MultiBlockMachineTileEntMaster master = (MultiBlockMachineTileEntMaster)tile;
            master.form(direction);
            ArrayList<BlockPos> glassBlocks = this.getTopRow(masterPos, direction);
            ArrayList<BlockPos> housingBlocks = this.getBottomRow(masterPos, direction);
            glassBlocks.forEach(b -> this.linkSlave(w, player, (BlockPos)b, 1, masterPos));
            housingBlocks.forEach(b -> this.linkSlave(w, player, (BlockPos)b, 2, masterPos));
            return true;
        }
        return false;
    }

    @Override
    public void unform(World w, MultiBlockMachineTileEntMaster master) {
        BlockPos masterPos = master.func_174877_v();
        EnumFacing direction = master.getMultiblockDirection();
        master.unform();
        ArrayList<BlockPos> glassBlocks = this.getTopRow(masterPos, direction);
        ArrayList<BlockPos> housingBlocks = this.getBottomRow(masterPos, direction);
        glassBlocks.forEach(b -> this.unlinkSlave(w, (BlockPos)b));
        housingBlocks.forEach(b -> this.unlinkSlave(w, (BlockPos)b));
    }
}

