/*
 * Decompiled with CFR 0.152.
 */
package techguns.blocks.machines;

import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import techguns.api.machines.IMachineType;
import techguns.blocks.machines.BasicMachine;
import techguns.tileentities.ExplosiveChargeTileEnt;
import techguns.util.BlockUtils;

public class BlockExplosiveCharge<T extends Enum<T> & IMachineType>
extends BasicMachine<T> {
    public static final PropertyDirection FACING = BlockDirectional.field_176387_N;
    public static final PropertyBool ARMED = PropertyBool.func_177716_a((String)"armed");
    protected static final AxisAlignedBB[] boundingBoxes = new AxisAlignedBB[]{new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.3125, 0.875), new AxisAlignedBB(0.125, 0.6875, 0.125, 0.875, 1.0, 0.875), new AxisAlignedBB(0.125, 0.125, 0.0, 0.875, 0.875, 0.3125), new AxisAlignedBB(0.125, 0.125, 0.6875, 0.875, 0.875, 1.0), new AxisAlignedBB(0.0, 0.125, 0.125, 0.3125, 0.875, 0.875), new AxisAlignedBB(0.6875, 0.125, 0.125, 1.0, 0.875, 0.875)};

    public BlockExplosiveCharge(String name, Class<T> clazz) {
        super(name, clazz);
        this.blockStateOverride = new BlockStateContainer.Builder((Block)this).add(new IProperty[]{FACING}).add(new IProperty[]{this.MACHINE_TYPE}).add(new IProperty[]{ARMED}).build();
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)ARMED, (Comparable)Boolean.valueOf(false)));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        return boundingBoxes[facing.func_176745_a()];
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a() << 1 | ((IMachineType)((Object)((Enum)((Object)state.func_177229_b((IProperty)this.MACHINE_TYPE))))).getIndex();
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)(meta >> 1))).func_177226_a((IProperty)this.MACHINE_TYPE, (Comparable)((Object)((Enum[])this.clazz.getEnumConstants())[meta & 1]));
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile != null && tile instanceof ExplosiveChargeTileEnt) {
            ExplosiveChargeTileEnt charge = (ExplosiveChargeTileEnt)tile;
            return state.func_177226_a((IProperty)ARMED, (Comparable)Boolean.valueOf(charge.isArmed()));
        }
        return state;
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176203_a(meta).func_177226_a((IProperty)FACING, (Comparable)facing.func_176734_d());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerItemBlockModels() {
        for (int i = 0; i < ((Enum[])this.clazz.getEnumConstants()).length; ++i) {
            IBlockState state = this.func_176223_P().func_177226_a((IProperty)this.MACHINE_TYPE, (Comparable)((Object)((Enum[])this.clazz.getEnumConstants())[i]));
            ModelLoader.setCustomModelResourceLocation((Item)this.itemblock, (int)this.func_176201_c(state), (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), BlockUtils.getBlockStateVariantString(state)));
        }
    }

    @Override
    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
        if (worldIn.func_175623_d(pos.func_177972_a((EnumFacing)state.func_177229_b((IProperty)FACING)))) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        switch (rot) {
            case CLOCKWISE_180: {
                return state.func_177226_a((IProperty)FACING, (Comparable)facing.func_176734_d());
            }
            case CLOCKWISE_90: {
                return state.func_177226_a((IProperty)FACING, (Comparable)facing.func_176746_e());
            }
            case COUNTERCLOCKWISE_90: {
                return state.func_177226_a((IProperty)FACING, (Comparable)facing.func_176735_f());
            }
        }
        return state;
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        return state.func_177226_a((IProperty)FACING, (Comparable)mirrorIn.func_185803_b(facing));
    }

    @Override
    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        if (axis == EnumFacing.DOWN || axis == EnumFacing.UP) {
            IBlockState state = world.func_180495_p(pos);
            IBlockState statenew = state.func_177226_a((IProperty)FACING, (Comparable)((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176746_e());
            world.func_180501_a(pos, statenew, 3);
            return true;
        }
        return false;
    }
}

