/*
 * Decompiled with CFR 0.152.
 */
package techguns.blocks;

import java.util.ArrayList;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import techguns.blocks.GenericItemBlockMetaMachineBlock;
import techguns.blocks.machines.BlockOreDrill;
import techguns.blocks.machines.EnumOreDrillType;
import techguns.blocks.machines.multiblocks.OreDrillDefinition;
import techguns.util.TextUtil;

public class ItemBlockOreDrill
extends GenericItemBlockMetaMachineBlock {
    protected final BlockOreDrill field_150939_a;

    public ItemBlockOreDrill(BlockOreDrill block) {
        super(block);
        this.field_150939_a = block;
    }

    public boolean func_179222_a(World world, BlockPos posIn, EnumFacing side, EntityPlayer player, ItemStack stack) {
        IBlockState state = this.field_150939_a.func_176203_a(stack.func_77952_i());
        BlockPos pos = posIn.func_177972_a(side);
        if (state.func_177229_b((IProperty)this.field_150939_a.MACHINE_TYPE) == EnumOreDrillType.ROD) {
            BlockPos clusterPos = ItemBlockOreDrill.checkForOreClusterInNeighbourhood(world, pos);
            if (clusterPos != null) {
                IBlockState bs = world.func_180495_p(clusterPos);
                if (this.getHasConnectedDrillRod(world, clusterPos, new ArrayList<BlockPos>(), bs, this.field_150939_a.func_176223_P().func_177226_a((IProperty)this.field_150939_a.MACHINE_TYPE, (Comparable)((Object)EnumOreDrillType.ROD)))) {
                    if (world.field_72995_K) {
                        player.func_146105_b((ITextComponent)new TextComponentString(TextUtil.trans("techguns.msg.error.alreadyrod")), true);
                    }
                    return false;
                }
                return super.func_179222_a(world, posIn, side, player, stack);
            }
            if (this.checkForRodInNeighbourhood(world, pos)) {
                return super.func_179222_a(world, posIn, side, player, stack);
            }
            player.func_146105_b((ITextComponent)new TextComponentString(TextUtil.trans("techguns.msg.error.rodplacement")), true);
            return false;
        }
        if (state.func_177229_b((IProperty)this.field_150939_a.MACHINE_TYPE) == EnumOreDrillType.CONTROLLER) {
            if (this.checkForControllerInNeighbourhood(world, pos)) {
                if (world.field_72995_K) {
                    player.func_146105_b((ITextComponent)new TextComponentString(TextUtil.transTG("msg.error.oredrill.controllernext")), true);
                }
                return false;
            }
            return super.func_179222_a(world, posIn, side, player, stack);
        }
        return super.func_179222_a(world, posIn, side, player, stack);
    }

    public static BlockPos checkForOreClusterInNeighbourhood(World w, BlockPos p) {
        for (EnumFacing f : EnumFacing.field_82609_l) {
            if (!OreDrillDefinition.isOreCluster(w, p.func_177972_a(f))) continue;
            return p.func_177972_a(f);
        }
        return null;
    }

    public boolean checkForRodInNeighbourhood(World w, BlockPos p) {
        for (EnumFacing f : EnumFacing.field_82609_l) {
            IBlockState bs = w.func_180495_p(p.func_177972_a(f));
            if (bs != this.field_150939_a.func_176223_P().func_177226_a((IProperty)this.field_150939_a.MACHINE_TYPE, (Comparable)((Object)EnumOreDrillType.ROD))) continue;
            return true;
        }
        return false;
    }

    public boolean checkForControllerInNeighbourhood(World w, BlockPos p) {
        for (EnumFacing f : EnumFacing.field_82609_l) {
            IBlockState bs = w.func_180495_p(p.func_177972_a(f));
            if (bs.func_177230_c() != this.field_150939_a) continue;
            return bs.func_177229_b((IProperty)this.field_150939_a.MACHINE_TYPE) == EnumOreDrillType.CONTROLLER;
        }
        return false;
    }

    public boolean getHasConnectedDrillRod(World world, BlockPos p, ArrayList<BlockPos> visited, IBlockState clusterblock, IBlockState drillRodBlock) {
        IBlockState target = world.func_180495_p(p);
        if (!visited.contains(p)) {
            if (target == clusterblock) {
                visited.add(p);
                boolean b1 = this.getHasConnectedDrillRod(world, p.func_177972_a(EnumFacing.DOWN), visited, clusterblock, drillRodBlock);
                boolean b2 = this.getHasConnectedDrillRod(world, p.func_177972_a(EnumFacing.UP), visited, clusterblock, drillRodBlock);
                boolean b3 = this.getHasConnectedDrillRod(world, p.func_177972_a(EnumFacing.NORTH), visited, clusterblock, drillRodBlock);
                boolean b4 = this.getHasConnectedDrillRod(world, p.func_177972_a(EnumFacing.SOUTH), visited, clusterblock, drillRodBlock);
                boolean b5 = this.getHasConnectedDrillRod(world, p.func_177972_a(EnumFacing.WEST), visited, clusterblock, drillRodBlock);
                boolean b6 = this.getHasConnectedDrillRod(world, p.func_177972_a(EnumFacing.EAST), visited, clusterblock, drillRodBlock);
                return b1 || b2 || b3 || b4 || b5 || b6;
            }
            return target == drillRodBlock;
        }
        return false;
    }
}

