/*
 * Decompiled with CFR 0.152.
 */
package techguns.blocks;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import techguns.blocks.EnumMonsterSpawnerType;
import techguns.blocks.GenericBlockMetaEnum;
import techguns.entities.npcs.ArmySoldier;
import techguns.entities.npcs.ZombieSoldier;
import techguns.tileentities.TGSpawnerTileEnt;

public class BlockTGSpawner
extends GenericBlockMetaEnum<EnumMonsterSpawnerType> {
    protected static final AxisAlignedBB BB = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.125, 0.875);

    public BlockTGSpawner(String name) {
        super(name, Material.field_151576_e, EnumMonsterSpawnerType.class);
        this.func_149722_s();
    }

    @Override
    public void registerBlock(RegistryEvent.Register<Block> event) {
        super.registerBlock(event);
        GameRegistry.registerTileEntity(TGSpawnerTileEnt.class, (String)"techguns:TGSpawner");
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TGSpawnerTileEnt();
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BB;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile != null && tile instanceof TGSpawnerTileEnt) {
            TGSpawnerTileEnt spawner = (TGSpawnerTileEnt)tile;
            switch ((EnumMonsterSpawnerType)((Object)state.func_177229_b((IProperty)this.TYPE))) {
                case HOLE: {
                    spawner.addMobType(ZombieSoldier.class, 1);
                    break;
                }
                case SOLDIER_SPAWN: {
                    spawner.addMobType(ArmySoldier.class, 1);
                    break;
                }
            }
        }
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }
}

