/*
 * Decompiled with CFR 0.152.
 */
package techguns.blocks;

import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.ModelLoader;
import techguns.blocks.BlockTGCamoNet;
import techguns.blocks.EnumCamoNetType;
import techguns.blocks.EnumConnectionType;
import techguns.blocks.GenericBlockMetaEnumCamoChangeable;

public class BlockTGCamoNetTop
extends GenericBlockMetaEnumCamoChangeable<EnumCamoNetType> {
    public static PropertyEnum<EnumConnectionType> CONNECTION = BlockTGCamoNet.CONNECTION;
    private static final float height = 0.0625f;
    protected static final AxisAlignedBB[] bounding_boxes = new AxisAlignedBB[]{new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.0625, 0.75), new AxisAlignedBB(0.0, 0.0, 0.25, 0.5625, 0.0625, 0.75), new AxisAlignedBB(0.25, 0.0, 0.4375, 0.75, 0.0625, 1.0), new AxisAlignedBB(0.0, 0.0, 0.4375, 0.5625, 0.0625, 1.0), new AxisAlignedBB(0.4375, 0.0, 0.25, 1.0, 0.0625, 0.75), new AxisAlignedBB(0.0, 0.0, 0.25, 1.0, 0.0625, 0.75), new AxisAlignedBB(0.4375, 0.0, 0.4375, 1.0, 0.0625, 1.0), new AxisAlignedBB(0.0, 0.0, 0.4375, 1.0, 0.0625, 1.0), new AxisAlignedBB(0.25, 0.0, 0.0, 0.75, 0.0625, 0.5625), new AxisAlignedBB(0.0, 0.0, 0.0, 0.5625, 0.0625, 0.5625), new AxisAlignedBB(0.25, 0.0, 0.0, 0.75, 0.0625, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 0.5625, 0.0625, 1.0), new AxisAlignedBB(0.4375, 0.0, 0.0, 1.0, 0.0625, 0.5625), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 0.5625), new AxisAlignedBB(0.4375, 0.0, 0.0, 1.0, 0.0625, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0)};

    public BlockTGCamoNetTop(String name) {
        super(name, Material.field_151580_n, MapColor.field_151651_C, SoundType.field_185854_g, EnumCamoNetType.class);
        this.blockStateOverride = new BlockStateContainer.Builder((Block)this).add(new IProperty[]{this.TYPE}).add(new IProperty[]{CONNECTION}).build();
        this.func_180632_j(this.func_176194_O().func_177621_b());
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        boolean north = this.canConnectTo(worldIn, pos, EnumFacing.NORTH);
        boolean east = this.canConnectTo(worldIn, pos, EnumFacing.EAST);
        boolean south = this.canConnectTo(worldIn, pos, EnumFacing.SOUTH);
        boolean west = this.canConnectTo(worldIn, pos, EnumFacing.WEST);
        int index = EnumConnectionType.get(north, east, south, west).ordinal();
        return bounding_boxes[index];
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        boolean n = this.canConnectTo(worldIn, pos, EnumFacing.NORTH);
        boolean e = this.canConnectTo(worldIn, pos, EnumFacing.EAST);
        boolean s = this.canConnectTo(worldIn, pos, EnumFacing.SOUTH);
        boolean w = this.canConnectTo(worldIn, pos, EnumFacing.WEST);
        return state.func_177226_a(CONNECTION, (Comparable)((Object)EnumConnectionType.get(n, e, s, w)));
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    private boolean canConnectTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        BlockPos other = pos.func_177972_a(facing);
        Block block = world.func_180495_p(other).func_177230_c();
        return block instanceof BlockTGCamoNetTop;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public BlockFaceShape func_193383_a(IBlockAccess p_193383_1_, IBlockState p_193383_2_, BlockPos p_193383_3_, EnumFacing p_193383_4_) {
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    public void registerItemBlockModels() {
        for (int i = 0; i < ((EnumCamoNetType[])this.clazz.getEnumConstants()).length; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)this.itemblock, (int)i, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName() + "_inventory", "type=" + ((EnumCamoNetType[])this.clazz.getEnumConstants())[i].func_176610_l()));
        }
    }
}

