/*
 * Decompiled with CFR 0.152.
 */
package techguns;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.oredict.OreDictionary;
import techguns.TGBlocks;
import techguns.TGConfig;
import techguns.TGFluids;
import techguns.blocks.EnumOreClusterType;
import techguns.blocks.EnumOreType;
import techguns.blocks.IEnumOreClusterType;
import techguns.init.ITGInitializer;
import techguns.tileentities.operation.MachineOperation;

public class TGOreClusters
implements ITGInitializer {
    protected HashMap<EnumOreClusterType, OreCluster> registry = new HashMap();

    public OreCluster getClusterForType(IEnumOreClusterType type) {
        return this.registry.get(type);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        this.registry.put(EnumOreClusterType.COAL, new OreCluster(TGConfig.mininglevel_coal, TGConfig.oremult_coal, TGConfig.powermult_coal));
        this.registry.put(EnumOreClusterType.COMMON_METAL, new OreCluster(TGConfig.mininglevel_common_metal, TGConfig.oremult_common_metal, TGConfig.powermult_common_metal));
        this.registry.put(EnumOreClusterType.RARE_METAL, new OreCluster(TGConfig.mininglevel_rare_metal, TGConfig.oremult_rare_metal, TGConfig.powermult_rare_metal));
        this.registry.put(EnumOreClusterType.SHINY_METAL, new OreCluster(TGConfig.mininglevel_shiny_metal, TGConfig.oremult_shiny_metal, TGConfig.powermult_shiny_metal));
        this.registry.put(EnumOreClusterType.URANIUM, new OreCluster(TGConfig.mininglevel_uranium, TGConfig.oremult_uranium, TGConfig.powermult_uranium));
        this.registry.put(EnumOreClusterType.COMMON_GEM, new OreCluster(TGConfig.mininglevel_common_gem, TGConfig.oremult_common_gem, TGConfig.powermult_common_gem));
        this.registry.put(EnumOreClusterType.SHINY_GEM, new OreCluster(TGConfig.mininglevel_shiny_gem, TGConfig.oremult_shiny_gem, TGConfig.powermult_shiny_gem));
        this.registry.put(EnumOreClusterType.NETHER_CRYSTAL, new OreCluster(TGConfig.mininglevel_nether_crystal, TGConfig.oremult_nether_crystal, TGConfig.powermult_nether_crystal));
        this.registry.put(EnumOreClusterType.OIL, new OreCluster(TGConfig.mininglevel_oil, TGConfig.oremult_oil, TGConfig.powermult_oil));
    }

    public void RecipeInit() {
        this.addOreToCluster(new ItemStack(Blocks.field_150365_q), EnumOreClusterType.COAL, 99);
        this.addOreToCluster(new ItemStack(Items.field_151045_i), EnumOreClusterType.COAL, 1);
        this.addOreToCluster(new ItemStack(Blocks.field_150366_p), EnumOreClusterType.COMMON_METAL, 45);
        this.addOreToCluster(new ItemStack((Block)TGBlocks.TG_ORE, 1, EnumOreType.ORE_COPPER.ordinal()), EnumOreClusterType.COMMON_METAL, 30);
        this.addOreToCluster(new ItemStack((Block)TGBlocks.TG_ORE, 1, EnumOreType.ORE_TIN.ordinal()), EnumOreClusterType.COMMON_METAL, 25);
        this.addOreToCluster(new ItemStack((Block)TGBlocks.TG_ORE, 1, EnumOreType.ORE_LEAD.ordinal()), EnumOreClusterType.RARE_METAL, 50);
        this.addOreToCluster(new ItemStack((Block)TGBlocks.TG_ORE, 1, EnumOreType.ORE_TITANIUM.ordinal()), EnumOreClusterType.SHINY_METAL, 20);
        this.addOreToCluster(new ItemStack(Blocks.field_150352_o), EnumOreClusterType.SHINY_METAL, 40);
        this.addOreToCluster(new ItemStack(Blocks.field_150450_ax), EnumOreClusterType.COMMON_GEM, 40);
        this.addOreToCluster(new ItemStack(Blocks.field_150369_x), EnumOreClusterType.COMMON_GEM, 20);
        this.addOreToCluster(new ItemStack(Blocks.field_150482_ag), EnumOreClusterType.SHINY_GEM, 40);
        this.addOreToCluster(new ItemStack(Blocks.field_150412_bA), EnumOreClusterType.SHINY_GEM, 20);
        this.addOreToCluster(new ItemStack((Block)TGBlocks.TG_ORE, 1, EnumOreType.ORE_URANIUM.ordinal()), EnumOreClusterType.URANIUM, 50);
        this.addOreToCluster(new ItemStack(Blocks.field_150449_bY), EnumOreClusterType.NETHER_CRYSTAL, 50);
        this.addOreToCluster(new ItemStack(Blocks.field_150426_aN), EnumOreClusterType.NETHER_CRYSTAL, 40);
        this.addOreToCluster(new ItemStack(Items.field_151072_bj), EnumOreClusterType.NETHER_CRYSTAL, 10);
        if (!TGFluids.worldspawn_oils.isEmpty()) {
            if (TGFluids.OIL_WORLDSPAWN != null) {
                this.addOreToCluster(new FluidStack(TGFluids.OIL_WORLDSPAWN, 1000), EnumOreClusterType.OIL, 10);
            } else {
                this.addOreToCluster(new FluidStack(TGFluids.worldspawn_oils.get(0), 1000), EnumOreClusterType.OIL, 10);
            }
        }
        this.addOreToCluster("oreSilver", EnumOreClusterType.SHINY_METAL, 40);
        this.addOreToCluster("oreOsmium", EnumOreClusterType.RARE_METAL, 50);
        this.addOreToCluster("oreAluminium", EnumOreClusterType.RARE_METAL, 50);
        this.addOreToCluster("oreCertusQuartz", EnumOreClusterType.COMMON_GEM, 40);
        this.addOreToCluster("oreChargedCertusQuartz", EnumOreClusterType.COMMON_GEM, 5);
    }

    @Override
    public void init(FMLInitializationEvent event) {
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
    }

    public boolean removeOreFromCluster(ItemStack ore, EnumOreClusterType type) {
        OreClusterWeightedEntry entry;
        OreCluster c = this.registry.get(type);
        if (c != null && c.oreEntries.contains((Object)(entry = new OreClusterWeightedEntry(ore, 1)))) {
            return c.oreEntries.remove((Object)entry);
        }
        return false;
    }

    public boolean removeOreFromCluster(FluidStack fluid, EnumOreClusterType type) {
        OreClusterWeightedEntry entry;
        OreCluster c = this.registry.get(type);
        if (c != null && c.oreEntries.contains((Object)(entry = new OreClusterWeightedEntry(fluid, 1)))) {
            return c.oreEntries.remove((Object)entry);
        }
        return false;
    }

    public void addOreToCluster(ItemStack ore, EnumOreClusterType type, int weight) {
        OreCluster c = this.registry.get(type);
        if (c != null) {
            ItemStack ore2 = ore.func_77946_l();
            ore2.func_190920_e(1);
            OreClusterWeightedEntry entry = new OreClusterWeightedEntry(ore2, weight);
            if (!c.oreEntries.contains((Object)entry)) {
                c.oreEntries.add(entry);
            }
        }
    }

    public void addOreToCluster(FluidStack fluid, EnumOreClusterType type, int weight) {
        OreCluster c = this.registry.get(type);
        if (c != null) {
            FluidStack fluid2 = fluid.copy();
            fluid2.amount = 1000;
            OreClusterWeightedEntry entry = new OreClusterWeightedEntry(fluid2, weight);
            if (!c.oreEntries.contains((Object)entry)) {
                c.oreEntries.add(entry);
            }
        }
    }

    public void addOreToCluster(String oredict, EnumOreClusterType type, int weight) {
        OreClusterWeightedEntry entry;
        OreCluster c = this.registry.get(type);
        if (c != null && !(entry = new OreClusterWeightedEntry(oredict, weight)).isEmpty() && !c.oreEntries.contains((Object)entry)) {
            c.oreEntries.add(entry);
        }
    }

    public static class OreCluster {
        int mininglevel;
        double multiplier_amount;
        double multiplier_power;
        ArrayList<OreClusterWeightedEntry> oreEntries = new ArrayList();

        public OreCluster(int mininglevel, double multiplier_amount, double multiplier_power) {
            this.mininglevel = mininglevel;
            this.multiplier_amount = multiplier_amount;
            this.multiplier_power = multiplier_power;
        }

        public int getMininglevel() {
            return this.mininglevel;
        }

        public double getMultiplier_amount() {
            return this.multiplier_amount;
        }

        public double getMultiplier_power() {
            return this.multiplier_power;
        }

        public ArrayList<OreClusterWeightedEntry> getOreEntries() {
            return this.oreEntries;
        }

        public MachineOperation getNewOperation(World w, double orePerHour, int radius, double powerMult) {
            if (!this.oreEntries.isEmpty()) {
                OreClusterWeightedEntry entry = (OreClusterWeightedEntry)WeightedRandom.func_76271_a((Random)w.field_73012_v, this.oreEntries);
                MachineOperation op = null;
                if (!entry.ore.func_190926_b()) {
                    op = new MachineOperation(new ItemStack(entry.ore.func_77973_b(), 1, entry.ore.func_77952_i()), null, new ItemStack[0]);
                } else if (entry.fluid != null) {
                    op = new MachineOperation(ItemStack.field_190927_a, new FluidStack(entry.fluid.getFluid(), 1000), new ItemStack[0]);
                }
                if (op != null) {
                    op.setPowerPerTick((int)(8.0 * orePerHour * (1.0 + (double)Math.max(radius - 1, 0) * 0.2) * powerMult * (double)TGConfig.oreDrillMultiplierPower));
                    return op;
                }
            }
            return this.getCobbleStoneOperation();
        }

        public MachineOperation getCobbleStoneOperation() {
            MachineOperation op = new MachineOperation(new ItemStack(Blocks.field_150347_e), new ItemStack[0]);
            op.setPowerPerTick((int)(24.0f * TGConfig.oreDrillMultiplierPower));
            return op;
        }
    }

    public static class OreClusterWeightedEntry
    extends WeightedRandom.Item {
        ItemStack ore = ItemStack.field_190927_a;
        FluidStack fluid = null;
        String oredictname = null;

        public OreClusterWeightedEntry(ItemStack ore, int itemWeightIn) {
            super(itemWeightIn);
            this.ore = ore;
        }

        public OreClusterWeightedEntry(FluidStack fluid, int itemWeightIn) {
            super(itemWeightIn);
            this.fluid = fluid;
        }

        public OreClusterWeightedEntry(String oredictname, int itemWeightIn) {
            super(itemWeightIn);
            NonNullList ores = OreDictionary.getOres((String)oredictname);
            if (!ores.isEmpty()) {
                this.ore = ((ItemStack)ores.get(0)).func_77946_l();
            }
        }

        public boolean isEmpty() {
            return this.ore.func_190926_b() && this.fluid == null;
        }

        public ItemStack getOre() {
            return this.ore;
        }

        public FluidStack getFluid() {
            return this.fluid;
        }

        public boolean equals(Object obj) {
            if (obj instanceof OreClusterWeightedEntry) {
                OreClusterWeightedEntry other = (OreClusterWeightedEntry)((Object)obj);
                if (this.oredictname != null && other.oredictname != null) {
                    return this.oredictname.equals(other.oredictname);
                }
                if (!this.ore.func_190926_b() && !other.ore.func_190926_b()) {
                    return this.ore.func_77973_b() == other.ore.func_77973_b() && this.ore.func_77952_i() == other.ore.func_77952_i();
                }
                if (this.fluid != null && other.fluid != null) {
                    return this.fluid.getFluid() == other.fluid.getFluid();
                }
            }
            return this == obj;
        }
    }
}

