/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.questing.tasks;

import betterquesting.NBTUtil;
import betterquesting.api.enums.EnumLogic;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.tasks.IItemTask;
import betterquesting.api.utils.BigItemStack;
import betterquesting.api.utils.ItemComparison;
import betterquesting.api.utils.JsonHelper;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.utils.ParticipantInfo;
import betterquesting.client.gui2.editors.tasks.GuiEditTaskRetrieval;
import betterquesting.client.gui2.tasks.PanelTaskRetrieval;
import betterquesting.core.BetterQuesting;
import betterquesting.questing.tasks.ITaskInventory;
import betterquesting.questing.tasks.factory.FactoryTaskRetrieval;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;

public class TaskRetrieval
implements ITaskInventory,
IItemTask {
    private static final boolean DEFAULT_PARTIAL_MATCH = true;
    private static final boolean DEFAULT_IGNORE_NBT = false;
    private static final boolean DEFAULT_CONSUME = false;
    private static final boolean DEFAULT_GROUP_DETECT = false;
    private static final boolean DEFAULT_AUTO_CONSUME = false;
    private static final EnumLogic DEFAULT_ENTRY_LOGIC = EnumLogic.AND;
    private final Set<UUID> completeUsers = new TreeSet<UUID>();
    public final NonNullList<BigItemStack> requiredItems = NonNullList.func_191196_a();
    private final TreeMap<UUID, int[]> userProgress = new TreeMap();
    public boolean partialMatch = true;
    public boolean ignoreNBT = false;
    public boolean consume = false;
    public boolean groupDetect = false;
    public boolean autoConsume = false;
    public EnumLogic entryLogic = DEFAULT_ENTRY_LOGIC;

    @Override
    public String getUnlocalisedName() {
        return "bq_standard.task.retrieval";
    }

    @Override
    public ResourceLocation getFactoryID() {
        return FactoryTaskRetrieval.INSTANCE.getRegistryName();
    }

    @Override
    public boolean isComplete(UUID uuid) {
        return this.completeUsers.contains(uuid);
    }

    @Override
    public void setComplete(UUID uuid) {
        this.completeUsers.add(uuid);
    }

    @Override
    public void onInventoryChange(@Nonnull DBEntry<IQuest> quest, @Nonnull ParticipantInfo pInfo) {
        if (!this.consume || this.autoConsume) {
            this.detect(pInfo, quest);
        }
    }

    @Override
    public void detect(ParticipantInfo pInfo, DBEntry<IQuest> quest) {
        List<InventoryPlayer> invoList;
        if (this.isComplete(pInfo.UUID)) {
            return;
        }
        List<Tuple<UUID, int[]>> progress = this.getBulkProgress(this.consume ? Collections.singletonList(pInfo.UUID) : pInfo.ALL_UUIDS);
        boolean updated = false;
        if (!this.consume) {
            if (this.groupDetect) {
                progress.forEach(value -> Arrays.fill((int[])value.func_76340_b(), 0));
            } else {
                for (int i = 0; i < this.requiredItems.size(); ++i) {
                    int r = ((BigItemStack)this.requiredItems.get((int)i)).stackSize;
                    for (Tuple tuple : progress) {
                        int n = ((int[])tuple.func_76340_b())[i];
                        if (n == 0 || n >= r) continue;
                        ((int[])tuple.func_76340_b())[i] = 0;
                        updated = true;
                    }
                }
            }
        }
        if (this.consume) {
            invoList = Collections.singletonList(pInfo.PLAYER.field_71071_by);
        } else {
            invoList = new ArrayList<InventoryPlayer>(pInfo.ACTIVE_PLAYERS.size());
            pInfo.ACTIVE_PLAYERS.forEach(p -> invoList.add(p.field_71071_by));
        }
        int[] remCounts = new int[progress.size()];
        for (InventoryPlayer inventoryPlayer : invoList) {
            for (int i = 0; i < inventoryPlayer.func_70302_i_(); ++i) {
                ItemStack stack = inventoryPlayer.func_70301_a(i);
                if (stack.func_190926_b()) continue;
                Arrays.fill(remCounts, stack.func_190916_E());
                for (int j = 0; j < this.requiredItems.size(); ++j) {
                    BigItemStack rStack = (BigItemStack)this.requiredItems.get(j);
                    if (!ItemComparison.StackMatch(rStack.getBaseStack(), stack, !this.ignoreNBT, this.partialMatch) && !ItemComparison.OreDictionaryMatch(rStack.getOreIngredient(), rStack.GetTagCompound(), stack, !this.ignoreNBT, this.partialMatch)) continue;
                    for (int n = 0; n < progress.size(); ++n) {
                        Tuple<UUID, int[]> value3 = progress.get(n);
                        if (((int[])value3.func_76340_b())[j] >= rStack.stackSize) continue;
                        int remaining = rStack.stackSize - ((int[])value3.func_76340_b())[j];
                        if (this.consume) {
                            ItemStack removed = inventoryPlayer.func_70298_a(i, remaining);
                            int[] nArray = (int[])value3.func_76340_b();
                            int n2 = j;
                            nArray[n2] = nArray[n2] + removed.func_190916_E();
                        } else {
                            int temp = Math.min(remaining, remCounts[n]);
                            int n3 = n;
                            remCounts[n3] = remCounts[n3] - temp;
                            int[] nArray = (int[])value3.func_76340_b();
                            int n4 = j;
                            nArray[n4] = nArray[n4] + temp;
                        }
                        updated = true;
                    }
                }
            }
        }
        if (updated) {
            this.setBulkProgress(progress);
        }
        this.checkAndComplete(pInfo, quest, updated, progress);
    }

    private void checkAndComplete(ParticipantInfo pInfo, DBEntry<IQuest> quest, boolean resync) {
        this.checkAndComplete(pInfo, quest, resync, this.getBulkProgress(this.consume ? Collections.singletonList(pInfo.UUID) : pInfo.ALL_UUIDS));
    }

    private void checkAndComplete(ParticipantInfo pInfo, DBEntry<IQuest> quest, boolean resync, List<Tuple<UUID, int[]>> progress) {
        boolean updated = resync;
        for (Tuple<UUID, int[]> value : progress) {
            int count = 0;
            for (int j = 0; j < this.requiredItems.size(); ++j) {
                if (((int[])value.func_76340_b())[j] < ((BigItemStack)this.requiredItems.get((int)j)).stackSize) continue;
                ++count;
            }
            if (!this.entryLogic.getResult(count, this.requiredItems.size())) continue;
            updated = true;
            if (this.consume) {
                this.setComplete((UUID)value.func_76341_a());
                continue;
            }
            progress.forEach(pair -> this.setComplete((UUID)pair.func_76341_a()));
            break;
        }
        if (updated) {
            if (this.consume) {
                pInfo.markDirty(Collections.singletonList(quest.getID()));
            } else {
                pInfo.markDirtyParty(Collections.singletonList(quest.getID()));
            }
        }
    }

    @Override
    @Deprecated
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        return this.writeToNBT(nbt, false);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt, boolean reduce) {
        NBTUtil.setBoolean(nbt, "partialMatch", this.partialMatch, true, reduce);
        NBTUtil.setBoolean(nbt, "ignoreNBT", this.ignoreNBT, false, reduce);
        NBTUtil.setBoolean(nbt, "consume", this.consume, false, reduce);
        NBTUtil.setBoolean(nbt, "groupDetect", this.groupDetect, false, reduce);
        NBTUtil.setBoolean(nbt, "autoConsume", this.autoConsume, false, reduce);
        NBTUtil.setString(nbt, "entryLogic", this.entryLogic.name(), DEFAULT_ENTRY_LOGIC.name(), reduce);
        NBTTagList itemArray = new NBTTagList();
        for (BigItemStack stack : this.requiredItems) {
            itemArray.func_74742_a((NBTBase)JsonHelper.ItemStackToJson(stack, new NBTTagCompound(), reduce));
        }
        nbt.func_74782_a("requiredItems", (NBTBase)itemArray);
        return nbt;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.partialMatch = NBTUtil.getBoolean(nbt, "partialMatch", true);
        this.ignoreNBT = NBTUtil.getBoolean(nbt, "ignoreNBT", false);
        this.consume = NBTUtil.getBoolean(nbt, "consume", false);
        this.groupDetect = NBTUtil.getBoolean(nbt, "groupDetect", false);
        this.autoConsume = NBTUtil.getBoolean(nbt, "autoConsume", false);
        this.entryLogic = NBTUtil.getEnum(nbt, "entryLogic", EnumLogic.class, true, DEFAULT_ENTRY_LOGIC);
        this.requiredItems.clear();
        NBTTagList iList = nbt.func_150295_c("requiredItems", 10);
        for (int i = 0; i < iList.func_74745_c(); ++i) {
            this.requiredItems.add((Object)JsonHelper.JsonToItemStack(iList.func_150305_b(i)));
        }
    }

    @Override
    public void readProgressFromNBT(NBTTagCompound nbt, boolean merge) {
        if (!merge) {
            this.completeUsers.clear();
            this.userProgress.clear();
        }
        NBTTagList cList = nbt.func_150295_c("completeUsers", 8);
        for (int i = 0; i < cList.func_74745_c(); ++i) {
            try {
                this.completeUsers.add(UUID.fromString(cList.func_150307_f(i)));
                continue;
            }
            catch (Exception e) {
                BetterQuesting.logger.log(Level.ERROR, "Unable to load UUID for task", (Throwable)e);
            }
        }
        NBTTagList pList = nbt.func_150295_c("userProgress", 10);
        for (int n = 0; n < pList.func_74745_c(); ++n) {
            try {
                NBTTagCompound pTag = pList.func_150305_b(n);
                UUID uuid = UUID.fromString(pTag.func_74779_i("uuid"));
                int[] data = new int[this.requiredItems.size()];
                NBTTagList dNbt = pTag.func_150295_c("data", 3);
                for (int i = 0; i < data.length && i < dNbt.func_74745_c(); ++i) {
                    data[i] = dNbt.func_186858_c(i);
                }
                this.userProgress.put(uuid, data);
                continue;
            }
            catch (Exception e) {
                BetterQuesting.logger.log(Level.ERROR, "Unable to load user progress for task", (Throwable)e);
            }
        }
    }

    @Override
    public NBTTagCompound writeProgressToNBT(NBTTagCompound nbt, @Nullable List<UUID> users) {
        NBTTagList jArray = new NBTTagList();
        NBTTagList progArray = new NBTTagList();
        if (users != null) {
            users.forEach(uuid -> {
                int[] data;
                if (this.completeUsers.contains(uuid)) {
                    jArray.func_74742_a((NBTBase)new NBTTagString(uuid.toString()));
                }
                if ((data = this.userProgress.get(uuid)) != null) {
                    NBTTagCompound pJson = new NBTTagCompound();
                    pJson.func_74778_a("uuid", uuid.toString());
                    NBTTagList pArray = new NBTTagList();
                    for (int i : data) {
                        pArray.func_74742_a((NBTBase)new NBTTagInt(i));
                    }
                    pJson.func_74782_a("data", (NBTBase)pArray);
                    progArray.func_74742_a((NBTBase)pJson);
                }
            });
        } else {
            this.completeUsers.forEach(uuid -> jArray.func_74742_a((NBTBase)new NBTTagString(uuid.toString())));
            this.userProgress.forEach((uuid, data) -> {
                NBTTagCompound pJson = new NBTTagCompound();
                pJson.func_74778_a("uuid", uuid.toString());
                NBTTagList pArray = new NBTTagList();
                for (int i : data) {
                    pArray.func_74742_a((NBTBase)new NBTTagInt(i));
                }
                pJson.func_74782_a("data", (NBTBase)pArray);
                progArray.func_74742_a((NBTBase)pJson);
            });
        }
        nbt.func_74782_a("completeUsers", (NBTBase)jArray);
        nbt.func_74782_a("userProgress", (NBTBase)progArray);
        return nbt;
    }

    @Override
    public void resetUser(@Nullable UUID uuid) {
        if (uuid == null) {
            this.completeUsers.clear();
            this.userProgress.clear();
        } else {
            this.completeUsers.remove(uuid);
            this.userProgress.remove(uuid);
        }
    }

    @Override
    public IGuiPanel getTaskGui(IGuiRect rect, DBEntry<IQuest> quest) {
        return new PanelTaskRetrieval(rect, this);
    }

    @Override
    public boolean canAcceptItem(UUID owner, DBEntry<IQuest> quest, ItemStack stack) {
        if (owner == null || stack == null || stack.func_190926_b() || !this.consume || this.isComplete(owner) || this.requiredItems.size() <= 0) {
            return false;
        }
        int[] progress = this.getUsersProgress(owner);
        for (int j = 0; j < this.requiredItems.size(); ++j) {
            BigItemStack rStack = (BigItemStack)this.requiredItems.get(j);
            if (progress[j] >= rStack.stackSize || !ItemComparison.StackMatch(rStack.getBaseStack(), stack, !this.ignoreNBT, this.partialMatch) && !ItemComparison.OreDictionaryMatch(rStack.getOreIngredient(), rStack.GetTagCompound(), stack, !this.ignoreNBT, this.partialMatch)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ItemStack submitItem(UUID owner, DBEntry<IQuest> quest, ItemStack input) {
        if (owner == null || input.func_190926_b() || !this.consume || this.isComplete(owner)) {
            return input;
        }
        ItemStack stack = input.func_77946_l();
        int[] progress = this.getUsersProgress(owner);
        boolean updated = false;
        for (int j2 = 0; j2 < this.requiredItems.size() && !stack.func_190926_b(); ++j2) {
            BigItemStack rStack = (BigItemStack)this.requiredItems.get(j2);
            if (progress[j2] >= rStack.stackSize) continue;
            int remaining = rStack.stackSize - progress[j2];
            if (!ItemComparison.StackMatch(rStack.getBaseStack(), stack, !this.ignoreNBT, this.partialMatch) && !ItemComparison.OreDictionaryMatch(rStack.getOreIngredient(), rStack.GetTagCompound(), stack, !this.ignoreNBT, this.partialMatch)) continue;
            int removed = Math.min(stack.func_190916_E(), remaining);
            stack.func_190918_g(removed);
            int n = j2;
            progress[n] = progress[n] + removed;
            updated = true;
            if (stack.func_190926_b()) break;
        }
        if (updated) {
            EntityPlayerMP player;
            this.setUserProgress(owner, progress);
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            EntityPlayerMP entityPlayerMP = player = server == null ? null : server.func_184103_al().func_177451_a(owner);
            if (player != null) {
                this.checkAndComplete(new ParticipantInfo((EntityPlayer)player), quest, true);
            } else {
                int count = (int)IntStream.range(0, this.requiredItems.size()).filter(j -> progress[j] >= ((BigItemStack)this.requiredItems.get((int)j)).stackSize).count();
                if (this.entryLogic.getResult(count, this.requiredItems.size())) {
                    this.setComplete(owner);
                }
            }
        }
        return stack.func_190926_b() ? ItemStack.field_190927_a : stack;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getTaskEditor(GuiScreen parent, DBEntry<IQuest> quest) {
        return new GuiEditTaskRetrieval(parent, quest, this);
    }

    private void setUserProgress(UUID uuid, int[] progress) {
        this.userProgress.put(uuid, progress);
    }

    public int[] getUsersProgress(UUID uuid) {
        int[] progress = this.userProgress.get(uuid);
        return progress == null || progress.length != this.requiredItems.size() ? new int[this.requiredItems.size()] : progress;
    }

    private List<Tuple<UUID, int[]>> getBulkProgress(@Nonnull List<UUID> uuids) {
        if (uuids.size() <= 0) {
            return Collections.emptyList();
        }
        ArrayList<Tuple<UUID, int[]>> list = new ArrayList<Tuple<UUID, int[]>>(uuids.size());
        uuids.forEach(key -> list.add(new Tuple(key, (Object)this.getUsersProgress((UUID)key))));
        return list;
    }

    private void setBulkProgress(@Nonnull List<Tuple<UUID, int[]>> list) {
        list.forEach(entry -> this.setUserProgress((UUID)entry.func_76341_a(), (int[])entry.func_76340_b()));
    }

    @Override
    public List<String> getTextForSearch() {
        ArrayList<String> texts = new ArrayList<String>();
        for (BigItemStack bigStack : this.requiredItems) {
            ItemStack stack = bigStack.getBaseStack();
            texts.add(stack.func_82833_r());
            if (!bigStack.hasOreDict()) continue;
            texts.add(bigStack.getOreDict());
        }
        return texts;
    }
}

