/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.questing.tasks;

import betterquesting.NBTUtil;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.tasks.ITask;
import betterquesting.api.utils.BigItemStack;
import betterquesting.api.utils.ItemComparison;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.utils.ParticipantInfo;
import betterquesting.client.gui2.tasks.PanelTaskInteractEntity;
import betterquesting.core.BetterQuesting;
import betterquesting.questing.tasks.factory.FactoryTaskInteractEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;

public class TaskInteractEntity
implements ITask {
    private static final boolean DEFAULT_IGNORE_ITEM_NBT = false;
    private static final boolean DEFAULT_PARTIAL_ITEM_MATCH = true;
    private static final boolean DEFAULT_USE_MAIN_HAND = true;
    private static final boolean DEFAULT_USE_OFFHAND = true;
    private static final boolean DEFAULT_ENTITY_SUBTYPES = true;
    private static final boolean DEFAULT_IGNORE_ENTITY_NBT = true;
    private static final boolean DEFAULT_ON_INTERACT = true;
    private static final boolean DEFAULT_ON_HIT = false;
    private static final int DEFAULT_REQUIRED = 1;
    private final Set<UUID> completeUsers = new TreeSet<UUID>();
    private final TreeMap<UUID, Integer> userProgress = new TreeMap();
    public BigItemStack targetItem = new BigItemStack(Items.field_190931_a);
    public boolean ignoreItemNBT = false;
    public boolean partialItemMatch = true;
    public boolean useMainHand = true;
    public boolean useOffHand = true;
    public String entityID = "minecraft:villager";
    public NBTTagCompound entityTags = new NBTTagCompound();
    public boolean entitySubtypes = true;
    public boolean ignoreEntityNBT = true;
    public boolean onInteract = true;
    public boolean onHit = false;
    public int required = 1;

    @Override
    public String getUnlocalisedName() {
        return "bq_standard.task.interact_entity";
    }

    @Override
    public ResourceLocation getFactoryID() {
        return FactoryTaskInteractEntity.INSTANCE.getRegistryName();
    }

    public void onInteract(ParticipantInfo pInfo, DBEntry<IQuest> quest, EnumHand hand, ItemStack item, Entity entity, boolean isHit) {
        if (!this.onHit && isHit || !this.onInteract && !isHit) {
            return;
        }
        if (!this.useMainHand && hand == EnumHand.MAIN_HAND || !this.useOffHand && hand == EnumHand.OFF_HAND) {
            return;
        }
        ResourceLocation targetRes = new ResourceLocation(this.entityID);
        Class targetClass = EntityList.getClass((ResourceLocation)targetRes);
        if (targetClass == null) {
            return;
        }
        Class<?> subjectClass = entity.getClass();
        ResourceLocation subjectRes = EntityList.func_191301_a((Entity)entity);
        if (subjectRes == null) {
            return;
        }
        if (this.entitySubtypes ? !targetClass.isAssignableFrom(subjectClass) : !subjectRes.equals((Object)targetRes)) {
            return;
        }
        if (!this.ignoreEntityNBT) {
            NBTTagCompound subjectTags = new NBTTagCompound();
            entity.func_70039_c(subjectTags);
            if (!ItemComparison.CompareNBTTag((NBTBase)this.entityTags, (NBTBase)subjectTags, true)) {
                return;
            }
        }
        if (this.targetItem.getBaseStack().func_77973_b() != Items.field_190931_a) {
            if (this.targetItem.hasOreDict() && !ItemComparison.OreDictionaryMatch(this.targetItem.getOreIngredient(), this.targetItem.GetTagCompound(), item, !this.ignoreItemNBT, this.partialItemMatch)) {
                return;
            }
            if (!ItemComparison.StackMatch(this.targetItem.getBaseStack(), item, !this.ignoreItemNBT, this.partialItemMatch)) {
                return;
            }
        }
        List<Tuple<UUID, Integer>> progress = this.getBulkProgress(pInfo.ALL_UUIDS);
        progress.forEach(value -> {
            if (this.isComplete((UUID)value.func_76341_a())) {
                return;
            }
            int np = Math.min(this.required, (Integer)value.func_76340_b() + 1);
            this.setUserProgress((UUID)value.func_76341_a(), np);
            if (np >= this.required) {
                this.setComplete((UUID)value.func_76341_a());
            }
        });
        pInfo.markDirtyParty(Collections.singletonList(quest.getID()));
    }

    @Override
    public void detect(ParticipantInfo pInfo, DBEntry<IQuest> quest) {
        List<Tuple<UUID, Integer>> progress = this.getBulkProgress(pInfo.ALL_UUIDS);
        progress.forEach(value -> {
            if ((Integer)value.func_76340_b() >= this.required) {
                this.setComplete((UUID)value.func_76341_a());
            }
        });
        pInfo.markDirtyParty(Collections.singletonList(quest.getID()));
    }

    @Override
    public boolean isComplete(UUID uuid) {
        return this.completeUsers.contains(uuid);
    }

    @Override
    public void setComplete(UUID uuid) {
        this.completeUsers.add(uuid);
    }

    @Override
    public void resetUser(@Nullable UUID uuid) {
        if (uuid == null) {
            this.completeUsers.clear();
            this.userProgress.clear();
        } else {
            this.completeUsers.remove(uuid);
            this.userProgress.remove(uuid);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IGuiPanel getTaskGui(IGuiRect rect, DBEntry<IQuest> quest) {
        return new PanelTaskInteractEntity(rect, this);
    }

    @Override
    @Nullable
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getTaskEditor(GuiScreen parent, DBEntry<IQuest> quest) {
        return null;
    }

    @Override
    public void readProgressFromNBT(NBTTagCompound nbt, boolean merge) {
        if (!merge) {
            this.completeUsers.clear();
            this.userProgress.clear();
        }
        NBTTagList cList = nbt.func_150295_c("completeUsers", 8);
        for (int i = 0; i < cList.func_74745_c(); ++i) {
            try {
                this.completeUsers.add(UUID.fromString(cList.func_150307_f(i)));
                continue;
            }
            catch (Exception e) {
                BetterQuesting.logger.log(Level.ERROR, "Unable to load UUID for task", (Throwable)e);
            }
        }
        NBTTagList pList = nbt.func_150295_c("userProgress", 10);
        for (int n = 0; n < pList.func_74745_c(); ++n) {
            try {
                NBTTagCompound pTag = pList.func_150305_b(n);
                UUID uuid = UUID.fromString(pTag.func_74779_i("uuid"));
                this.userProgress.put(uuid, pTag.func_74762_e("value"));
                continue;
            }
            catch (Exception e) {
                BetterQuesting.logger.log(Level.ERROR, "Unable to load user progress for task", (Throwable)e);
            }
        }
    }

    @Override
    public NBTTagCompound writeProgressToNBT(NBTTagCompound nbt, @Nullable List<UUID> users) {
        NBTTagList jArray = new NBTTagList();
        NBTTagList progArray = new NBTTagList();
        if (users != null) {
            users.forEach(uuid -> {
                Integer data;
                if (this.completeUsers.contains(uuid)) {
                    jArray.func_74742_a((NBTBase)new NBTTagString(uuid.toString()));
                }
                if ((data = this.userProgress.get(uuid)) != null) {
                    NBTTagCompound pJson = new NBTTagCompound();
                    pJson.func_74778_a("uuid", uuid.toString());
                    pJson.func_74768_a("value", data.intValue());
                    progArray.func_74742_a((NBTBase)pJson);
                }
            });
        } else {
            this.completeUsers.forEach(uuid -> jArray.func_74742_a((NBTBase)new NBTTagString(uuid.toString())));
            this.userProgress.forEach((uuid, data) -> {
                NBTTagCompound pJson = new NBTTagCompound();
                pJson.func_74778_a("uuid", uuid.toString());
                pJson.func_74768_a("value", data.intValue());
                progArray.func_74742_a((NBTBase)pJson);
            });
        }
        nbt.func_74782_a("completeUsers", (NBTBase)jArray);
        nbt.func_74782_a("userProgress", (NBTBase)progArray);
        return nbt;
    }

    @Override
    @Deprecated
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        return this.writeToNBT(nbt, false);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt, boolean reduce) {
        nbt.func_74782_a("item", (NBTBase)this.targetItem.writeToNBT(new NBTTagCompound(), reduce));
        NBTUtil.setBoolean(nbt, "ignoreItemNBT", this.ignoreItemNBT, false, reduce);
        NBTUtil.setBoolean(nbt, "partialItemMatch", this.partialItemMatch, true, reduce);
        nbt.func_74778_a("targetID", this.entityID);
        NBTUtil.setTag(nbt, "targetNBT", (NBTBase)this.entityTags, reduce);
        NBTUtil.setBoolean(nbt, "ignoreTargetNBT", this.ignoreEntityNBT, true, reduce);
        NBTUtil.setBoolean(nbt, "targetSubtypes", this.entitySubtypes, true, reduce);
        NBTUtil.setBoolean(nbt, "allowMainHand", this.useMainHand, true, reduce);
        NBTUtil.setBoolean(nbt, "allowOffHand", this.useOffHand, true, reduce);
        NBTUtil.setInteger(nbt, "requiredUses", this.required, 1, reduce);
        NBTUtil.setBoolean(nbt, "onInteract", this.onInteract, true, reduce);
        NBTUtil.setBoolean(nbt, "onHit", this.onHit, false, reduce);
        return nbt;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.targetItem = new BigItemStack(nbt.func_74775_l("item"));
        this.ignoreItemNBT = NBTUtil.getBoolean(nbt, "ignoreItemNBT", false);
        this.partialItemMatch = NBTUtil.getBoolean(nbt, "partialItemMatch", true);
        this.entityID = nbt.func_74779_i("targetID");
        this.entityTags = nbt.func_74775_l("targetNBT");
        this.ignoreEntityNBT = NBTUtil.getBoolean(nbt, "ignoreTargetNBT", true);
        this.entitySubtypes = NBTUtil.getBoolean(nbt, "targetSubtypes", true);
        this.useMainHand = NBTUtil.getBoolean(nbt, "allowMainHand", true);
        this.useOffHand = NBTUtil.getBoolean(nbt, "allowOffHand", true);
        this.required = NBTUtil.getInteger(nbt, "requiredUses", 1);
        this.onInteract = NBTUtil.getBoolean(nbt, "onInteract", true);
        this.onHit = NBTUtil.getBoolean(nbt, "onHit", false);
    }

    private void setUserProgress(UUID uuid, int progress) {
        this.userProgress.put(uuid, progress);
    }

    public int getUsersProgress(UUID uuid) {
        Integer n = this.userProgress.get(uuid);
        return n == null ? 0 : n;
    }

    private List<Tuple<UUID, Integer>> getBulkProgress(@Nonnull List<UUID> uuids) {
        if (uuids.size() <= 0) {
            return Collections.emptyList();
        }
        ArrayList<Tuple<UUID, Integer>> list = new ArrayList<Tuple<UUID, Integer>>();
        uuids.forEach(key -> list.add(new Tuple(key, (Object)this.getUsersProgress((UUID)key))));
        return list;
    }

    @Override
    public List<String> getTextForSearch() {
        ArrayList<String> texts = new ArrayList<String>();
        texts.add(this.entityID);
        if (this.targetItem != null) {
            texts.add(this.targetItem.getBaseStack().func_82833_r());
        }
        return texts;
    }
}

