/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.questing.party;

import betterquesting.api.enums.EnumPartyStatus;
import betterquesting.api.properties.IPropertyContainer;
import betterquesting.api.properties.IPropertyType;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.party.IParty;
import betterquesting.core.BetterQuesting;
import betterquesting.storage.PropertyContainer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class PartyInstance
implements IParty {
    private final HashMap<UUID, EnumPartyStatus> members = new HashMap();
    private List<UUID> memCache = null;
    private final PropertyContainer pInfo = new PropertyContainer();

    public PartyInstance() {
        this.setupProps();
    }

    private void setupProps() {
        this.setupValue(NativeProps.NAME, "New Party");
    }

    private <T> void setupValue(IPropertyType<T> prop) {
        this.setupValue(prop, prop.getDefault());
    }

    private <T> void setupValue(IPropertyType<T> prop, T def) {
        this.pInfo.setProperty(prop, this.pInfo.getProperty(prop, def));
    }

    private void refreshCache() {
        this.memCache = Collections.unmodifiableList(new ArrayList<UUID>(this.members.keySet()));
    }

    @Override
    public IPropertyContainer getProperties() {
        return this.pInfo;
    }

    @Override
    public void kickUser(@Nonnull UUID uuid) {
        if (!this.members.containsKey(uuid)) {
            return;
        }
        EnumPartyStatus old = this.members.get(uuid);
        this.members.remove(uuid);
        if (old == EnumPartyStatus.OWNER && this.members.size() > 0) {
            this.hostMigrate();
        }
        this.refreshCache();
    }

    @Override
    public void setStatus(@Nonnull UUID uuid, @Nonnull EnumPartyStatus priv) {
        EnumPartyStatus old = this.members.get(uuid);
        if (old == priv) {
            return;
        }
        this.members.put(uuid, priv);
        if (priv == EnumPartyStatus.OWNER) {
            for (UUID mem : this.getMembers()) {
                if (mem == uuid || this.members.get(mem) != EnumPartyStatus.OWNER) continue;
                this.members.put(mem, EnumPartyStatus.ADMIN);
            }
        } else if (old == EnumPartyStatus.OWNER) {
            UUID migrate = null;
            for (UUID mem : this.getMembers()) {
                if (mem == uuid) continue;
                if (this.members.get(mem) == EnumPartyStatus.ADMIN) {
                    migrate = mem;
                    break;
                }
                if (migrate != null) continue;
                migrate = mem;
            }
            if (migrate == null) {
                this.members.put(uuid, old);
                return;
            }
            this.members.put(migrate, EnumPartyStatus.OWNER);
        }
        this.refreshCache();
    }

    @Override
    public EnumPartyStatus getStatus(@Nonnull UUID uuid) {
        return this.members.get(uuid);
    }

    @Override
    public List<UUID> getMembers() {
        if (this.memCache == null) {
            this.refreshCache();
        }
        return this.memCache;
    }

    private void hostMigrate() {
        for (Map.Entry<UUID, EnumPartyStatus> entry : this.members.entrySet()) {
            if (entry.getValue() != EnumPartyStatus.OWNER) continue;
            return;
        }
        UUID migrate = null;
        for (Map.Entry<UUID, EnumPartyStatus> entry : this.members.entrySet()) {
            EnumPartyStatus status = entry.getValue();
            if (status == EnumPartyStatus.ADMIN || status == EnumPartyStatus.OWNER) {
                migrate = entry.getKey();
                break;
            }
            if (migrate != null) continue;
            migrate = entry.getKey();
        }
        if (migrate != null) {
            this.members.put(migrate, EnumPartyStatus.OWNER);
        } else {
            BetterQuesting.logger.error("Failed to find suitable host to migrate party " + this.pInfo.getProperty(NativeProps.NAME));
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        NBTTagList memJson = new NBTTagList();
        for (Map.Entry<UUID, EnumPartyStatus> mem : this.members.entrySet()) {
            NBTTagCompound jm = new NBTTagCompound();
            jm.func_74778_a("uuid", mem.getKey().toString());
            jm.func_74778_a("status", mem.getValue().toString());
            memJson.func_74742_a((NBTBase)jm);
        }
        nbt.func_74782_a("members", (NBTBase)memJson);
        nbt.func_74782_a("properties", (NBTBase)this.pInfo.writeToNBT(new NBTTagCompound(), false));
        return nbt;
    }

    @Override
    public void readFromNBT(NBTTagCompound jObj) {
        if (jObj.func_150297_b("properties", 10)) {
            this.pInfo.readFromNBT(jObj.func_74775_l("properties"));
        } else {
            this.pInfo.readFromNBT(new NBTTagCompound());
            this.pInfo.setProperty(NativeProps.NAME, jObj.func_74779_i("name"));
        }
        this.members.clear();
        NBTTagList memList = jObj.func_150295_c("members", 10);
        for (int i = 0; i < memList.func_74745_c(); ++i) {
            try {
                NBTTagCompound jMem = memList.func_150305_b(i);
                if (!jMem.func_150297_b("uuid", 8) || !jMem.func_74764_b("status")) continue;
                UUID uuid = UUID.fromString(jMem.func_74779_i("uuid"));
                EnumPartyStatus priv = EnumPartyStatus.valueOf(jMem.func_74779_i("status"));
                this.members.put(uuid, priv);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.refreshCache();
        this.setupProps();
    }

    @Override
    public NBTTagCompound writeProperties(NBTTagCompound nbt) {
        return this.pInfo.writeToNBT(nbt, true);
    }

    @Override
    public void readProperties(NBTTagCompound nbt) {
        this.pInfo.readFromNBT(nbt);
    }
}

