/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.questing;

import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.IQuestDatabase;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.storage.RandomIndexDatabase;
import betterquesting.questing.QuestInstance;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public final class QuestDatabase
extends RandomIndexDatabase<IQuest>
implements IQuestDatabase {
    public static final QuestDatabase INSTANCE = new QuestDatabase();

    @Override
    public synchronized IQuest createNew(int id) {
        QuestInstance quest = new QuestInstance();
        if (id >= 0) {
            this.add(id, quest);
        }
        return quest;
    }

    @Override
    public synchronized boolean removeID(int id) {
        boolean success = super.removeID(id);
        if (success) {
            for (DBEntry entry : this.getEntries()) {
                this.removeReq((IQuest)entry.getValue(), id);
            }
        }
        return success;
    }

    @Override
    public synchronized boolean removeValue(IQuest value) {
        int id = this.getID(value);
        if (id < 0) {
            return false;
        }
        boolean success = this.removeValue(value);
        if (success) {
            for (DBEntry entry : this.getEntries()) {
                this.removeReq((IQuest)entry.getValue(), id);
            }
        }
        return success;
    }

    private void removeReq(IQuest quest, int id) {
        int[] orig = quest.getRequirements();
        if (orig.length <= 0) {
            return;
        }
        boolean hasRemoved = false;
        int[] rem = new int[orig.length - 1];
        for (int i = 0; i < orig.length; ++i) {
            if (!hasRemoved && orig[i] == id) {
                hasRemoved = true;
                continue;
            }
            if (!hasRemoved && i >= rem.length) break;
            rem[!hasRemoved ? i : i - 1] = orig[i];
        }
        if (hasRemoved) {
            quest.setRequirements(rem);
        }
    }

    @Override
    @Deprecated
    public synchronized NBTTagList writeToNBT(NBTTagList nbt, @Nullable List<Integer> subset) {
        return this.writeToNBT(nbt, subset, false);
    }

    @Override
    public synchronized NBTTagList writeToNBT(NBTTagList nbt, @Nullable List<Integer> subset, boolean reduce) {
        for (DBEntry entry : this.getEntries()) {
            if (subset != null && !subset.contains(entry.getID())) continue;
            NBTTagCompound jq = ((IQuest)entry.getValue()).writeToNBT(new NBTTagCompound(), reduce);
            if (subset != null && jq.func_82582_d()) continue;
            jq.func_74768_a("questID", entry.getID());
            nbt.func_74742_a((NBTBase)jq);
        }
        return nbt;
    }

    @Override
    public synchronized void readFromNBT(NBTTagList nbt, boolean merge) {
        if (!merge) {
            this.reset();
        }
        for (int i = 0; i < nbt.func_74745_c(); ++i) {
            int qID;
            NBTTagCompound qTag = nbt.func_150305_b(i);
            int n = qID = qTag.func_150297_b("questID", 99) ? qTag.func_74762_e("questID") : -1;
            if (qID < 0) continue;
            IQuest quest = (IQuest)this.getValue(qID);
            if (quest == null) {
                quest = this.createNew(qID);
            }
            quest.readFromNBT(qTag);
        }
    }

    @Override
    public synchronized NBTTagList writeProgressToNBT(NBTTagList json, @Nullable List<UUID> users) {
        for (DBEntry entry : this.getEntries()) {
            NBTTagCompound jq = ((IQuest)entry.getValue()).writeProgressToNBT(new NBTTagCompound(), users);
            jq.func_74768_a("questID", entry.getID());
            json.func_74742_a((NBTBase)jq);
        }
        return json;
    }

    @Override
    public synchronized void readProgressFromNBT(NBTTagList json, boolean merge) {
        for (int i = 0; i < json.func_74745_c(); ++i) {
            IQuest quest;
            int qID;
            NBTTagCompound qTag = json.func_150305_b(i);
            int n = qID = qTag.func_150297_b("questID", 99) ? qTag.func_74762_e("questID") : -1;
            if (qID < 0 || (quest = (IQuest)this.getValue(qID)) == null) continue;
            quest.readProgressFromNBT(qTag, merge);
        }
    }
}

