/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.importers.ftbq;

import betterquesting.core.BetterQuesting;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;

public class SNBTReader {
    private static final Pattern BYTE_ARRAY_MATCHER = Pattern.compile("\\[B;([\\s\\d,b]*)]", 2);
    private static final Pattern LONG_ARRAY_MATCHER = Pattern.compile("\\[L;([\\s\\d,l]*)]", 2);

    @Nullable
    public static NBTTagCompound read(File file) {
        String trimmedText;
        if (!file.exists()) {
            return null;
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));){
            String line;
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                sb.append(line.trim());
            }
            trimmedText = sb.toString();
        }
        catch (IOException e) {
            BetterQuesting.logger.error("Failed to read " + file.getAbsolutePath() + ": " + e);
            return null;
        }
        String fixed = SNBTReader.fixLongArray(SNBTReader.fixByteArray(trimmedText));
        try {
            return JsonToNBT.func_180713_a((String)fixed);
        }
        catch (NBTException e) {
            BetterQuesting.logger.error("Failed to read " + file.getAbsolutePath() + ": " + (Object)((Object)e));
            return null;
        }
    }

    private static String fixByteArray(String text) {
        StringBuffer sb = new StringBuffer(text.length());
        Matcher matcher = BYTE_ARRAY_MATCHER.matcher(text);
        while (matcher.find()) {
            String s2 = matcher.group(1);
            if (!s2.isEmpty()) {
                CharSequence[] s3 = s2.split(",");
                for (int i = 0; i < s3.length; ++i) {
                    if (s3[i].endsWith("b") || s3[i].endsWith("B")) continue;
                    int n = i;
                    s3[n] = (String)s3[n] + 'b';
                }
                matcher.appendReplacement(sb, "[B;" + String.join((CharSequence)",", s3) + "]");
                continue;
            }
            matcher.appendReplacement(sb, "[B;]");
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private static String fixLongArray(String text) {
        StringBuffer sb = new StringBuffer(text.length());
        Matcher matcher = LONG_ARRAY_MATCHER.matcher(text);
        while (matcher.find()) {
            String s2 = matcher.group(1);
            if (!s2.isEmpty()) {
                CharSequence[] s3 = s2.split(",");
                for (int i = 0; i < s3.length; ++i) {
                    if (s3[i].endsWith("l") || s3[i].endsWith("L")) continue;
                    int n = i;
                    s3[n] = (String)s3[n] + 'L';
                }
                matcher.appendReplacement(sb, "[L;" + String.join((CharSequence)",", s3) + "]");
                continue;
            }
            matcher.appendReplacement(sb, "[L;]");
        }
        matcher.appendTail(sb);
        return sb.toString();
    }
}

