/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.importers.ftbq;

import betterquesting.api.client.importers.IImporter;
import betterquesting.api.enums.EnumLogic;
import betterquesting.api.enums.EnumQuestVisibility;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.IQuestDatabase;
import betterquesting.api.questing.IQuestLine;
import betterquesting.api.questing.IQuestLineDatabase;
import betterquesting.api.questing.IQuestLineEntry;
import betterquesting.api.questing.rewards.IReward;
import betterquesting.api.questing.tasks.ITask;
import betterquesting.api.utils.BigItemStack;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.storage.IDatabaseNBT;
import betterquesting.core.BetterQuesting;
import betterquesting.importers.ftbq.FTBEntry;
import betterquesting.importers.ftbq.FTBQUtils;
import betterquesting.importers.ftbq.SNBTReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.math.MathHelper;
import org.apache.commons.lang3.tuple.Pair;

public class FTBQQuestImporter
implements IImporter {
    public static final FTBQQuestImporter INSTANCE;
    private static final FileFilter FILTER;
    private static final HashMap<String, Function<NBTTagCompound, ITask[]>> taskConverters;
    private static final HashMap<String, Function<NBTTagCompound, IReward[]>> rewardConverters;
    private final HashMap<String, FTBEntry> ID_MAP = new HashMap();
    private static IQuest iconQuest;
    private static IQuestLine iconChapter;

    @Override
    public String getUnlocalisedName() {
        return "bq_standard.importer.ftbq_quest.name";
    }

    @Override
    public String getUnlocalisedDescription() {
        return "bq_standard.importer.ftbq_quest.desc";
    }

    @Override
    public FileFilter getFileFilter() {
        return FILTER;
    }

    @Override
    public void loadFiles(IQuestDatabase questDB, IQuestLineDatabase lineDB, File[] files) {
        for (File f : files) {
            if (f == null || f.getParent() == null) continue;
            NBTTagCompound indexNBT = FTBQQuestImporter.readFile(f);
            this.startImport(questDB, lineDB, indexNBT, f.getParentFile(), f.getName().toLowerCase().endsWith(".snbt"));
        }
    }

    @Nullable
    private static NBTTagCompound readFile(File file) {
        NBTTagCompound nBTTagCompound;
        if (file.getName().toLowerCase().endsWith(".snbt")) {
            return SNBTReader.read(file);
        }
        FileInputStream chFis = new FileInputStream(file);
        try {
            nBTTagCompound = CompressedStreamTools.func_74796_a((InputStream)chFis);
        }
        catch (Throwable throwable) {
            try {
                try {
                    chFis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                BetterQuesting.logger.error("Failed to import file entry: " + file, (Throwable)e);
                return null;
            }
        }
        chFis.close();
        return nBTTagCompound;
    }

    private void startImport(IQuestDatabase questDB, IQuestLineDatabase lineDB, NBTTagCompound tagIndex, File folder, boolean isSnbt) {
        int i;
        String[] indexIDs;
        if (isSnbt) {
            NBTTagList tagList = tagIndex.func_150295_c("index", 8);
            indexIDs = new String[tagList.func_74745_c()];
            i = 0;
            for (NBTBase index : tagList) {
                indexIDs[i] = ((NBTTagString)index).func_150285_a_();
                ++i;
            }
        } else {
            int[] indices = tagIndex.func_74759_k("index");
            indexIDs = new String[indices.length];
            for (i = 0; i < indices.length; ++i) {
                indexIDs[i] = String.format("%1$08x", indices[i]);
            }
        }
        this.ID_MAP.clear();
        FTBQQuestImporter.requestQuestIcon(null);
        FTBQQuestImporter.requestChapterIcon(null);
        HashMap<IQuest, Pair> parentMap = new HashMap<IQuest, Pair>();
        BetterQuesting.logger.info("Found " + indexIDs.length + " quest chapter(s) to import");
        for (String string : indexIDs) {
            File[] contents;
            File qlFolder = new File(folder, string);
            if (!qlFolder.exists() || !qlFolder.isDirectory() || (contents = qlFolder.listFiles()) == null) continue;
            int lineID = lineDB.nextID();
            IQuestLine questLine = lineDB.createNew(lineID);
            this.ID_MAP.put(string, new FTBEntry(lineID, questLine, FTBEntry.FTBEntryType.LINE));
            FTBQQuestImporter.requestChapterIcon(questLine);
            for (File questFile : contents) {
                int questID;
                NBTTagCompound qTag;
                if (!questFile.getName().toLowerCase().endsWith(".nbt") && !questFile.getName().toLowerCase().endsWith(".snbt") || (qTag = FTBQQuestImporter.readFile(questFile)) == null) continue;
                if (questFile.getName().equalsIgnoreCase("chapter.nbt") || questFile.getName().equalsIgnoreCase("chapter.snbt")) {
                    questLine.setProperty(NativeProps.NAME, qTag.func_74779_i("title"));
                    NBTTagList desc = qTag.func_150295_c("description", 8);
                    StringBuilder sb = new StringBuilder();
                    for (int i2 = 0; i2 < desc.func_74745_c(); ++i2) {
                        sb.append(desc.func_150307_f(i2));
                        if (i2 + 1 >= desc.func_74745_c()) continue;
                        sb.append("\n");
                    }
                    questLine.setProperty(NativeProps.DESC, sb.toString());
                    if (!qTag.func_74764_b("icon")) continue;
                    BigItemStack icoStack = FTBQUtils.convertItem(qTag.func_74781_a("icon"));
                    if (!icoStack.getBaseStack().func_190926_b()) {
                        questLine.setProperty(NativeProps.ICON, icoStack);
                    }
                    FTBQQuestImporter.requestChapterIcon(null);
                    continue;
                }
                FTBQQuestImporter.requestQuestIcon(null);
                String hexID = questFile.getName().substring(0, questFile.getName().length() - (isSnbt ? ".snbt".length() : ".nbt".length()));
                try {
                    questID = Integer.parseInt(hexID, 16) & Integer.MAX_VALUE;
                    if (lineDB.getValue(questID) != null) {
                        questID = questDB.nextID();
                    }
                }
                catch (Exception e) {
                    questID = questDB.nextID();
                }
                IQuest quest = questDB.createNew(questID);
                IQuestLineEntry qle = questLine.createNew(questID);
                this.ID_MAP.put(hexID, new FTBEntry(questID, quest, FTBEntry.FTBEntryType.QUEST));
                if (qTag.func_150297_b("title", 8)) {
                    quest.setProperty(NativeProps.NAME, qTag.func_74779_i("title"));
                } else {
                    NBTTagCompound compoundTag;
                    quest.setProperty(NativeProps.NAME, hexID);
                    NBTTagList taskList = qTag.func_150295_c("tasks", 10);
                    if (taskList.func_74745_c() >= 1 && (compoundTag = taskList.func_150305_b(0)).func_74764_b("title")) {
                        quest.setProperty(NativeProps.NAME, compoundTag.func_74779_i("title"));
                    }
                }
                NBTTagList desc = qTag.func_150295_c("text", 8);
                StringBuilder sb = new StringBuilder();
                for (int i3 = 0; i3 < desc.func_74745_c(); ++i3) {
                    sb.append(desc.func_150307_f(i3));
                    if (i3 + 1 >= desc.func_74745_c()) continue;
                    sb.append("\n");
                }
                quest.setProperty(NativeProps.DESC, sb.toString());
                quest.setProperty(NativeProps.VISIBILITY, EnumQuestVisibility.ALWAYS);
                if (qTag.func_74764_b("icon")) {
                    BigItemStack icoStack = FTBQUtils.convertItem(qTag.func_74781_a("icon"));
                    if (!icoStack.getBaseStack().func_190926_b()) {
                        quest.setProperty(NativeProps.ICON, icoStack);
                    }
                    FTBQQuestImporter.requestQuestIcon(null);
                } else {
                    BigItemStack iconStack;
                    NBTTagCompound compoundTag;
                    FTBQQuestImporter.requestQuestIcon(quest);
                    NBTTagList taskList = qTag.func_150295_c("tasks", 10);
                    if (taskList.func_74745_c() >= 1 && (compoundTag = taskList.func_150305_b(0)).func_74764_b("icon") && !(iconStack = FTBQUtils.convertItem(compoundTag.func_74781_a("icon"))).getBaseStack().func_190926_b()) {
                        quest.setProperty(NativeProps.ICON, iconStack);
                        FTBQQuestImporter.requestQuestIcon(null);
                    }
                }
                double iconSize = 24.0;
                double gridSize = 32.0;
                double size = qTag.func_74764_b("size") ? qTag.func_74769_h("size") : 1.0;
                qle.setSize(MathHelper.func_76143_f((double)(size *= iconSize)), MathHelper.func_76143_f((double)size));
                qle.setPosition(MathHelper.func_76143_f((double)(qTag.func_74769_h("x") * gridSize - gridSize / 2.0)), MathHelper.func_76143_f((double)(qTag.func_74769_h("y") * gridSize - gridSize / 2.0)));
                String[] depKeys = null;
                if (isSnbt) {
                    if (qTag.func_150297_b("dependencies", 9)) {
                        NBTTagList tagList = qTag.func_150295_c("dependencies", 8);
                        depKeys = new String[tagList.func_74745_c()];
                        for (int i4 = 0; i4 < tagList.func_74745_c(); ++i4) {
                            depKeys[i4] = tagList.func_150307_f(i4);
                        }
                    }
                } else {
                    int[] depend = null;
                    if (qTag.func_150297_b("dependencies", 11)) {
                        depend = qTag.func_74759_k("dependencies");
                    }
                    if (qTag.func_150297_b("dependency", 3)) {
                        depend = new int[]{qTag.func_74762_e("dependency")};
                    }
                    if (depend != null && depend.length > 0) {
                        depKeys = new String[depend.length];
                        for (int d = 0; d < depend.length; ++d) {
                            depKeys[d] = String.format("%1$08x", depend[d]);
                        }
                    }
                }
                if (depKeys != null) {
                    boolean hideDependencies = false;
                    if (qTag.func_74764_b("hide_dependency_lines") && qTag.func_74767_n("hide_dependency_lines")) {
                        hideDependencies = true;
                    }
                    if (qTag.func_74764_b("dependency_requirement")) {
                        switch (qTag.func_74779_i("dependency_requirement")) {
                            case "all_completed": {
                                quest.setProperty(NativeProps.LOGIC_QUEST, EnumLogic.AND);
                                break;
                            }
                            case "one_completed": {
                                quest.setProperty(NativeProps.LOGIC_QUEST, EnumLogic.OR);
                                break;
                            }
                            case "all_started": {
                                quest.setProperty(NativeProps.LOGIC_QUEST, EnumLogic.AND);
                                break;
                            }
                            case "one_started": {
                                quest.setProperty(NativeProps.LOGIC_QUEST, EnumLogic.OR);
                            }
                        }
                    }
                    parentMap.put(quest, Pair.of((Object)depKeys, (Object)hideDependencies));
                }
                NBTTagList taskList = qTag.func_150295_c("tasks", 10);
                for (int i5 = 0; i5 < taskList.func_74745_c(); ++i5) {
                    NBTTagCompound taskTag = taskList.func_150305_b(i5);
                    String tType = taskTag.func_74779_i("type");
                    if (!taskConverters.containsKey(tType)) {
                        BetterQuesting.logger.warn("Unsupported FTBQ task \"" + tType + "\"! Skipping...");
                        continue;
                    }
                    ITask[] tsks = taskConverters.get(tType).apply(taskTag);
                    if (tsks == null || tsks.length <= 0) continue;
                    IDatabaseNBT<ITask, NBTTagList, NBTTagList> taskReg = quest.getTasks();
                    for (ITask t : tsks) {
                        taskReg.add(taskReg.nextID(), t);
                    }
                }
                if (quest.getProperty(NativeProps.NAME).equals(hexID)) {
                    quest.getTasks().getEntries().stream().findFirst().flatMap(entry -> Optional.ofNullable(((ITask)entry.getValue()).getTextForSearch())).flatMap(list -> list.stream().findFirst()).ifPresent(text -> quest.setProperty(NativeProps.NAME, text));
                }
                NBTTagList rewardList = qTag.func_150295_c("rewards", 10);
                for (int i6 = 0; i6 < rewardList.func_74745_c(); ++i6) {
                    NBTTagCompound rewTag = rewardList.func_150305_b(i6);
                    String rType = rewTag.func_74779_i("type");
                    if (!rewardConverters.containsKey(rType)) {
                        BetterQuesting.logger.warn("Unsupported FTBQ reward \"" + rType + "\"! Skipping...");
                        continue;
                    }
                    IReward[] tsks = rewardConverters.get(rType).apply(rewTag);
                    if (tsks == null || tsks.length <= 0) continue;
                    IDatabaseNBT<IReward, NBTTagList, NBTTagList> rewardReg = quest.getRewards();
                    for (IReward t : tsks) {
                        rewardReg.add(rewardReg.nextID(), t);
                    }
                }
                if (qTag.func_74764_b("or_tasks") && qTag.func_74767_n("or_tasks")) {
                    quest.setProperty(NativeProps.LOGIC_TASK, EnumLogic.OR);
                }
                if (iconQuest == null) continue;
                iconQuest.setProperty(NativeProps.ICON, new BigItemStack(Items.field_151156_bN));
                iconQuest = null;
            }
            if (iconChapter == null) continue;
            iconChapter.setProperty(NativeProps.ICON, new BigItemStack(ItemStack.field_190927_a));
            iconChapter = null;
        }
        for (Map.Entry entry2 : parentMap.entrySet()) {
            ArrayList<Integer> qIDs = new ArrayList<Integer>();
            for (String key : (String[])((Pair)entry2.getValue()).getLeft()) {
                FTBEntry type = this.ID_MAP.get(key);
                if (type == null) {
                    BetterQuesting.logger.warn("Unable to find quest dependency '" + key + "'");
                    continue;
                }
                if (type.type == FTBEntry.FTBEntryType.VAR) continue;
                if (type.type == FTBEntry.FTBEntryType.QUEST) {
                    qIDs.add(questDB.getID((IQuest)type.obj));
                    continue;
                }
                if (type.type != FTBEntry.FTBEntryType.LINE) continue;
                for (DBEntry dBEntry : ((IQuestLine)type.obj).getEntries()) {
                    qIDs.add(dBEntry.getID());
                }
            }
            int[] nArray = new int[qIDs.size()];
            for (int i7 = 0; i7 < qIDs.size(); ++i7) {
                nArray[i7] = (Integer)qIDs.get(i7);
            }
            ((IQuest)entry2.getKey()).setRequirements(nArray);
            if (!((Boolean)((Pair)entry2.getValue()).getRight()).booleanValue()) continue;
            for (int req : nArray) {
                ((IQuest)entry2.getKey()).setRequirementType(req, IQuest.RequirementType.IMPLICIT);
            }
        }
    }

    private static void requestQuestIcon(IQuest quest) {
        iconQuest = quest;
    }

    private static void requestChapterIcon(IQuestLine chapter) {
        iconChapter = chapter;
    }

    public static void provideQuestIcon(BigItemStack stack) {
        if (stack == null) {
            return;
        }
        if (iconQuest != null) {
            iconQuest.setProperty(NativeProps.ICON, stack);
            iconQuest = null;
        }
        if (iconChapter != null) {
            iconChapter.setProperty(NativeProps.ICON, stack);
            iconChapter = null;
        }
    }

    public static void provideChapterIcon(BigItemStack stack) {
        if (iconChapter != null && stack != null) {
            iconChapter.setProperty(NativeProps.ICON, stack);
            iconChapter = null;
        }
    }

    /*
     * Exception decompiling
     */
    static {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.rewriteExpressions(StructuredExpressionStatement.java:70)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

