/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.importers;

import betterquesting.api.client.importers.IImporter;
import betterquesting.api.enums.EnumQuestVisibility;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.IQuestDatabase;
import betterquesting.api.questing.IQuestLine;
import betterquesting.api.questing.IQuestLineDatabase;
import betterquesting.api.questing.IQuestLineEntry;
import betterquesting.api.questing.rewards.IReward;
import betterquesting.api.utils.BigItemStack;
import betterquesting.api.utils.FileExtensionFilter;
import betterquesting.api.utils.JsonHelper;
import betterquesting.api2.storage.DBEntry;
import betterquesting.core.BetterQuesting;
import betterquesting.questing.rewards.RewardCommand;
import betterquesting.questing.rewards.RewardItem;
import betterquesting.questing.rewards.RewardRecipe;
import betterquesting.questing.rewards.RewardXP;
import betterquesting.questing.tasks.TaskTrigger;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.io.FileFilter;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.FrameType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.io.FilenameUtils;

public class AdvImporter
implements IImporter {
    public static final AdvImporter INSTANCE = new AdvImporter();
    private static final FileFilter FILTER = new FileExtensionFilter(".json");
    private final TreeMap<ResourceLocation, DBEntry<IQuest>> ID_MAP = new TreeMap((o1, o2) -> o2.toString().compareToIgnoreCase(o1.toString()));
    private final HashMap<ResourceLocation, List<IQuest>> PENDING_CHILDREN = new HashMap();
    private final List<List<AdvTreeNode>> NODES_BY_DEPTH = new ArrayList<List<AdvTreeNode>>();

    @Override
    public String getUnlocalisedName() {
        return "bq_standard.importer.adv_json.name";
    }

    @Override
    public String getUnlocalisedDescription() {
        return "bq_standard.importer.adv_json.desc";
    }

    @Override
    public FileFilter getFileFilter() {
        return FILTER;
    }

    @Override
    public void loadFiles(IQuestDatabase questDB, IQuestLineDatabase lineDB, File[] files) {
        this.ID_MAP.clear();
        this.PENDING_CHILDREN.clear();
        if (files.length == 1 && !files[0].isDirectory() && files[0].getName().equalsIgnoreCase("bq_adv_manifest.json")) {
            System.out.println("Importing manifest file...");
            JsonObject manifest = JsonHelper.ReadFromFile(files[0]);
            for (Map.Entry entry : manifest.entrySet()) {
                File folder;
                if (!(entry.getValue() instanceof JsonPrimitive) || !((JsonPrimitive)entry.getValue()).isString() || !(folder = new File(files[0].getParentFile(), ((JsonElement)entry.getValue()).getAsString())).exists() || !folder.isDirectory()) continue;
                try {
                    Iterator iterator = Files.walk(folder.toPath(), FileVisitOption.FOLLOW_LINKS).iterator();
                    while (iterator.hasNext()) {
                        Path path = (Path)iterator.next();
                        if (!"json".equals(FilenameUtils.getExtension((String)path.toString()))) continue;
                        String relPath = folder.toPath().relativize(path).toString();
                        ResourceLocation advID = new ResourceLocation((String)entry.getKey(), FilenameUtils.removeExtension((String)relPath).replaceAll("\\\\", "/"));
                        this.loadAdvancemenet(advID, JsonHelper.ReadFromFile(path.toFile()), questDB);
                    }
                }
                catch (Exception iterator) {
                }
            }
        } else {
            for (File selected : files) {
                JsonObject json;
                if (selected == null || !selected.exists() || (json = JsonHelper.ReadFromFile(selected)).size() <= 0) continue;
                this.loadAdvancemenet(this.guessID(selected), json, questDB);
            }
        }
        for (DBEntry dBEntry : this.ID_MAP.values()) {
            if (((IQuest)dBEntry.getValue()).getRequirements().length > 0 || ((IQuest)dBEntry.getValue()).getProperty(NativeProps.VISIBILITY) == EnumQuestVisibility.HIDDEN) continue;
            this.generateLayout(dBEntry, lineDB);
        }
    }

    private ResourceLocation guessID(File file) {
        File lastDir = file;
        for (File parent = file.getParentFile(); parent != null; parent = parent.getParentFile()) {
            if (parent.getName().equalsIgnoreCase("advancements") || parent.getName().equalsIgnoreCase("json") && parent.getParentFile() != null && parent.getParentFile().getName().equalsIgnoreCase("triumph")) {
                String relPath = lastDir.toPath().relativize(file.toPath()).toString();
                return new ResourceLocation(lastDir.getName(), FilenameUtils.removeExtension((String)relPath).replaceAll("\\\\", "/"));
            }
            lastDir = parent;
        }
        return new ResourceLocation("minecraft", FilenameUtils.removeExtension((String)file.getName()));
    }

    private void registerQuest(ResourceLocation id, DBEntry<IQuest> entry) {
        this.ID_MAP.put(id, entry);
        if (this.PENDING_CHILDREN.containsKey(id)) {
            for (IQuest q : this.PENDING_CHILDREN.get(id)) {
                this.addReq(q, entry.getID());
            }
        }
    }

    private void loadAdvancemenet(ResourceLocation idName, JsonObject json, IQuestDatabase questDB) {
        int QID = questDB.nextID();
        IQuest quest = questDB.createNew(QID);
        this.registerQuest(idName, new DBEntry<IQuest>(QID, quest));
        if (json.has("display")) {
            this.readDisplayInfo(JsonHelper.GetObject(json, "display"), quest);
        } else {
            quest.setProperty(NativeProps.NAME, idName.toString());
            quest.setProperty(NativeProps.VISIBILITY, EnumQuestVisibility.HIDDEN);
        }
        quest.setProperty(NativeProps.AUTO_CLAIM, true);
        quest.setProperty(NativeProps.LOCKED_PROGRESS, true);
        if (json.has("parent")) {
            ResourceLocation parentID = new ResourceLocation(JsonHelper.GetString(json, "parent", ""));
            if (this.ID_MAP.containsKey(parentID)) {
                this.addReq(quest, this.ID_MAP.get(parentID).getID());
            } else {
                List pending = this.PENDING_CHILDREN.computeIfAbsent(parentID, k -> new ArrayList());
                pending.add(quest);
            }
        }
        if (json.get("criteria") instanceof JsonObject) {
            JsonObject critObj = json.getAsJsonObject("criteria");
            for (Map.Entry entry : critObj.entrySet()) {
                JsonObject taskObj = JsonHelper.GetObject(critObj, (String)entry.getKey());
                TaskTrigger task = new TaskTrigger();
                task.setTriggerID(JsonHelper.GetString(taskObj, "trigger", "minecraft:impossible"));
                task.setCriteriaJson(JsonHelper.GetObject(taskObj, "conditions").toString());
                task.desc = (String)entry.getKey();
                quest.getTasks().add(quest.getTasks().nextID(), task);
            }
        }
        if (json.has("rewards")) {
            IReward reward;
            JsonObject rewObj = JsonHelper.GetObject(json, "rewards");
            if (rewObj.has("loot")) {
                reward = new RewardItem();
                reward.items.clear();
                JsonArray ary = JsonHelper.GetArray(rewObj, "loot");
                for (int i = 0; i < ary.size(); ++i) {
                    BigItemStack item = new BigItemStack(BetterQuesting.lootChest, 1, 103);
                    NBTTagCompound tag = new NBTTagCompound();
                    tag.func_74778_a("loottable", ary.get(i).getAsString());
                    item.SetTagCompound(tag);
                    reward.items.add(item);
                }
                quest.getRewards().add(quest.getRewards().nextID(), reward);
            }
            if (rewObj.has("recipes")) {
                reward = new RewardRecipe();
                StringBuilder sb = new StringBuilder();
                JsonArray ary = JsonHelper.GetArray(rewObj, "recipes");
                for (int i = 0; i < ary.size(); ++i) {
                    if (i != 0) {
                        sb.append("\n");
                    }
                    sb.append(ary.get(i).getAsString());
                }
                ((RewardRecipe)reward).recipeNames = sb.toString();
                quest.getRewards().add(quest.getRewards().nextID(), reward);
            }
            if (rewObj.has("experience")) {
                reward = new RewardXP();
                ((RewardXP)reward).levels = false;
                ((RewardXP)reward).amount = JsonHelper.GetNumber(rewObj, "experience", 0).intValue();
                quest.getRewards().add(quest.getRewards().nextID(), reward);
            }
            if (rewObj.has("function")) {
                reward = new RewardCommand();
                ((RewardCommand)reward).viaPlayer = true;
                ((RewardCommand)reward).command = "function " + JsonHelper.GetString(rewObj, "function", "minecraft:function");
                quest.getRewards().add(quest.getRewards().nextID(), reward);
            }
        }
    }

    private void readDisplayInfo(JsonObject json, IQuest quest) {
        ITextComponent title;
        if (json.has("title") && (title = ITextComponent.Serializer.func_186877_b((String)json.get("title").toString())) != null) {
            quest.setProperty(NativeProps.NAME, title.func_150254_d());
        }
        if (json.has("description") && (title = ITextComponent.Serializer.func_186877_b((String)json.get("description").toString())) != null) {
            quest.setProperty(NativeProps.DESC, title.func_150254_d());
        }
        quest.setProperty(NativeProps.ICON, new BigItemStack(this.readIcon(JsonHelper.GetObject(json, "icon"))));
        quest.setProperty(NativeProps.SILENT, !JsonHelper.GetBoolean(json, "show_toast", true));
        if (JsonHelper.GetBoolean(json, "hidden", false)) {
            quest.setProperty(NativeProps.VISIBILITY, EnumQuestVisibility.COMPLETED);
        }
        FrameType frametype = json.has("frame") ? FrameType.func_192308_a((String)JsonUtils.func_151200_h((JsonObject)json, (String)"frame")) : FrameType.TASK;
    }

    private ItemStack readIcon(JsonObject json) {
        if (!json.has("item")) {
            return ItemStack.field_190927_a;
        }
        try {
            Item item = JsonUtils.func_188180_i((JsonObject)json, (String)"item");
            int i = JsonUtils.func_151208_a((JsonObject)json, (String)"data", (int)0);
            ItemStack ret = new ItemStack(item, 1, i);
            ret.func_77982_d(net.minecraftforge.common.util.JsonUtils.readNBT((JsonObject)json, (String)"nbt"));
            return ret;
        }
        catch (Exception ignored) {
            return ItemStack.field_190927_a;
        }
    }

    private void addReq(IQuest quest, int id) {
        if (this.containsReq(quest, id)) {
            return;
        }
        int[] orig = quest.getRequirements();
        int[] added = Arrays.copyOf(orig, orig.length + 1);
        added[orig.length] = id;
        quest.setRequirements(added);
    }

    private boolean containsReq(IQuest quest, int id) {
        for (int reqID : quest.getRequirements()) {
            if (id != reqID) continue;
            return true;
        }
        return false;
    }

    private void generateLayout(DBEntry<IQuest> root, IQuestLineDatabase lineDB) {
        boolean changed;
        int d;
        this.NODES_BY_DEPTH.clear();
        Stack<AdvTreeNode> stack = new Stack<AdvTreeNode>();
        stack.push(new AdvTreeNode(root.getID()));
        while (stack.size() > 0) {
            AdvTreeNode node = (AdvTreeNode)stack.pop();
            this.addNodeToDepthMap(node);
            this.findChildren(node);
            for (int i = node.getChildren().size() - 1; i >= 0; --i) {
                stack.push((AdvTreeNode)node.getChildren().get(i));
            }
        }
        for (d = this.NODES_BY_DEPTH.size() - 1; d >= 1; --d) {
            changed = false;
            for (AdvTreeNode node : this.NODES_BY_DEPTH.get(d)) {
                Stack<AdvTreeNode> childStack = new Stack<AdvTreeNode>();
                childStack.push(node);
                while (childStack.size() > 0) {
                    AdvTreeNode child = (AdvTreeNode)childStack.pop();
                    int prev = child.offY;
                    int cPosYBase = Math.max(0, child.getParent().getChildren().size() - 1) * 16;
                    int cPosY = child.getParent().getChildren().size() <= 1 ? 0 : child.getParent().getChildren().indexOf(child) * 32 - cPosYBase;
                    int pOff = child.getParent().getPosY() - (child.getPosY() - child.offY);
                    child.offY = pOff + cPosY;
                    if (child.aboveNode != null) {
                        child.offY = Math.max(0, child.offY);
                    }
                    if (!(changed = changed || prev != child.offY) || child.getChildren().size() <= 0) continue;
                    for (int i = child.getChildren().size() - 1; i >= 0; --i) {
                        childStack.push((AdvTreeNode)child.getChildren().get(i));
                    }
                }
            }
        }
        for (d = 0; d < this.NODES_BY_DEPTH.size(); ++d) {
            changed = false;
            for (AdvTreeNode node : this.NODES_BY_DEPTH.get(d)) {
                if (node.getChildren().size() <= 0) continue;
                int prev = node.offY;
                int cPosY = ((AdvTreeNode)node.getChildren().get(node.getChildren().size() - 1)).getPosY() + 24 - ((AdvTreeNode)node.getChildren().get(0)).getPosY();
                cPosY = cPosY / 2 - 12;
                int pOff = ((AdvTreeNode)node.getChildren().get(0)).getPosY() - (node.getPosY() - node.offY);
                int nPos = pOff + cPosY;
                node.offY = nPos;
                if (node.aboveNode != null) {
                    node.offY = Math.max(0, node.offY);
                    if (nPos < 0) {
                        int dShift = node.depth + 1;
                        int iShift = this.NODES_BY_DEPTH.get(dShift).indexOf(node.getChildren().get(0));
                        block8: for (int ds = dShift; ds < this.NODES_BY_DEPTH.size(); ++ds) {
                            Iterator<AdvTreeNode> iterator = this.NODES_BY_DEPTH.get(ds).iterator();
                            while (iterator.hasNext()) {
                                AdvTreeNode nShift;
                                AdvTreeNode tmp = nShift = iterator.next();
                                while (tmp.depth > dShift) {
                                    tmp = tmp.getParent();
                                }
                                if (this.NODES_BY_DEPTH.get(dShift).indexOf(tmp) < iShift) continue;
                                nShift.offY -= nPos;
                                continue block8;
                            }
                        }
                    }
                }
                changed = changed || prev != node.offY;
            }
            if (!changed || d <= 0) continue;
            d -= 2;
        }
        IQuestLine line = lineDB.createNew(lineDB.nextID());
        line.setProperty(NativeProps.NAME, root.getValue().getProperty(NativeProps.NAME));
        line.setProperty(NativeProps.DESC, root.getValue().getProperty(NativeProps.DESC));
        line.setProperty(NativeProps.VISIBILITY, EnumQuestVisibility.UNLOCKED);
        line.setProperty(NativeProps.ICON, root.getValue().getProperty(NativeProps.ICON));
        for (List<AdvTreeNode> depthList : this.NODES_BY_DEPTH) {
            for (AdvTreeNode node : depthList) {
                IQuestLineEntry qle = line.createNew(node.getQuestID());
                qle.setPosition(node.getPosX(), node.getPosY());
                qle.setSize(24, 24);
            }
        }
    }

    private void addNodeToDepthMap(AdvTreeNode node) {
        while (node.depth >= this.NODES_BY_DEPTH.size()) {
            this.NODES_BY_DEPTH.add(new ArrayList());
        }
        List<AdvTreeNode> list = this.NODES_BY_DEPTH.get(node.depth);
        if (list.size() > 0) {
            node.setAboveNode(list.get(list.size() - 1));
        }
        list.add(node);
    }

    private void findChildren(AdvTreeNode parent) {
        for (DBEntry<IQuest> entry : this.ID_MAP.values()) {
            if (entry.getValue().getProperty(NativeProps.VISIBILITY) == EnumQuestVisibility.HIDDEN) continue;
            for (int req : entry.getValue().getRequirements()) {
                if (req != parent.getQuestID()) continue;
                AdvTreeNode child = new AdvTreeNode(entry.getID());
                parent.addChild(child);
            }
        }
    }

    private static class AdvTreeNode {
        private AdvTreeNode aboveNode;
        private int depth = 0;
        private int offY = 0;
        private AdvTreeNode parent;
        private final List<AdvTreeNode> children = new ArrayList<AdvTreeNode>();
        private final int questID;

        private AdvTreeNode(int questID) {
            this.questID = questID;
        }

        private int getDepth() {
            return this.depth;
        }

        private int getPosX() {
            return this.getDepth() * 32;
        }

        private int getPosY() {
            return this.offY + (this.aboveNode == null ? 0 : this.aboveNode.getPosY() + 32);
        }

        private AdvTreeNode getParent() {
            return this.parent;
        }

        private List<AdvTreeNode> getChildren() {
            return Collections.unmodifiableList(this.children);
        }

        private int getQuestID() {
            return this.questID;
        }

        private void addChild(@Nonnull AdvTreeNode node) {
            if (this.children.contains(node)) {
                return;
            }
            this.children.add(node);
            node.parent = this;
            node.depth = this.depth + 1;
        }

        private void setAboveNode(@Nullable AdvTreeNode node) {
            this.aboveNode = node;
        }
    }
}

