/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.toolbox.tools;

import betterquesting.api.client.toolbox.IToolboxTool;
import betterquesting.api.questing.IQuestLine;
import betterquesting.api.questing.IQuestLineEntry;
import betterquesting.api2.client.gui.controls.PanelButtonQuest;
import betterquesting.api2.client.gui.panels.lists.CanvasQuestLine;
import betterquesting.api2.storage.DBEntry;
import betterquesting.client.gui2.editors.designer.PanelToolController;
import betterquesting.client.toolbox.ToolboxTabMain;
import betterquesting.network.handlers.NetChapterEdit;
import betterquesting.questing.QuestLineDatabase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;

public class ToolboxToolGrab
implements IToolboxTool {
    private CanvasQuestLine gui;
    private final NonNullList<GrabEntry> grabList = NonNullList.func_191196_a();

    @Override
    public void initTool(CanvasQuestLine gui) {
        this.gui = gui;
        this.grabList.clear();
    }

    @Override
    public void disableTool() {
        for (GrabEntry grab : this.grabList) {
            IQuestLineEntry qle = (IQuestLineEntry)this.gui.getQuestLine().getValue(((DBEntry)grab.btn.getStoredValue()).getID());
            if (qle == null) continue;
            ((GrabEntry)grab).btn.rect.x = qle.getPosX();
            ((GrabEntry)grab).btn.rect.y = qle.getPosY();
        }
        this.grabList.clear();
    }

    @Override
    public void refresh(CanvasQuestLine gui) {
        if (this.grabList.size() <= 0) {
            return;
        }
        ArrayList<GrabEntry> tmp = new ArrayList<GrabEntry>();
        block0: for (GrabEntry grab : this.grabList) {
            for (PanelButtonQuest btn : PanelToolController.selected) {
                if (((DBEntry)btn.getStoredValue()).getID() != ((DBEntry)grab.btn.getStoredValue()).getID()) continue;
                tmp.add(new GrabEntry(btn, grab.offX, grab.offY));
                continue block0;
            }
        }
        this.grabList.clear();
        this.grabList.addAll(tmp);
    }

    @Override
    public void drawCanvas(int mx, int my, float partialTick) {
        if (this.grabList.size() <= 0) {
            return;
        }
        int snap = Math.max(1, ToolboxTabMain.INSTANCE.getSnapValue());
        int dx = mx;
        int dy = my;
        dx = (dx % snap + snap) % snap;
        dy = (dy % snap + snap) % snap;
        dx = mx - dx;
        dy = my - dy;
        for (GrabEntry grab : this.grabList) {
            ((GrabEntry)grab).btn.rect.x = dx + grab.offX;
            ((GrabEntry)grab).btn.rect.y = dy + grab.offY;
        }
    }

    @Override
    public void drawOverlay(int mx, int my, float partialTick) {
        ToolboxTabMain.INSTANCE.drawGrid(this.gui);
    }

    @Override
    public List<String> getTooltip(int mx, int my) {
        if (this.grabList.size() <= 0) {
            return null;
        }
        for (GrabEntry grab : this.grabList) {
            if (grab.offX != 0 || grab.offY != 0) continue;
            ArrayList<String> list = new ArrayList<String>();
            list.add("X: " + ((GrabEntry)grab).btn.rect.x);
            list.add("Y: " + ((GrabEntry)grab).btn.rect.y);
            return list;
        }
        return Collections.emptyList();
    }

    @Override
    public void onSelection(NonNullList<PanelButtonQuest> buttons) {
    }

    @Override
    public boolean onMouseClick(int mx, int my, int click) {
        if (click == 1 && this.grabList.size() > 0) {
            for (GrabEntry grab : this.grabList) {
                IQuestLineEntry qle = (IQuestLineEntry)this.gui.getQuestLine().getValue(((DBEntry)grab.btn.getStoredValue()).getID());
                if (qle == null) continue;
                ((GrabEntry)grab).btn.rect.x = qle.getPosX();
                ((GrabEntry)grab).btn.rect.y = qle.getPosY();
            }
            this.grabList.clear();
            return true;
        }
        if (click != 0 || !this.gui.getTransform().contains(mx, my)) {
            return false;
        }
        if (this.grabList.size() > 0) {
            IQuestLine qLine = this.gui.getQuestLine();
            int lID = QuestLineDatabase.INSTANCE.getID(qLine);
            for (GrabEntry grab : this.grabList) {
                IQuestLineEntry qle = (IQuestLineEntry)this.gui.getQuestLine().getValue(((DBEntry)grab.btn.getStoredValue()).getID());
                if (qle == null) continue;
                qle.setPosition(((GrabEntry)grab).btn.rect.x, ((GrabEntry)grab).btn.rect.y);
            }
            NBTTagCompound chPayload = new NBTTagCompound();
            NBTTagList cdList = new NBTTagList();
            NBTTagCompound tagEntry = new NBTTagCompound();
            tagEntry.func_74768_a("chapterID", lID);
            tagEntry.func_74782_a("config", (NBTBase)qLine.writeToNBT(new NBTTagCompound(), null, true));
            cdList.func_74742_a((NBTBase)tagEntry);
            chPayload.func_74782_a("data", (NBTBase)cdList);
            chPayload.func_74768_a("action", 0);
            NetChapterEdit.sendEdit(chPayload);
            this.grabList.clear();
            return true;
        }
        PanelButtonQuest btnClicked = this.gui.getButtonAt(mx, my);
        if (btnClicked != null) {
            if (PanelToolController.selected.size() > 0) {
                if (!PanelToolController.selected.contains((Object)btnClicked)) {
                    return false;
                }
                for (PanelButtonQuest btn : PanelToolController.selected) {
                    this.grabList.add((Object)new GrabEntry(btn, btn.rect.x - btnClicked.rect.x, btn.rect.y - btnClicked.rect.y));
                }
            } else {
                this.grabList.add((Object)new GrabEntry(btnClicked, 0, 0));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean onMouseRelease(int mx, int my, int click) {
        return false;
    }

    @Override
    public boolean onMouseScroll(int mx, int my, int scroll) {
        return false;
    }

    @Override
    public boolean onKeyPressed(char c, int keyCode) {
        return this.grabList.size() > 0;
    }

    @Override
    public boolean clampScrolling() {
        return this.grabList.size() <= 0;
    }

    @Override
    public boolean useSelection() {
        return this.grabList.size() <= 0;
    }

    private class GrabEntry {
        private final PanelButtonQuest btn;
        private final int offX;
        private final int offY;

        private GrabEntry(PanelButtonQuest btn, int offX, int offY) {
            this.btn = btn;
            this.offX = offX;
            this.offY = offY;
        }
    }
}

