/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api2.storage;

import betterquesting.api2.storage.AbstractDatabase;
import betterquesting.api2.storage.ArrayCacheLookupLogic;
import betterquesting.api2.storage.EmptyLookupLogic;
import betterquesting.api2.storage.LookupLogic;
import betterquesting.api2.storage.NaiveLookupLogic;
import betterquesting.api2.storage.SimpleDatabase;
import java.util.function.Function;
import java.util.function.Predicate;

enum LookupLogicType {
    Empty(db -> db.mapDB.isEmpty(), EmptyLookupLogic::new),
    ArrayCache(db -> db.mapDB.size() < SimpleDatabase.CACHE_MAX_SIZE && (double)db.mapDB.size() > SimpleDatabase.SPARSE_RATIO * (double)(db.mapDB.lastKey() - db.mapDB.firstKey()), ArrayCacheLookupLogic::new),
    Naive(db -> true, NaiveLookupLogic::new);

    private final Predicate<AbstractDatabase<?>> shouldUse;
    private final Function<AbstractDatabase<?>, LookupLogic<?>> factory;

    private LookupLogicType(Predicate<AbstractDatabase<?>> shouldUse, Function<AbstractDatabase<?>, LookupLogic<?>> factory) {
        this.shouldUse = shouldUse;
        this.factory = factory;
    }

    static LookupLogicType determine(AbstractDatabase<?> db) {
        for (LookupLogicType type : LookupLogicType.values()) {
            if (!type.shouldUse.test(db)) continue;
            return type;
        }
        return Naive;
    }

    <T> LookupLogic<T> get(AbstractDatabase<T> db) {
        return this.factory.apply(db);
    }
}

