/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api2.storage;

import betterquesting.api2.storage.AbstractDatabase;
import betterquesting.api2.storage.DBEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

abstract class LookupLogic<T> {
    protected final AbstractDatabase<T> abstractDatabase;
    protected List<DBEntry<T>> refCache = null;

    public LookupLogic(AbstractDatabase<T> abstractDatabase) {
        this.abstractDatabase = abstractDatabase;
    }

    public void onDataChange() {
        this.refCache = null;
    }

    public List<DBEntry<T>> getRefCache() {
        if (this.refCache != null) {
            return this.refCache;
        }
        this.computeRefCache();
        return this.refCache;
    }

    public abstract List<DBEntry<T>> bulkLookup(int[] var1);

    protected void computeRefCache() {
        ArrayList temp = new ArrayList();
        for (Map.Entry entry : this.abstractDatabase.mapDB.entrySet()) {
            temp.add(new DBEntry(entry.getKey(), entry.getValue()));
        }
        this.refCache = Collections.unmodifiableList(temp);
    }
}

