/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api2.storage;

import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.storage.IDatabase;
import betterquesting.api2.storage.LookupLogic;
import betterquesting.api2.storage.LookupLogicType;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;

public abstract class AbstractDatabase<T>
implements IDatabase<T> {
    public static int CACHE_MAX_SIZE = 0x300000;
    public static double SPARSE_RATIO = 0.15;
    final TreeMap<Integer, T> mapDB = new TreeMap();
    private LookupLogicType type = null;
    private LookupLogic<T> logic = null;

    private LookupLogic<T> getLookupLogic() {
        LookupLogicType newType;
        if (this.type != null) {
            return this.logic;
        }
        this.type = newType = LookupLogicType.determine(this);
        this.logic = newType.get(this);
        return this.logic;
    }

    private void updateLookupLogic() {
        if (this.type == null) {
            return;
        }
        LookupLogicType newType = LookupLogicType.determine(this);
        if (newType != this.type) {
            this.type = null;
            this.logic = null;
        } else {
            this.logic.onDataChange();
        }
    }

    @Override
    public synchronized DBEntry<T> add(int id, T value) {
        if (value == null) {
            throw new NullPointerException("Value cannot be null");
        }
        if (id < 0) {
            throw new IllegalArgumentException("ID cannot be negative");
        }
        if (this.mapDB.putIfAbsent(id, value) == null) {
            this.updateLookupLogic();
            return new DBEntry<T>(id, value);
        }
        throw new IllegalArgumentException("ID or value is already contained within database");
    }

    @Override
    public synchronized boolean removeID(int key) {
        if (key < 0) {
            return false;
        }
        if (this.mapDB.remove(key) != null) {
            this.updateLookupLogic();
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean removeValue(T value) {
        return value != null && this.removeID(this.getID(value));
    }

    @Override
    public synchronized int getID(T value) {
        if (value == null) {
            return -1;
        }
        for (DBEntry<T> entry : this.getEntries()) {
            if (entry.getValue() != value) continue;
            return entry.getID();
        }
        return -1;
    }

    @Override
    public synchronized T getValue(int id) {
        if (id < 0 || this.mapDB.size() <= 0) {
            return null;
        }
        return this.mapDB.get(id);
    }

    @Override
    public synchronized int size() {
        return this.mapDB.size();
    }

    @Override
    public synchronized void reset() {
        this.mapDB.clear();
        this.type = null;
        this.logic = null;
    }

    @Override
    public synchronized List<DBEntry<T>> getEntries() {
        return this.mapDB.isEmpty() ? Collections.emptyList() : this.getLookupLogic().getRefCache();
    }

    @Override
    public synchronized List<DBEntry<T>> bulkLookup(int ... keys) {
        return this.mapDB.isEmpty() || keys.length == 0 ? Collections.emptyList() : this.getLookupLogic().bulkLookup(keys);
    }
}

