/*
 * Decompiled with CFR 0.152.
 */
package betterquesting;

import betterquesting.ScoreBQ;
import betterquesting.api2.storage.INBTPartial;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class ScoreboardBQ
implements INBTPartial<NBTTagList, UUID> {
    public static final ScoreboardBQ INSTANCE = new ScoreboardBQ();
    private final TreeMap<String, ScoreBQ> objectives = new TreeMap();

    public synchronized int getScore(@Nonnull UUID uuid, @Nonnull String scoreName) {
        ScoreBQ score = this.objectives.get(scoreName);
        return score == null ? 0 : score.getScore(uuid);
    }

    public synchronized void setScore(@Nonnull UUID uuid, @Nonnull String scoreName, int value) {
        ScoreBQ score = this.objectives.computeIfAbsent(scoreName, key -> new ScoreBQ());
        score.setScore(uuid, value);
    }

    @Override
    public synchronized void readFromNBT(NBTTagList nbt, boolean merge) {
        if (!merge) {
            this.objectives.clear();
        }
        for (int i = 0; i < nbt.func_74745_c(); ++i) {
            NBTTagCompound jObj = nbt.func_150305_b(i);
            ScoreBQ score = this.objectives.computeIfAbsent(jObj.func_74779_i("name"), key -> new ScoreBQ());
            score.readFromNBT(jObj.func_150295_c("scores", 10), merge);
        }
    }

    @Override
    @Deprecated
    public synchronized NBTTagList writeToNBT(NBTTagList nbt, @Nullable List<UUID> users) {
        return this.writeToNBT(nbt, users, false);
    }

    @Override
    public synchronized NBTTagList writeToNBT(NBTTagList nbt, @Nullable List<UUID> users, boolean reduce) {
        for (Map.Entry<String, ScoreBQ> entry : this.objectives.entrySet()) {
            NBTTagCompound jObj = new NBTTagCompound();
            jObj.func_74778_a("name", entry.getKey());
            jObj.func_74782_a("scores", (NBTBase)entry.getValue().writeToNBT(new NBTTagList(), users, reduce));
            nbt.func_74742_a((NBTBase)jObj);
        }
        return nbt;
    }
}

