/*
 * Decompiled with CFR 0.152.
 */
package betterquesting;

import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;

public class NBTUtil {
    public static <T extends NBTBase> T replaceStrings(T baseTag, String key, String replace) {
        if (baseTag == null) {
            return null;
        }
        if (baseTag instanceof NBTTagCompound) {
            NBTTagCompound compound = (NBTTagCompound)baseTag;
            for (String k : compound.func_150296_c()) {
                compound.func_74782_a(k, NBTUtil.replaceStrings(compound.func_74781_a(k), key, replace));
            }
        } else if (baseTag instanceof NBTTagList) {
            NBTTagList list = (NBTTagList)baseTag;
            for (int i = 0; i < list.func_74745_c(); ++i) {
                list.func_150304_a(i, NBTUtil.replaceStrings(list.func_179238_g(i), key, replace));
            }
        } else if (baseTag instanceof NBTTagString) {
            NBTTagString tString = (NBTTagString)baseTag;
            return (T)new NBTTagString(tString.func_150285_a_().replaceAll(key, replace));
        }
        return baseTag;
    }

    public static void setTag(NBTTagCompound tag, String key, NBTBase value, boolean reduce) {
        if (reduce && value.func_82582_d()) {
            return;
        }
        tag.func_74782_a(key, value);
    }

    public static boolean getBoolean(NBTTagCompound tag, String key, boolean defaultValue) {
        return tag.func_150297_b(key, 99) ? tag.func_74767_n(key) : defaultValue;
    }

    public static void setBoolean(NBTTagCompound tag, String key, boolean value, boolean defaultValue, boolean reduce) {
        if (reduce && value == defaultValue) {
            return;
        }
        tag.func_74757_a(key, value);
    }

    public static int getInteger(NBTTagCompound tag, String key, int defaultValue) {
        return tag.func_150297_b(key, 99) ? tag.func_74762_e(key) : defaultValue;
    }

    public static void setInteger(NBTTagCompound tag, String key, int value, int defaultValue, boolean reduce) {
        if (reduce && value == defaultValue) {
            return;
        }
        tag.func_74768_a(key, value);
    }

    public static float getFloat(NBTTagCompound tag, String key, float defaultValue) {
        return tag.func_150297_b(key, 99) ? tag.func_74760_g(key) : defaultValue;
    }

    public static void setFloat(NBTTagCompound tag, String key, float value, float defaultValue, boolean reduce) {
        if (reduce && value == defaultValue) {
            return;
        }
        tag.func_74776_a(key, value);
    }

    public static String getString(NBTTagCompound tag, String key, String defaultValue) {
        return tag.func_150297_b(key, 8) ? tag.func_74779_i(key) : defaultValue;
    }

    public static void setString(NBTTagCompound tag, String key, String value, String defaultValue, boolean reduce) {
        if (reduce && value.equals(defaultValue)) {
            return;
        }
        tag.func_74778_a(key, value);
    }

    public static <E extends Enum<E>> E getEnum(NBTTagCompound tag, String key, Class<E> enumClass, boolean ignoreCases, @Nullable E defaultValue) {
        if (tag.func_150297_b(key, 8)) {
            String valueStr = tag.func_74779_i(key);
            for (Enum value : (Enum[])enumClass.getEnumConstants()) {
                boolean equals;
                boolean bl = equals = ignoreCases ? value.name().equalsIgnoreCase(valueStr) : value.name().equals(valueStr);
                if (!equals) continue;
                return (E)value;
            }
        }
        return defaultValue;
    }
}

