/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.util;

import appeng.api.AEApi;
import appeng.api.features.ILocatable;
import appeng.api.features.IWirelessTermHandler;
import appeng.api.features.IWirelessTermRegistry;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.channels.IFluidStorageChannel;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.core.localization.PlayerMessages;
import appeng.fluids.util.AEFluidInventory;
import appeng.fluids.util.AEFluidStack;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import com.glodblock.github.common.item.ItemFluidPacket;
import com.glodblock.github.common.item.ItemGasPacket;
import com.glodblock.github.common.item.fake.FakeFluids;
import com.glodblock.github.common.item.fake.FakeItemRegister;
import com.glodblock.github.integration.mek.FakeGases;
import com.glodblock.github.inventory.GuiType;
import com.glodblock.github.inventory.InventoryHandler;
import com.glodblock.github.util.ModAndClassUtil;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.EncoderException;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Objects;
import javax.annotation.Nonnull;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTankInfo;
import mekanism.api.gas.IGasHandler;
import mekanism.common.capabilities.Capabilities;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.IItemHandlerModifiable;

public final class Util {
    public static IStorageChannel<IAEFluidStack> getFluidChannel() {
        return AEApi.instance().storage().getStorageChannel(IFluidStorageChannel.class);
    }

    public static IStorageChannel<IAEItemStack> getItemChannel() {
        return AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class);
    }

    public static FluidStack getFluidFromItem(ItemStack stack) {
        if (!stack.func_190926_b() && stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null) && stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null) != null) {
            IFluidTankProperties[] tanks;
            for (IFluidTankProperties tank : tanks = ((IFluidHandlerItem)Objects.requireNonNull(stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null))).getTankProperties()) {
                if (tank == null || tank.getContents() == null) continue;
                return tank.getContents().copy();
            }
        }
        return null;
    }

    public static Object getGasFromItem(ItemStack stack) {
        if (!stack.func_190926_b() && stack.hasCapability(Capabilities.GAS_HANDLER_CAPABILITY, null) && stack.getCapability(Capabilities.GAS_HANDLER_CAPABILITY, null) != null) {
            GasTankInfo[] tanks;
            for (GasTankInfo tank : tanks = ((IGasHandler)Objects.requireNonNull(stack.getCapability(Capabilities.GAS_HANDLER_CAPABILITY, null))).getTankInfo()) {
                if (tank == null || tank.getGas() == null || tank.getGas().amount <= 0) continue;
                return tank.getGas().copy();
            }
        }
        return null;
    }

    public static ItemStack getEmptiedContainer(ItemStack stack) {
        ItemStack dummy;
        IFluidHandlerItem fh;
        if (!stack.func_190926_b() && stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null) && (fh = (IFluidHandlerItem)(dummy = stack.func_77946_l()).getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) != null) {
            fh.drain(Integer.MAX_VALUE, true);
            return fh.getContainer();
        }
        return stack;
    }

    public static void writeFluidInventoryToBuffer(@Nonnull AEFluidInventory inv, ByteBuf data) throws IOException {
        int i;
        int fluidMask = 0;
        for (i = 0; i < inv.getSlots(); ++i) {
            if (inv.getFluidInSlot(i) == null) continue;
            fluidMask |= 1 << i;
        }
        data.writeByte(fluidMask);
        for (i = 0; i < inv.getSlots(); ++i) {
            IAEFluidStack fluid = inv.getFluidInSlot(i);
            if (fluid == null) continue;
            fluid.writeToPacket(data);
        }
    }

    public static boolean readFluidInventoryToBuffer(@Nonnull AEFluidInventory inv, ByteBuf data) throws IOException {
        boolean changed = false;
        byte fluidMask = data.readByte();
        for (int i = 0; i < inv.getSlots(); ++i) {
            if ((fluidMask & 1 << i) != 0) {
                IAEFluidStack origFluid;
                IAEFluidStack fluid = AEFluidStack.fromPacket((ByteBuf)data);
                if (fluid == null || fluid.equals(origFluid = inv.getFluidInSlot(i)) && fluid.getStackSize() == origFluid.getStackSize()) continue;
                inv.setFluidInSlot(i, fluid);
                changed = true;
                continue;
            }
            if (inv.getFluidInSlot(i) == null) continue;
            inv.setFluidInSlot(i, null);
            changed = true;
        }
        return changed;
    }

    public static void fuzzyTransferItems(int slot, ItemStack[] inputs, ItemStack[] des, IItemList<IAEItemStack> storage) {
        if (slot < des.length && inputs.length > 0) {
            if (storage != null) {
                AEItemStack select = AEItemStack.fromItemStack((ItemStack)inputs[0]);
                for (ItemStack item : inputs) {
                    IAEItemStack result = (IAEItemStack)storage.findPrecise((IAEStack)AEItemStack.fromItemStack((ItemStack)item));
                    if (result == null) continue;
                    select = AEItemStack.fromItemStack((ItemStack)item);
                    break;
                }
                if (select != null) {
                    des[slot] = select.createItemStack();
                }
            } else {
                des[slot] = inputs[0];
            }
        }
    }

    public static void clearItemInventory(IItemHandlerModifiable inv) {
        for (int i = 0; i < inv.getSlots(); ++i) {
            inv.setStackInSlot(i, ItemStack.field_190927_a);
        }
    }

    public static ItemStack[] compress(ItemStack[] list) {
        LinkedList<ItemStack> comp = new LinkedList<ItemStack>();
        for (ItemStack item : list) {
            ItemStack currentStack;
            if (item == null || (currentStack = item.func_77946_l()).func_190926_b() || currentStack.func_190916_E() == 0) continue;
            boolean find = false;
            for (ItemStack storedStack : comp) {
                boolean areItemStackEqual;
                if (storedStack.func_190926_b() || !(areItemStackEqual = storedStack.func_77969_a(currentStack) && ItemStack.func_77970_a((ItemStack)storedStack, (ItemStack)currentStack)) || storedStack.func_190916_E() + currentStack.func_190916_E() > storedStack.func_77976_d()) continue;
                find = true;
                storedStack.func_190920_e(storedStack.func_190916_E() + currentStack.func_190916_E());
            }
            if (find) continue;
            comp.add(item.func_77946_l());
        }
        return (ItemStack[])comp.stream().filter(Objects::nonNull).toArray(ItemStack[]::new);
    }

    public static int findMax(Collection<Integer> list) {
        int a = Integer.MIN_VALUE;
        for (int x : list) {
            a = Math.max(x, a);
        }
        return a;
    }

    public static void writeNBTToBytes(ByteBuf buf, NBTTagCompound nbt) {
        PacketBuffer pb = new PacketBuffer(buf);
        try {
            pb.func_150786_a(nbt);
        }
        catch (EncoderException encoderException) {
            // empty catch block
        }
    }

    public static NBTTagCompound readNBTFromBytes(ByteBuf from) {
        PacketBuffer pb = new PacketBuffer(from);
        try {
            return pb.func_150793_b();
        }
        catch (IOException e) {
            return new NBTTagCompound();
        }
    }

    public static boolean multiplySlotCheck(Slot[] slots, int multiple) {
        for (Slot slot : slots) {
            long amt;
            if (!(ItemFluidPacket.isFluidPacket(slot.func_75211_c()) && FakeItemRegister.getStack(slot.func_75211_c()) != null ? (amt = (long)Objects.requireNonNull((FluidStack)FakeItemRegister.getStack((ItemStack)slot.func_75211_c())).amount) * (long)multiple > Integer.MAX_VALUE : (ModAndClassUtil.GAS && ItemGasPacket.isGasPacket(slot.func_75211_c()) && FakeItemRegister.getStack(slot.func_75211_c()) != null ? (amt = (long)Objects.requireNonNull((GasStack)FakeItemRegister.getStack((ItemStack)slot.func_75211_c())).amount) * (long)multiple > Integer.MAX_VALUE : !slot.func_75211_c().func_190926_b() && (amt = (long)slot.func_75211_c().func_190916_E()) * (long)multiple > Integer.MAX_VALUE))) continue;
            return false;
        }
        return true;
    }

    public static void multiplySlot(Slot[] slots, int multiple) {
        for (Slot slot : slots) {
            ItemStack packet;
            if (ItemFluidPacket.isFluidPacket(slot.func_75211_c()) && FakeItemRegister.getStack(slot.func_75211_c()) != null) {
                FluidStack fluid = (FluidStack)Objects.requireNonNull(FakeItemRegister.getStack(slot.func_75211_c()));
                fluid.amount *= multiple;
                packet = FakeFluids.packFluid2Packet(fluid);
                slot.func_75215_d(packet);
                continue;
            }
            if (ModAndClassUtil.GAS && ItemGasPacket.isGasPacket(slot.func_75211_c()) && FakeItemRegister.getStack(slot.func_75211_c()) != null) {
                GasStack gas = (GasStack)Objects.requireNonNull(FakeItemRegister.getStack(slot.func_75211_c()));
                gas.amount *= multiple;
                packet = FakeGases.packGas2Packet(gas);
                slot.func_75215_d(packet);
                continue;
            }
            if (slot.func_75211_c().func_190926_b()) continue;
            ItemStack stack = slot.func_75211_c();
            stack.func_190920_e(stack.func_190916_E() * multiple);
        }
    }

    public static boolean divideSlotCheck(Slot[] slots, int divide) {
        for (Slot slot : slots) {
            long amt;
            if (!(ItemFluidPacket.isFluidPacket(slot.func_75211_c()) && FakeItemRegister.getStack(slot.func_75211_c()) != null ? (amt = (long)Objects.requireNonNull((FluidStack)FakeItemRegister.getStack((ItemStack)slot.func_75211_c())).amount) % (long)divide != 0L : (ModAndClassUtil.GAS && ItemGasPacket.isGasPacket(slot.func_75211_c()) && FakeItemRegister.getStack(slot.func_75211_c()) != null ? (amt = (long)Objects.requireNonNull((GasStack)FakeItemRegister.getStack((ItemStack)slot.func_75211_c())).amount) % (long)divide != 0L : !slot.func_75211_c().func_190926_b() && (amt = (long)slot.func_75211_c().func_190916_E()) % (long)divide != 0L))) continue;
            return false;
        }
        return true;
    }

    public static void divideSlot(Slot[] slots, int divide) {
        for (Slot slot : slots) {
            ItemStack packet;
            if (ItemFluidPacket.isFluidPacket(slot.func_75211_c()) && FakeItemRegister.getStack(slot.func_75211_c()) != null) {
                FluidStack fluid = (FluidStack)Objects.requireNonNull(FakeItemRegister.getStack(slot.func_75211_c()));
                fluid.amount /= divide;
                packet = FakeFluids.packFluid2Packet(fluid);
                slot.func_75215_d(packet);
                continue;
            }
            if (ModAndClassUtil.GAS && ItemGasPacket.isGasPacket(slot.func_75211_c()) && FakeItemRegister.getStack(slot.func_75211_c()) != null) {
                GasStack gas = (GasStack)Objects.requireNonNull(FakeItemRegister.getStack(slot.func_75211_c()));
                gas.amount /= divide;
                packet = FakeGases.packGas2Packet(gas);
                slot.func_75215_d(packet);
                continue;
            }
            if (slot.func_75211_c().func_190926_b()) continue;
            ItemStack stack = slot.func_75211_c();
            stack.func_190920_e(stack.func_190916_E() / divide);
        }
    }

    public static boolean increaseSlotCheck(Slot[] slots, int increase) {
        for (Slot slot : slots) {
            long amt;
            if (!(ItemFluidPacket.isFluidPacket(slot.func_75211_c()) && FakeItemRegister.getStack(slot.func_75211_c()) != null ? (amt = (long)Objects.requireNonNull((FluidStack)FakeItemRegister.getStack((ItemStack)slot.func_75211_c())).amount) + (long)increase * 1000L > Integer.MAX_VALUE : (ModAndClassUtil.GAS && ItemGasPacket.isGasPacket(slot.func_75211_c()) && FakeItemRegister.getStack(slot.func_75211_c()) != null ? (amt = (long)Objects.requireNonNull((GasStack)FakeItemRegister.getStack((ItemStack)slot.func_75211_c())).amount) + (long)increase * 1000L > Integer.MAX_VALUE : !slot.func_75211_c().func_190926_b() && (amt = (long)slot.func_75211_c().func_190916_E()) + (long)increase > Integer.MAX_VALUE))) continue;
            return false;
        }
        return true;
    }

    public static void increaseSlot(Slot[] slots, int increase) {
        for (Slot slot : slots) {
            ItemStack packet;
            if (ItemFluidPacket.isFluidPacket(slot.func_75211_c()) && FakeItemRegister.getStack(slot.func_75211_c()) != null) {
                FluidStack fluid = (FluidStack)Objects.requireNonNull(FakeItemRegister.getStack(slot.func_75211_c()));
                fluid.amount += increase * 1000;
                packet = FakeFluids.packFluid2Packet(fluid);
                slot.func_75215_d(packet);
                continue;
            }
            if (ModAndClassUtil.GAS && ItemGasPacket.isGasPacket(slot.func_75211_c()) && FakeItemRegister.getStack(slot.func_75211_c()) != null) {
                GasStack gas = (GasStack)Objects.requireNonNull(FakeItemRegister.getStack(slot.func_75211_c()));
                gas.amount += increase * 1000;
                packet = FakeGases.packGas2Packet(gas);
                slot.func_75215_d(packet);
                continue;
            }
            if (slot.func_75211_c().func_190926_b()) continue;
            ItemStack stack = slot.func_75211_c();
            stack.func_190920_e(stack.func_190916_E() + increase);
        }
    }

    public static boolean decreaseSlotCheck(Slot[] slots, int decrease) {
        for (Slot slot : slots) {
            long amt;
            if (!(ItemFluidPacket.isFluidPacket(slot.func_75211_c()) && FakeItemRegister.getStack(slot.func_75211_c()) != null ? (amt = (long)Objects.requireNonNull((FluidStack)FakeItemRegister.getStack((ItemStack)slot.func_75211_c())).amount) - (long)decrease * 1000L < 1L : (ModAndClassUtil.GAS && ItemGasPacket.isGasPacket(slot.func_75211_c()) && FakeItemRegister.getStack(slot.func_75211_c()) != null ? (amt = (long)Objects.requireNonNull((GasStack)FakeItemRegister.getStack((ItemStack)slot.func_75211_c())).amount) - (long)decrease * 1000L < 1L : !slot.func_75211_c().func_190926_b() && (amt = (long)slot.func_75211_c().func_190916_E()) - (long)decrease < 1L))) continue;
            return false;
        }
        return true;
    }

    public static void decreaseSlot(Slot[] slots, int decrease) {
        for (Slot slot : slots) {
            ItemStack packet;
            if (ItemFluidPacket.isFluidPacket(slot.func_75211_c()) && FakeItemRegister.getStack(slot.func_75211_c()) != null) {
                FluidStack fluid = (FluidStack)Objects.requireNonNull(FakeItemRegister.getStack(slot.func_75211_c()));
                fluid.amount -= decrease * 1000;
                packet = FakeFluids.packFluid2Packet(fluid);
                slot.func_75215_d(packet);
                continue;
            }
            if (ModAndClassUtil.GAS && ItemGasPacket.isGasPacket(slot.func_75211_c()) && FakeItemRegister.getStack(slot.func_75211_c()) != null) {
                GasStack gas = (GasStack)Objects.requireNonNull(FakeItemRegister.getStack(slot.func_75211_c()));
                gas.amount -= decrease * 1000;
                packet = FakeGases.packGas2Packet(gas);
                slot.func_75215_d(packet);
                continue;
            }
            if (slot.func_75211_c().func_190926_b()) continue;
            ItemStack stack = slot.func_75211_c();
            stack.func_190920_e(stack.func_190916_E() - decrease);
        }
    }

    public static void openWirelessTerminal(ItemStack item, int playerInvSlot, boolean isBaubleSlot, World w, EntityPlayer player, GuiType gui) {
        IWirelessTermRegistry registry = AEApi.instance().registries().wireless();
        if (Platform.isClient()) {
            return;
        }
        if (!registry.isWirelessTerminal(item)) {
            player.func_145747_a(PlayerMessages.DeviceNotWirelessTerminal.get());
            return;
        }
        IWirelessTermHandler handler = registry.getWirelessTerminalHandler(item);
        String unparsedKey = handler.getEncryptionKey(item);
        if (unparsedKey.isEmpty()) {
            player.func_145747_a(PlayerMessages.DeviceNotLinked.get());
            return;
        }
        long parsedKey = Long.parseLong(unparsedKey);
        ILocatable securityStation = AEApi.instance().registries().locatable().getLocatableBy(parsedKey);
        if (securityStation == null) {
            player.func_145747_a(PlayerMessages.StationCanNotBeLocated.get());
            return;
        }
        if (handler.hasPower(player, 0.5, item)) {
            InventoryHandler.openGui(player, w, new BlockPos(playerInvSlot, isBaubleSlot ? 1 : 0, Integer.MIN_VALUE), EnumFacing.DOWN, gui);
        } else {
            player.func_145747_a(PlayerMessages.DeviceNotPowered.get());
        }
    }
}

