/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.proxy;

import appeng.api.util.AEColor;
import com.glodblock.github.client.KeyBindings;
import com.glodblock.github.client.model.DenseEncodedPatternModel;
import com.glodblock.github.client.render.DropColourHandler;
import com.glodblock.github.client.render.RenderIngredientBuffer;
import com.glodblock.github.client.render.RenderLargeIngredientBuffer;
import com.glodblock.github.client.warn.WarnMessage;
import com.glodblock.github.common.item.fake.FakeItemRegister;
import com.glodblock.github.common.tile.TileIngredientBuffer;
import com.glodblock.github.common.tile.TileLargeIngredientBuffer;
import com.glodblock.github.handler.ClientRegistryHandler;
import com.glodblock.github.handler.RegistryHandler;
import com.glodblock.github.integration.mek.FCGasItems;
import com.glodblock.github.integration.pauto.PackagedFluidCrafting;
import com.glodblock.github.loader.FCItems;
import com.glodblock.github.proxy.CommonProxy;
import com.glodblock.github.util.ModAndClassUtil;
import mekanism.api.gas.GasStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class ClientProxy
extends CommonProxy {
    private final DropColourHandler dropColourHandler = new DropColourHandler();

    @Override
    public RegistryHandler createRegistryHandler() {
        return new ClientRegistryHandler();
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        MinecraftForge.EVENT_BUS.register((Object)this.dropColourHandler);
        MinecraftForge.EVENT_BUS.register((Object)WarnMessage.INSTANCE);
        ClientRegistry.bindTileEntitySpecialRenderer(TileIngredientBuffer.class, (TileEntitySpecialRenderer)new RenderIngredientBuffer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileLargeIngredientBuffer.class, (TileEntitySpecialRenderer)new RenderLargeIngredientBuffer());
    }

    @Override
    protected void initPackagedAutoIntegration() {
        super.initPackagedAutoIntegration();
        PackagedFluidCrafting.initClient();
    }

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
        Minecraft.func_71410_x().getItemColors().func_186730_a((s, i) -> {
            FluidStack fluid = (FluidStack)FakeItemRegister.getStack(s);
            return fluid != null ? this.dropColourHandler.getColour(fluid) : -1;
        }, new Item[]{FCItems.FLUID_DROP});
        Minecraft.func_71410_x().getItemColors().func_186730_a((s, i) -> {
            if (i == 0) {
                return -1;
            }
            FluidStack fluid = (FluidStack)FakeItemRegister.getStack(s);
            return fluid != null ? fluid.getFluid().getColor(fluid) : -1;
        }, new Item[]{FCItems.FLUID_PACKET});
        if (ModAndClassUtil.GAS) {
            Minecraft.func_71410_x().getItemColors().func_186730_a((s, i) -> {
                GasStack gas = (GasStack)FakeItemRegister.getStack(s);
                return gas != null ? gas.getGas().getTint() | 0xFF000000 : -1;
            }, new Item[]{FCGasItems.GAS_DROP});
            Minecraft.func_71410_x().getItemColors().func_186730_a((s, i) -> {
                if (i == 0) {
                    return -1;
                }
                GasStack gas = (GasStack)FakeItemRegister.getStack(s);
                return gas != null ? gas.getGas().getTint() | 0xFF000000 : -1;
            }, new Item[]{FCGasItems.GAS_PACKET});
        }
        Minecraft.func_71410_x().getItemColors().func_186730_a((s, i) -> AEColor.TRANSPARENT.getVariantByTintIndex(i), new Item[]{FCItems.PART_FLUID_PATTERN_TERMINAL});
        Minecraft.func_71410_x().getItemColors().func_186730_a((s, i) -> AEColor.TRANSPARENT.getVariantByTintIndex(i), new Item[]{FCItems.PART_EXTENDED_FLUID_PATTERN_TERMINAL});
        Minecraft.func_71410_x().getItemColors().func_186730_a(DenseEncodedPatternModel.PATTERN_ITEM_COLOR_HANDLER, new Item[]{FCItems.DENSE_ENCODED_PATTERN});
        Minecraft.func_71410_x().getItemColors().func_186730_a(DenseEncodedPatternModel.PATTERN_ITEM_COLOR_HANDLER, new Item[]{FCItems.DENSE_CRAFT_ENCODED_PATTERN});
        Minecraft.func_71410_x().getItemColors().func_186730_a(DenseEncodedPatternModel.PATTERN_ITEM_COLOR_HANDLER, new Item[]{FCItems.LARGE_ITEM_ENCODED_PATTERN});
        KeyBindings.init();
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        super.postInit(event);
    }
}

