/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.network;

import com.glodblock.github.interfaces.PatternConsumer;
import com.glodblock.github.util.Util;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class CPacketLoadPattern
implements IMessage {
    private List<ItemStack> output;
    private Int2ObjectMap<ItemStack[]> crafting;
    private boolean compress;
    private static final int SLOT_SIZE = 80;

    public CPacketLoadPattern(Int2ObjectMap<ItemStack[]> crafting, List<ItemStack> output, boolean compress) {
        this.crafting = crafting;
        this.output = output;
        this.compress = compress;
    }

    public CPacketLoadPattern() {
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.compress);
        NBTTagCompound msg = new NBTTagCompound();
        IntIterator intIterator = this.crafting.keySet().iterator();
        while (intIterator.hasNext()) {
            int index = (Integer)intIterator.next();
            this.writeItemArray(msg, (ItemStack[])this.crafting.get(index), index + "#");
        }
        this.writeItemArray(msg, this.output.toArray(new ItemStack[0]), "o");
        Util.writeNBTToBytes(buf, msg);
    }

    public void fromBytes(ByteBuf buf) {
        this.crafting = new Int2ObjectArrayMap();
        this.compress = buf.readBoolean();
        NBTTagCompound msg = Util.readNBTFromBytes(buf);
        for (int i = 0; i < 80; ++i) {
            if (!msg.func_74764_b(i + "#")) continue;
            this.crafting.put(i, (Object)this.readItemArray(msg, i + "#"));
        }
        this.output = Arrays.asList(this.readItemArray(msg, "o"));
    }

    private void writeItemArray(NBTTagCompound nbt, ItemStack[] itemList, String key) {
        NBTTagCompound dict = new NBTTagCompound();
        dict.func_74777_a("l", (short)(itemList == null ? 0 : itemList.length));
        if (itemList != null) {
            int cnt = 0;
            for (ItemStack item : itemList) {
                NBTTagCompound itemTag = new NBTTagCompound();
                if (item == null) continue;
                item.func_77955_b(itemTag);
                dict.func_74782_a(cnt + "#", (NBTBase)itemTag);
                ++cnt;
            }
            dict.func_74777_a("l", (short)cnt);
        }
        nbt.func_74782_a(key, (NBTBase)dict);
    }

    private ItemStack[] readItemArray(NBTTagCompound nbt, String key) {
        NBTTagCompound dict = nbt.func_74775_l(key);
        int len = dict.func_74765_d("l");
        if (len == 0) {
            return new ItemStack[0];
        }
        ItemStack[] itemList = new ItemStack[len];
        for (int i = 0; i < len; ++i) {
            itemList[i] = new ItemStack(dict.func_74775_l(i + "#"));
        }
        return itemList;
    }

    public static class Handler
    implements IMessageHandler<CPacketLoadPattern, IMessage> {
        @Nullable
        public IMessage onMessage(CPacketLoadPattern message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            player.func_71121_q().func_152344_a(() -> {
                if (player.field_71070_bA instanceof PatternConsumer) {
                    ((PatternConsumer)player.field_71070_bA).acceptPattern((Int2ObjectMap<ItemStack[]>)message.crafting, message.output, message.compress);
                }
            });
            return null;
        }
    }
}

