/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.inventory;

import appeng.core.AELog;
import com.glodblock.github.FluidCraft;
import com.glodblock.github.inventory.GuiType;
import com.glodblock.github.network.CPacketSwitchGuis;
import java.util.ConcurrentModificationException;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class InventoryHandler
implements IGuiHandler {
    public static void switchGui(GuiType guiType) {
        FluidCraft.proxy.netHandler.sendToServer((IMessage)new CPacketSwitchGuis(guiType));
    }

    public static void openGui(EntityPlayer player, World world, BlockPos pos, EnumFacing face, GuiType guiType) {
        try {
            player.openGui((Object)FluidCraft.INSTANCE, guiType.ordinal() << 3 | face.ordinal(), world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        catch (ConcurrentModificationException e) {
            AELog.warn((String)"catch CME when trying to open %s.", (Object[])new Object[]{guiType});
        }
    }

    @Nullable
    public Object getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        int faceOrd = id & 7;
        if (faceOrd > EnumFacing.field_82609_l.length) {
            return null;
        }
        EnumFacing face = EnumFacing.field_82609_l[faceOrd];
        GuiType type = GuiType.getByOrdinal(id >>> 3);
        return type != null ? type.getFactory().createServerGui(player, world, x, y, z, face) : null;
    }

    @SideOnly(value=Side.CLIENT)
    @Nullable
    public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        int faceOrd = id & 7;
        if (faceOrd > EnumFacing.field_82609_l.length) {
            return null;
        }
        EnumFacing face = EnumFacing.field_82609_l[faceOrd];
        GuiType type = GuiType.getByOrdinal(id >>> 3);
        return type != null ? type.getFactory().createClientGui(player, world, x, y, z, face) : null;
    }
}

