/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.inventory;

import appeng.api.AEApi;
import appeng.api.features.IWirelessTermHandler;
import appeng.api.implementations.guiobjects.IGuiItem;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.storage.ITerminalHost;
import appeng.api.util.AEPartLocation;
import appeng.container.AEBaseContainer;
import appeng.container.ContainerOpenContext;
import appeng.container.implementations.ContainerCraftAmount;
import appeng.container.implementations.ContainerCraftingStatus;
import appeng.container.implementations.ContainerPriority;
import appeng.fluids.helper.IFluidInterfaceHost;
import appeng.helpers.IInterfaceHost;
import appeng.helpers.IPriorityHost;
import appeng.helpers.WirelessTerminalGuiObject;
import baubles.api.BaublesApi;
import com.glodblock.github.client.GuiBurette;
import com.glodblock.github.client.GuiExtendedFluidPatternTerminal;
import com.glodblock.github.client.GuiFCCraftAmount;
import com.glodblock.github.client.GuiFCCraftConfirm;
import com.glodblock.github.client.GuiFCPriority;
import com.glodblock.github.client.GuiFluidAssembler;
import com.glodblock.github.client.GuiFluidDualInterface;
import com.glodblock.github.client.GuiFluidExportBus;
import com.glodblock.github.client.GuiFluidLevelMaintainer;
import com.glodblock.github.client.GuiFluidPacketDecoder;
import com.glodblock.github.client.GuiFluidPatternEncoder;
import com.glodblock.github.client.GuiFluidPatternTerminal;
import com.glodblock.github.client.GuiFluidPatternTerminalCraftingStatus;
import com.glodblock.github.client.GuiIngredientBuffer;
import com.glodblock.github.client.GuiItemAmountChange;
import com.glodblock.github.client.GuiItemDualInterface;
import com.glodblock.github.client.GuiLargeIngredientBuffer;
import com.glodblock.github.client.GuiUltimateEncoder;
import com.glodblock.github.client.GuiWirelessFluidPatternTerminal;
import com.glodblock.github.client.container.ContainerBurette;
import com.glodblock.github.client.container.ContainerExtendedFluidPatternTerminal;
import com.glodblock.github.client.container.ContainerFCCraftConfirm;
import com.glodblock.github.client.container.ContainerFluidAssembler;
import com.glodblock.github.client.container.ContainerFluidDualInterface;
import com.glodblock.github.client.container.ContainerFluidExportBus;
import com.glodblock.github.client.container.ContainerFluidLevelMaintainer;
import com.glodblock.github.client.container.ContainerFluidPacketDecoder;
import com.glodblock.github.client.container.ContainerFluidPatternEncoder;
import com.glodblock.github.client.container.ContainerFluidPatternTerminal;
import com.glodblock.github.client.container.ContainerIngredientBuffer;
import com.glodblock.github.client.container.ContainerItemAmountChange;
import com.glodblock.github.client.container.ContainerItemDualInterface;
import com.glodblock.github.client.container.ContainerLargeIngredientBuffer;
import com.glodblock.github.client.container.ContainerUltimateEncoder;
import com.glodblock.github.client.container.ContainerWirelessFluidPatternTerminal;
import com.glodblock.github.common.part.PartFluidExportBus;
import com.glodblock.github.common.tile.TileBurette;
import com.glodblock.github.common.tile.TileFluidAssembler;
import com.glodblock.github.common.tile.TileFluidLevelMaintainer;
import com.glodblock.github.common.tile.TileFluidPacketDecoder;
import com.glodblock.github.common.tile.TileFluidPatternEncoder;
import com.glodblock.github.common.tile.TileIngredientBuffer;
import com.glodblock.github.common.tile.TileLargeIngredientBuffer;
import com.glodblock.github.common.tile.TileUltimateEncoder;
import com.glodblock.github.integration.mek.MekGuiType;
import com.glodblock.github.interfaces.FCPriorityHost;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public enum GuiType {
    ULTIMATE_ENCODER(new TileGuiFactory<TileUltimateEncoder>(TileUltimateEncoder.class){

        @Override
        protected Object createServerGui(EntityPlayer player, TileUltimateEncoder inv) {
            return new ContainerUltimateEncoder(player.field_71071_by, inv);
        }

        @Override
        protected Object createClientGui(EntityPlayer player, TileUltimateEncoder inv) {
            return new GuiUltimateEncoder(player.field_71071_by, inv);
        }
    }),
    FLUID_ASSEMBLER(new TileGuiFactory<TileFluidAssembler>(TileFluidAssembler.class){

        @Override
        protected Object createServerGui(EntityPlayer player, TileFluidAssembler inv) {
            return new ContainerFluidAssembler(player.field_71071_by, inv);
        }

        @Override
        protected Object createClientGui(EntityPlayer player, TileFluidAssembler inv) {
            return new GuiFluidAssembler(player.field_71071_by, inv);
        }
    }),
    ITEM_AMOUNT_SET(new AllGuiFactory<ITerminalHost>(ITerminalHost.class){

        @Override
        protected Object createServerGui(EntityPlayer player, ITerminalHost inv) {
            return new ContainerItemAmountChange(player.field_71071_by, inv);
        }

        @Override
        protected Object createClientGui(EntityPlayer player, ITerminalHost inv) {
            return new GuiItemAmountChange(player.field_71071_by, inv);
        }
    }),
    FLUID_LEVEL_MAINTAINER(new PartOrTileGuiFactory<TileFluidLevelMaintainer>(TileFluidLevelMaintainer.class){

        @Override
        protected Object createServerGui(EntityPlayer player, TileFluidLevelMaintainer inv) {
            return new ContainerFluidLevelMaintainer(player.field_71071_by, inv);
        }

        @Override
        protected Object createClientGui(EntityPlayer player, TileFluidLevelMaintainer inv) {
            return new GuiFluidLevelMaintainer(player.field_71071_by, inv);
        }
    }),
    FLUID_EXPORT_BUS(new PartOrTileGuiFactory<PartFluidExportBus>(PartFluidExportBus.class){

        @Override
        protected Object createServerGui(EntityPlayer player, PartFluidExportBus inv) {
            return new ContainerFluidExportBus(player.field_71071_by, inv);
        }

        @Override
        protected Object createClientGui(EntityPlayer player, PartFluidExportBus inv) {
            return new GuiFluidExportBus(player.field_71071_by, inv);
        }
    }),
    INGREDIENT_BUFFER(new TileGuiFactory<TileIngredientBuffer>(TileIngredientBuffer.class){

        @Override
        protected Object createServerGui(EntityPlayer player, TileIngredientBuffer inv) {
            return new ContainerIngredientBuffer(player.field_71071_by, inv);
        }

        @Override
        protected Object createClientGui(EntityPlayer player, TileIngredientBuffer inv) {
            return new GuiIngredientBuffer(player.field_71071_by, inv);
        }
    }),
    LARGE_INGREDIENT_BUFFER(new TileGuiFactory<TileLargeIngredientBuffer>(TileLargeIngredientBuffer.class){

        @Override
        protected Object createServerGui(EntityPlayer player, TileLargeIngredientBuffer inv) {
            return new ContainerLargeIngredientBuffer(player.field_71071_by, inv);
        }

        @Override
        protected Object createClientGui(EntityPlayer player, TileLargeIngredientBuffer inv) {
            return new GuiLargeIngredientBuffer(player.field_71071_by, inv);
        }
    }),
    FLUID_PATTERN_ENCODER(new TileGuiFactory<TileFluidPatternEncoder>(TileFluidPatternEncoder.class){

        @Override
        protected Object createServerGui(EntityPlayer player, TileFluidPatternEncoder inv) {
            return new ContainerFluidPatternEncoder(player.field_71071_by, inv);
        }

        @Override
        protected Object createClientGui(EntityPlayer player, TileFluidPatternEncoder inv) {
            return new GuiFluidPatternEncoder(player.field_71071_by, inv);
        }
    }),
    FLUID_PACKET_DECODER(new TileGuiFactory<TileFluidPacketDecoder>(TileFluidPacketDecoder.class){

        @Override
        protected Object createServerGui(EntityPlayer player, TileFluidPacketDecoder inv) {
            return new ContainerFluidPacketDecoder(player.field_71071_by, inv);
        }

        @Override
        protected Object createClientGui(EntityPlayer player, TileFluidPacketDecoder inv) {
            return new GuiFluidPacketDecoder(player.field_71071_by, inv);
        }
    }),
    PRECISION_BURETTE(new TileGuiFactory<TileBurette>(TileBurette.class){

        @Override
        protected Object createServerGui(EntityPlayer player, TileBurette inv) {
            return new ContainerBurette(player.field_71071_by, inv);
        }

        @Override
        protected Object createClientGui(EntityPlayer player, TileBurette inv) {
            return new GuiBurette(player.field_71071_by, inv);
        }
    }),
    DUAL_ITEM_INTERFACE(new PartOrTileGuiFactory<IInterfaceHost>(IInterfaceHost.class){

        @Override
        protected Object createServerGui(EntityPlayer player, IInterfaceHost inv) {
            return new ContainerItemDualInterface(player.field_71071_by, inv);
        }

        @Override
        protected Object createClientGui(EntityPlayer player, IInterfaceHost inv) {
            return new GuiItemDualInterface(player.field_71071_by, inv);
        }
    }),
    DUAL_FLUID_INTERFACE(new PartOrTileGuiFactory<IFluidInterfaceHost>(IFluidInterfaceHost.class){

        @Override
        protected Object createServerGui(EntityPlayer player, IFluidInterfaceHost inv) {
            return new ContainerFluidDualInterface(player.field_71071_by, inv);
        }

        @Override
        protected Object createClientGui(EntityPlayer player, IFluidInterfaceHost inv) {
            return new GuiFluidDualInterface(player.field_71071_by, inv);
        }
    }),
    TRIO_ITEM_INTERFACE(MekGuiType::TRIO_ITEM_GUI),
    TRIO_FLUID_INTERFACE(MekGuiType::TRIO_FLUID_GUI),
    TRIO_GAS_INTERFACE(MekGuiType::TRIO_GAS_GUI),
    FLUID_PAT_TERM_CRAFTING_STATUS(new ItemOrPartGuiFactory<ITerminalHost>(ITerminalHost.class){

        @Override
        protected Object createServerGui(EntityPlayer player, ITerminalHost inv) {
            return new ContainerCraftingStatus(player.field_71071_by, inv);
        }

        @Override
        protected Object createClientGui(EntityPlayer player, ITerminalHost inv) {
            return new GuiFluidPatternTerminalCraftingStatus(player.field_71071_by, inv);
        }
    }),
    FLUID_PATTERN_TERMINAL(new PartGuiFactory<ITerminalHost>(ITerminalHost.class){

        @Override
        protected Object createServerGui(EntityPlayer player, ITerminalHost inv) {
            return new ContainerFluidPatternTerminal(player.field_71071_by, inv);
        }

        @Override
        protected Object createClientGui(EntityPlayer player, ITerminalHost inv) {
            return new GuiFluidPatternTerminal(player.field_71071_by, inv);
        }
    }),
    FLUID_EXTENDED_PATTERN_TERMINAL(new PartGuiFactory<ITerminalHost>(ITerminalHost.class){

        @Override
        protected Object createServerGui(EntityPlayer player, ITerminalHost inv) {
            return new ContainerExtendedFluidPatternTerminal(player.field_71071_by, inv);
        }

        @Override
        protected Object createClientGui(EntityPlayer player, ITerminalHost inv) {
            return new GuiExtendedFluidPatternTerminal(player.field_71071_by, inv);
        }
    }),
    WIRELESS_FLUID_PATTERN_TERMINAL(new ItemGuiFactory<WirelessTerminalGuiObject>(WirelessTerminalGuiObject.class){

        @Override
        protected Object createServerGui(EntityPlayer player, WirelessTerminalGuiObject inv) {
            return new ContainerWirelessFluidPatternTerminal(player.field_71071_by, inv);
        }

        @Override
        protected Object createClientGui(EntityPlayer player, WirelessTerminalGuiObject inv) {
            return new GuiWirelessFluidPatternTerminal(player.field_71071_by, inv);
        }
    }),
    FLUID_CRAFT_AMOUNT(new ItemOrPartGuiFactory<ITerminalHost>(ITerminalHost.class){

        @Override
        protected Object createServerGui(EntityPlayer player, ITerminalHost inv) {
            return new ContainerCraftAmount(player.field_71071_by, inv);
        }

        @Override
        protected Object createClientGui(EntityPlayer player, ITerminalHost inv) {
            return new GuiFCCraftAmount(player.field_71071_by, inv);
        }
    }),
    FLUID_CRAFT_CONFIRM(new ItemOrPartGuiFactory<ITerminalHost>(ITerminalHost.class){

        @Override
        protected Object createServerGui(EntityPlayer player, ITerminalHost inv) {
            return new ContainerFCCraftConfirm(player.field_71071_by, inv);
        }

        @Override
        protected Object createClientGui(EntityPlayer player, ITerminalHost inv) {
            return new GuiFCCraftConfirm(player.field_71071_by, inv);
        }
    }),
    PRIORITY(new PartOrTileGuiFactory<FCPriorityHost>(FCPriorityHost.class){

        @Override
        protected Object createServerGui(EntityPlayer player, FCPriorityHost inv) {
            return new ContainerPriority(player.field_71071_by, (IPriorityHost)inv);
        }

        @Override
        protected Object createClientGui(EntityPlayer player, FCPriorityHost inv) {
            return new GuiFCPriority(player.field_71071_by, inv);
        }
    });

    public static final List<GuiType> VALUES;
    private GuiFactory guiFactory;
    private Supplier<GuiFactory> supplier;

    @Nullable
    public static GuiType getByOrdinal(int ordinal) {
        return ordinal < 0 || ordinal >= VALUES.size() ? null : VALUES.get(ordinal);
    }

    private GuiType(GuiFactory guiFactory) {
        this.guiFactory = guiFactory;
    }

    private GuiType(Supplier<GuiFactory> lazyFactory) {
        this.supplier = lazyFactory;
    }

    public GuiFactory getFactory() {
        if (this.guiFactory == null) {
            this.guiFactory = this.supplier.get();
        }
        return this.guiFactory;
    }

    public static Object getItemGuiObject(ItemStack it, EntityPlayer player, World w, int x, int y, int z) {
        if (!it.func_190926_b()) {
            if (it.func_77973_b() instanceof IGuiItem) {
                return ((IGuiItem)it.func_77973_b()).getGuiObject(it, w, new BlockPos(x, y, z));
            }
            IWirelessTermHandler wh = AEApi.instance().registries().wireless().getWirelessTerminalHandler(it);
            if (wh != null) {
                return new WirelessTerminalGuiObject(wh, it, player, w, x, y, z);
            }
        }
        return null;
    }

    static {
        VALUES = ImmutableList.copyOf((Object[])GuiType.values());
    }

    public static abstract class AllGuiFactory<T>
    extends PartOrTileGuiFactory<T> {
        public AllGuiFactory(Class<T> invClass) {
            super(invClass);
        }

        @Override
        @Nullable
        protected T getInventory(TileEntity tile, EntityPlayer player, EnumFacing face, BlockPos pos) {
            Object holder;
            ItemStack hold = player.func_184586_b(EnumHand.values()[face.ordinal() % 2]);
            if (pos.func_177952_p() == Integer.MIN_VALUE && !hold.func_190926_b() && this.invClass.isInstance(holder = GuiType.getItemGuiObject(hold, player, player.field_70170_p, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()))) {
                return this.invClass.cast(holder);
            }
            return super.getInventory(tile, player, face, pos);
        }
    }

    public static abstract class ItemOrPartGuiFactory<T>
    extends PartGuiFactory<T> {
        public ItemOrPartGuiFactory(Class<T> invClass) {
            super(invClass);
        }

        @Override
        @Nullable
        protected T getInventory(TileEntity tile, EntityPlayer player, EnumFacing face, BlockPos pos) {
            Object holder;
            ItemStack hold = player.func_184586_b(EnumHand.values()[face.ordinal() % 2]);
            if (pos.func_177952_p() == Integer.MIN_VALUE && !hold.func_190926_b() && this.invClass.isInstance(holder = GuiType.getItemGuiObject(hold, player, player.field_70170_p, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()))) {
                return this.invClass.cast(holder);
            }
            return super.getInventory(tile, player, face, pos);
        }
    }

    public static abstract class ItemGuiFactory<T>
    extends TileGuiFactory<T> {
        public ItemGuiFactory(Class<T> invClass) {
            super(invClass);
        }

        @Override
        @Nullable
        protected T getInventory(TileEntity tile, EntityPlayer player, EnumFacing face, BlockPos pos) {
            if (pos.func_177952_p() == Integer.MIN_VALUE) {
                ItemStack terminal = ItemStack.field_190927_a;
                if (pos.func_177956_o() == 0) {
                    terminal = player.field_71071_by.func_70301_a(pos.func_177958_n());
                } else if (pos.func_177956_o() == 1 && Loader.isModLoaded((String)"baubles")) {
                    terminal = ItemGuiFactory.getStackInBaubleSlot(player, pos.func_177958_n());
                }
                if (terminal == null || terminal.func_190926_b()) {
                    return null;
                }
                Object holder = GuiType.getItemGuiObject(terminal, player, player.field_70170_p, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                if (this.invClass.isInstance(holder)) {
                    return this.invClass.cast(holder);
                }
            }
            return null;
        }

        @Optional.Method(modid="baubles")
        private static ItemStack getStackInBaubleSlot(EntityPlayer player, int slot) {
            if (slot >= 0 && slot < BaublesApi.getBaublesHandler((EntityPlayer)player).getSlots()) {
                return BaublesApi.getBaublesHandler((EntityPlayer)player).getStackInSlot(slot);
            }
            return null;
        }
    }

    public static abstract class PartGuiFactory<T>
    extends TileGuiFactory<T> {
        public PartGuiFactory(Class<T> invClass) {
            super(invClass);
        }

        @Override
        @Nullable
        protected T getInventory(TileEntity tile, EntityPlayer player, EnumFacing face, BlockPos pos) {
            IPart part;
            if (pos.func_177952_p() != Integer.MIN_VALUE && tile instanceof IPartHost && this.invClass.isInstance(part = ((IPartHost)tile).getPart(face))) {
                return this.invClass.cast(part);
            }
            return null;
        }
    }

    public static abstract class PartOrTileGuiFactory<T>
    extends TileGuiFactory<T> {
        public PartOrTileGuiFactory(Class<T> invClass) {
            super(invClass);
        }

        @Override
        @Nullable
        protected T getInventory(TileEntity tile, EntityPlayer player, EnumFacing face, BlockPos pos) {
            IPart part;
            if (pos.func_177952_p() != Integer.MIN_VALUE && tile instanceof IPartHost && this.invClass.isInstance(part = ((IPartHost)tile).getPart(face))) {
                return this.invClass.cast(part);
            }
            return super.getInventory(tile, player, face, pos);
        }
    }

    public static abstract class TileGuiFactory<T>
    implements GuiFactory {
        protected final Class<T> invClass;

        public TileGuiFactory(Class<T> invClass) {
            this.invClass = invClass;
        }

        @Nullable
        protected T getInventory(@Nullable TileEntity tile, EntityPlayer player, EnumFacing face, BlockPos pos) {
            return this.invClass.isInstance(tile) ? (T)this.invClass.cast(tile) : null;
        }

        @Override
        @Nullable
        public Object createServerGui(EntityPlayer player, World world, int x, int y, int z, EnumFacing face) {
            TileEntity tile = world.func_175625_s(new BlockPos(x, y, z));
            T inv = this.getInventory(tile, player, face, new BlockPos(x, y, z));
            if (inv == null) {
                return null;
            }
            Object gui = this.createServerGui(player, inv);
            if (gui instanceof AEBaseContainer) {
                ContainerOpenContext ctx = new ContainerOpenContext(inv);
                ctx.setWorld(world);
                ctx.setX(x);
                ctx.setY(y);
                ctx.setZ(z);
                ctx.setSide(AEPartLocation.fromFacing((EnumFacing)face));
                ((AEBaseContainer)gui).setOpenContext(ctx);
            }
            return gui;
        }

        @Nullable
        protected abstract Object createServerGui(EntityPlayer var1, T var2);

        @Override
        @Nullable
        public Object createClientGui(EntityPlayer player, World world, int x, int y, int z, EnumFacing face) {
            TileEntity tile = world.func_175625_s(new BlockPos(x, y, z));
            T inv = this.getInventory(tile, player, face, new BlockPos(x, y, z));
            if (inv == null) {
                return null;
            }
            return this.createClientGui(player, inv);
        }

        @Nullable
        protected abstract Object createClientGui(EntityPlayer var1, T var2);
    }

    public static interface GuiFactory {
        @Nullable
        public Object createServerGui(EntityPlayer var1, World var2, int var3, int var4, int var5, EnumFacing var6);

        @SideOnly(value=Side.CLIENT)
        @Nullable
        public Object createClientGui(EntityPlayer var1, World var2, int var3, int var4, int var5, EnumFacing var6);
    }
}

