/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.inventory;

import appeng.api.AEApi;
import appeng.api.config.FuzzyMode;
import appeng.api.parts.IPart;
import appeng.api.storage.IMEMonitor;
import appeng.fluids.helper.DualityFluidInterface;
import appeng.fluids.helper.IFluidInterfaceHost;
import appeng.helpers.DualityInterface;
import appeng.helpers.IInterfaceHost;
import appeng.me.GridAccessException;
import appeng.me.helpers.AENetworkProxy;
import appeng.tile.misc.TileInterface;
import appeng.tile.networking.TileCableBus;
import appeng.util.InventoryAdaptor;
import appeng.util.inv.AdaptorItemHandler;
import appeng.util.inv.IInventoryDestination;
import appeng.util.inv.ItemSlot;
import com.glodblock.github.common.item.fake.FakeFluids;
import com.glodblock.github.common.item.fake.FakeItemRegister;
import com.glodblock.github.common.tile.TileDualInterface;
import com.glodblock.github.integration.mek.FakeGases;
import com.glodblock.github.util.Ae2Reflect;
import com.glodblock.github.util.ModAndClassUtil;
import com.glodblock.github.util.Util;
import com.mekeng.github.common.me.duality.IGasInterfaceHost;
import com.mekeng.github.common.me.storage.IGasStorageChannel;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTankInfo;
import mekanism.api.gas.IGasHandler;
import mekanism.common.capabilities.Capabilities;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class FluidConvertingInventoryAdaptor
extends InventoryAdaptor {
    @Nullable
    private final InventoryAdaptor invItems;
    @Nullable
    private final IFluidHandler invFluids;
    @Nullable
    private final Object invGases;
    private final ICapabilityProvider facingTE;
    private final boolean onmi;
    private final EnumFacing facing;
    @Nullable
    private final TileEntity posInterface;
    @Nullable
    private final DualityInterface self;

    public static InventoryAdaptor wrap(ICapabilityProvider capProvider, EnumFacing face) {
        TileEntity cap = (TileEntity)capProvider;
        TileEntity inter = cap.func_145831_w().func_175625_s(cap.func_174877_v().func_177971_a(face.func_176730_m()));
        DualityInterface dualInterface = FluidConvertingInventoryAdaptor.getInterfaceTE(inter, face) == null ? null : Objects.requireNonNull(FluidConvertingInventoryAdaptor.getInterfaceTE(inter, face)).getInterfaceDuality();
        boolean onmi = false;
        if (inter instanceof TileInterface) {
            onmi = ((TileInterface)inter).getTargets().size() > 1;
        } else if (inter instanceof TileDualInterface) {
            boolean bl = onmi = ((TileDualInterface)inter).getTargets().size() > 1;
        }
        if (dualInterface == null || !Ae2Reflect.getFluidPacketMode(dualInterface)) {
            return new FluidConvertingInventoryAdaptor(capProvider, inter, onmi, dualInterface, face.func_176734_d());
        }
        return InventoryAdaptor.getAdaptor((TileEntity)cap, (EnumFacing)face);
    }

    public FluidConvertingInventoryAdaptor(ICapabilityProvider facingTE, @Nullable TileEntity pos, boolean isOnmi, @Nullable DualityInterface interSelf, EnumFacing facing) {
        this.invItems = facingTE.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d()) ? new AdaptorItemHandler((IItemHandler)Objects.requireNonNull(facingTE.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d()))) : null;
        this.invFluids = (IFluidHandler)facingTE.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing.func_176734_d());
        this.invGases = ModAndClassUtil.GAS ? facingTE.getCapability(Capabilities.GAS_HANDLER_CAPABILITY, facing.func_176734_d()) : null;
        this.facingTE = facingTE;
        this.posInterface = pos;
        this.onmi = isOnmi;
        this.self = interSelf;
        this.facing = facing;
    }

    public ItemStack addItems(ItemStack toBeAdded) {
        if (FakeFluids.isFluidFakeItem(toBeAdded)) {
            int filled;
            FluidStack fluid;
            if (this.onmi) {
                int filled2;
                FluidStack fluid2 = (FluidStack)FakeItemRegister.getStack(toBeAdded);
                if (this.invFluids != null && fluid2 != null && (filled2 = this.invFluids.fill(fluid2, true)) > 0) {
                    fluid2.amount -= filled2;
                    return FakeFluids.packFluid2Packet(fluid2);
                }
                if (fluid2 != null && this.posInterface != null && Ae2Reflect.getSplittingMode(this.self)) {
                    for (EnumFacing dir : EnumFacing.values()) {
                        int filled3;
                        IFluidHandler fh;
                        IFluidInterfaceHost interFTE;
                        TileEntity te = this.posInterface.func_145831_w().func_175625_s(this.posInterface.func_174877_v().func_177971_a(dir.func_176730_m()));
                        if (te == null || (interFTE = FluidConvertingInventoryAdaptor.getFluidInterfaceTE(te, dir)) != null && this.isSameGrid(interFTE) || (fh = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, dir.func_176734_d())) == null || (filled3 = fh.fill(fluid2, false)) != fluid2.amount) continue;
                        fh.fill(fluid2, true);
                        return ItemStack.field_190927_a;
                    }
                }
                return FakeFluids.packFluid2Packet(fluid2);
            }
            if (this.invFluids != null && (fluid = (FluidStack)FakeItemRegister.getStack(toBeAdded)) != null && (filled = this.invFluids.fill(fluid, true)) > 0) {
                fluid.amount -= filled;
                return FakeFluids.packFluid2Packet(fluid);
            }
            return toBeAdded;
        }
        if (ModAndClassUtil.GAS && FakeGases.isGasFakeItem(toBeAdded)) {
            if (this.onmi) {
                GasStack gas = (GasStack)FakeItemRegister.getStack(toBeAdded);
                if (this.invGases != null && this.posInterface != null) {
                    int filled;
                    EnumFacing[] te = (EnumFacing[])this.facingTE;
                    AENetworkProxy node = FluidConvertingInventoryAdaptor.getGasInterfaceGrid((TileEntity)te, this.facing);
                    IGasHandler gasHandler = (IGasHandler)this.invGases;
                    if (!this.isSameGrid(node) && gas != null && gas.getGas() != null && (filled = gasHandler.receiveGas(this.facing.func_176734_d(), gas, true)) > 0) {
                        gas.amount -= filled;
                        return FakeGases.packGas2Packet(gas);
                    }
                }
                if (gas != null && gas.getGas() != null && this.posInterface != null && Ae2Reflect.getSplittingMode(this.self)) {
                    for (EnumFacing dir : EnumFacing.values()) {
                        int filled;
                        IGasHandler gh;
                        AENetworkProxy node;
                        TileEntity te = this.posInterface.func_145831_w().func_175625_s(this.posInterface.func_174877_v().func_177971_a(dir.func_176730_m()));
                        if (te == null || (node = FluidConvertingInventoryAdaptor.getGasInterfaceGrid(te, dir)) != null && this.isSameGrid(node) || (gh = (IGasHandler)te.getCapability(Capabilities.GAS_HANDLER_CAPABILITY, dir.func_176734_d())) == null || (filled = gh.receiveGas(dir.func_176734_d(), gas, false)) != gas.amount) continue;
                        gh.receiveGas(dir.func_176734_d(), gas, true);
                        return ItemStack.field_190927_a;
                    }
                }
                return FakeGases.packGas2Packet(gas);
            }
            if (this.invGases != null && this.posInterface != null) {
                int filled;
                GasStack gas = (GasStack)FakeItemRegister.getStack(toBeAdded);
                TileEntity te = (TileEntity)this.facingTE;
                AENetworkProxy node = FluidConvertingInventoryAdaptor.getGasInterfaceGrid(te, this.facing);
                IGasHandler gasHandler = (IGasHandler)this.invGases;
                if (!this.isSameGrid(node) && gas != null && gas.getGas() != null && (filled = gasHandler.receiveGas(this.facing.func_176734_d(), gas, true)) > 0) {
                    gas.amount -= filled;
                    return FakeGases.packGas2Packet(gas);
                }
            }
            return toBeAdded;
        }
        return this.invItems != null ? this.invItems.addItems(toBeAdded) : toBeAdded;
    }

    public ItemStack simulateAdd(ItemStack toBeSimulated) {
        if (FakeFluids.isFluidFakeItem(toBeSimulated)) {
            int filled;
            FluidStack fluid;
            if (this.onmi) {
                int filled2;
                boolean sus = false;
                FluidStack fluid2 = (FluidStack)FakeItemRegister.getStack(toBeSimulated);
                if (this.invFluids != null && fluid2 != null && (filled2 = this.invFluids.fill(fluid2, false)) > 0) {
                    fluid2.amount -= filled2;
                    return FakeFluids.packFluid2Packet(fluid2);
                }
                if (fluid2 != null && this.posInterface != null) {
                    if (Ae2Reflect.getSplittingMode(this.self)) {
                        for (EnumFacing dir : EnumFacing.values()) {
                            int filled3;
                            IFluidHandler fh;
                            IFluidInterfaceHost interFTE;
                            IInterfaceHost interTE;
                            TileEntity te = this.posInterface.func_145831_w().func_175625_s(this.posInterface.func_174877_v().func_177971_a(dir.func_176730_m()));
                            if (te == null || (interTE = FluidConvertingInventoryAdaptor.getInterfaceTE(te, dir)) != null && this.isSameGrid(interTE) || (interFTE = FluidConvertingInventoryAdaptor.getFluidInterfaceTE(te, dir)) != null && this.isSameGrid(interFTE) || (fh = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, dir.func_176734_d())) == null || (filled3 = fh.fill(fluid2, false)) != fluid2.amount) continue;
                            sus = true;
                            break;
                        }
                    }
                } else {
                    sus = true;
                }
                return sus ? ItemStack.field_190927_a : toBeSimulated;
            }
            if (this.invFluids != null && (fluid = (FluidStack)FakeItemRegister.getStack(toBeSimulated)) != null && (filled = this.invFluids.fill(fluid, false)) > 0) {
                fluid.amount -= filled;
                return FakeFluids.packFluid2Packet(fluid);
            }
            return toBeSimulated;
        }
        if (ModAndClassUtil.GAS && FakeGases.isGasFakeItem(toBeSimulated)) {
            if (this.onmi) {
                boolean sus = false;
                GasStack gas = (GasStack)FakeItemRegister.getStack(toBeSimulated);
                if (this.invGases != null && this.posInterface != null) {
                    int filled;
                    EnumFacing[] te = (EnumFacing[])this.facingTE;
                    AENetworkProxy node = FluidConvertingInventoryAdaptor.getGasInterfaceGrid((TileEntity)te, this.facing);
                    IGasHandler gasHandler = (IGasHandler)this.invGases;
                    if (!this.isSameGrid(node) && gas != null && gas.getGas() != null && (filled = gasHandler.receiveGas(this.facing.func_176734_d(), gas, false)) > 0) {
                        gas.amount -= filled;
                        return FakeGases.packGas2Packet(gas);
                    }
                }
                if (gas != null && this.posInterface != null) {
                    if (Ae2Reflect.getSplittingMode(this.self)) {
                        for (EnumFacing dir : EnumFacing.values()) {
                            int filled;
                            IGasHandler gh;
                            AENetworkProxy node;
                            IFluidInterfaceHost interFTE;
                            IInterfaceHost interTE;
                            TileEntity te = this.posInterface.func_145831_w().func_175625_s(this.posInterface.func_174877_v().func_177971_a(dir.func_176730_m()));
                            if (te == null || (interTE = FluidConvertingInventoryAdaptor.getInterfaceTE(te, dir)) != null && this.isSameGrid(interTE) || (interFTE = FluidConvertingInventoryAdaptor.getFluidInterfaceTE(te, dir)) != null && this.isSameGrid(interFTE) || this.isSameGrid(node = FluidConvertingInventoryAdaptor.getGasInterfaceGrid(te, dir)) || (gh = (IGasHandler)te.getCapability(Capabilities.GAS_HANDLER_CAPABILITY, dir.func_176734_d())) == null || (filled = gh.receiveGas(dir.func_176734_d(), gas, false)) != gas.amount) continue;
                            sus = true;
                            break;
                        }
                    }
                } else {
                    sus = true;
                }
                return sus ? ItemStack.field_190927_a : toBeSimulated;
            }
            if (this.invGases != null && this.posInterface != null) {
                int filled;
                GasStack gas = (GasStack)FakeItemRegister.getStack(toBeSimulated);
                TileEntity te = (TileEntity)this.facingTE;
                AENetworkProxy node = FluidConvertingInventoryAdaptor.getGasInterfaceGrid(te, this.facing);
                IGasHandler gasHandler = (IGasHandler)this.invGases;
                if (!this.isSameGrid(node) && gas != null && (filled = gasHandler.receiveGas(this.facing.func_176734_d(), gas, false)) > 0) {
                    gas.amount -= filled;
                    return FakeGases.packGas2Packet(gas);
                }
            }
            return toBeSimulated;
        }
        return this.invItems != null ? this.invItems.simulateAdd(toBeSimulated) : toBeSimulated;
    }

    public ItemStack removeItems(int amount, ItemStack filter, IInventoryDestination destination) {
        return this.invItems != null ? this.invItems.removeItems(amount, filter, destination) : ItemStack.field_190927_a;
    }

    public ItemStack simulateRemove(int amount, ItemStack filter, IInventoryDestination destination) {
        return this.invItems != null ? this.invItems.simulateRemove(amount, filter, destination) : ItemStack.field_190927_a;
    }

    public ItemStack removeSimilarItems(int amount, ItemStack filter, FuzzyMode fuzzyMode, IInventoryDestination destination) {
        return this.invItems != null ? this.invItems.removeSimilarItems(amount, filter, fuzzyMode, destination) : ItemStack.field_190927_a;
    }

    public ItemStack simulateSimilarRemove(int amount, ItemStack filter, FuzzyMode fuzzyMode, IInventoryDestination destination) {
        return this.invItems != null ? this.invItems.simulateSimilarRemove(amount, filter, fuzzyMode, destination) : ItemStack.field_190927_a;
    }

    public boolean containsItems() {
        IInterfaceHost itemHost;
        DualityInterface inter;
        if (this.invItems == null && this.invFluids == null && this.invGases == null) {
            return true;
        }
        int blockMode = 0;
        if (this.self != null) {
            blockMode = Ae2Reflect.getExtendedBlockMode(this.self);
        }
        boolean checkFluid = blockMode != 1;
        boolean checkItem = blockMode != 2;
        IFluidInterfaceHost fluidHost = FluidConvertingInventoryAdaptor.getFluidInterfaceTE((TileEntity)this.facingTE, this.facing);
        if (fluidHost != null && !this.isSameGrid(fluidHost) && checkFluid) {
            IFluidTankProperties[] inter2 = fluidHost.getDualityFluidInterface();
            IMEMonitor monitor = inter2.getInventory(Util.getFluidChannel());
            if (monitor != null && !monitor.getStorageList().isEmpty()) {
                return true;
            }
        } else if (this.invFluids != null && checkFluid) {
            for (IFluidTankProperties tank : this.invFluids.getTankProperties()) {
                FluidStack fluid = tank.getContents();
                if (fluid == null || fluid.amount <= 0) continue;
                return true;
            }
        }
        if (ModAndClassUtil.GAS) {
            Object gasHost = FluidConvertingInventoryAdaptor.getGasInterfaceTE((TileEntity)this.facingTE, this.facing);
            if (gasHost != null && !this.isSameGrid(((IGasInterfaceHost)gasHost).getProxy()) && checkFluid) {
                inter = ((IGasInterfaceHost)gasHost).getDualityGasInterface();
                IMEMonitor monitor = inter.getInventory(AEApi.instance().storage().getStorageChannel(IGasStorageChannel.class));
                if (monitor != null && !monitor.getStorageList().isEmpty()) {
                    return true;
                }
            } else if (this.invGases != null && checkFluid) {
                IGasHandler gasHandler = (IGasHandler)this.invGases;
                for (GasTankInfo tank : gasHandler.getTankInfo()) {
                    GasStack gas = tank.getGas();
                    if (gas == null || gas.getGas() == null || gas.amount <= 0) continue;
                    return true;
                }
            }
        }
        if ((itemHost = FluidConvertingInventoryAdaptor.getInterfaceTE((TileEntity)this.facingTE, this.facing)) != null && !this.isSameGrid(itemHost) && checkItem) {
            inter = itemHost.getInterfaceDuality();
            IMEMonitor monitor = inter.getInventory(Util.getItemChannel());
            return monitor != null && !monitor.getStorageList().isEmpty();
        }
        if (this.invItems != null && checkItem) {
            return this.invItems.containsItems();
        }
        return false;
    }

    public boolean hasSlots() {
        return this.invFluids != null && this.invFluids.getTankProperties().length > 0 || this.invItems != null && this.invItems.hasSlots();
    }

    @Nullable
    protected static IInterfaceHost getInterfaceTE(TileEntity te, EnumFacing face) {
        IPart part;
        if (te instanceof IInterfaceHost) {
            return (IInterfaceHost)te;
        }
        if (te instanceof TileCableBus && (part = ((TileCableBus)te).getPart(face.func_176734_d())) instanceof IInterfaceHost) {
            return (IInterfaceHost)part;
        }
        return null;
    }

    @Nullable
    protected static IFluidInterfaceHost getFluidInterfaceTE(TileEntity te, EnumFacing face) {
        IPart part;
        if (te instanceof IFluidInterfaceHost) {
            return (IFluidInterfaceHost)te;
        }
        if (te instanceof TileCableBus && (part = ((TileCableBus)te).getPart(face.func_176734_d())) instanceof IFluidInterfaceHost) {
            return (IFluidInterfaceHost)part;
        }
        return null;
    }

    @Nullable
    protected static Object getGasInterfaceTE(TileEntity te, EnumFacing face) {
        IPart part;
        if (te instanceof IGasInterfaceHost) {
            return te;
        }
        if (te instanceof TileCableBus && (part = ((TileCableBus)te).getPart(face.func_176734_d())) instanceof IGasInterfaceHost) {
            return part;
        }
        return null;
    }

    protected static AENetworkProxy getGasInterfaceGrid(@Nullable TileEntity te, EnumFacing face) {
        IPart part;
        if (te instanceof IGasInterfaceHost) {
            return Ae2Reflect.getGasInterfaceGrid(((IGasInterfaceHost)te).getDualityGasInterface());
        }
        if (te instanceof TileCableBus && (part = ((TileCableBus)te).getPart(face.func_176734_d())) instanceof IGasInterfaceHost) {
            return Ae2Reflect.getGasInterfaceGrid(((IGasInterfaceHost)part).getDualityGasInterface());
        }
        return null;
    }

    private boolean isSameGrid(IInterfaceHost target) {
        if (this.self != null && target != null) {
            DualityInterface other = target.getInterfaceDuality();
            try {
                AENetworkProxy proxy1 = Ae2Reflect.getInterfaceProxy(other);
                AENetworkProxy proxy2 = Ae2Reflect.getInterfaceProxy(this.self);
                if (proxy1.getGrid() == proxy2.getGrid()) {
                    return true;
                }
            }
            catch (GridAccessException e) {
                return false;
            }
        }
        return false;
    }

    private boolean isSameGrid(IFluidInterfaceHost target) {
        if (this.self != null && target != null) {
            DualityFluidInterface other = target.getDualityFluidInterface();
            try {
                AENetworkProxy proxy1 = Ae2Reflect.getInterfaceProxy(other);
                AENetworkProxy proxy2 = Ae2Reflect.getInterfaceProxy(this.self);
                if (proxy1.getGrid() == proxy2.getGrid()) {
                    return true;
                }
            }
            catch (GridAccessException e) {
                return false;
            }
        }
        return false;
    }

    private boolean isSameGrid(AENetworkProxy target) {
        if (this.self != null && target != null) {
            try {
                AENetworkProxy proxy = Ae2Reflect.getInterfaceProxy(this.self);
                if (proxy.getGrid() == target.getGrid()) {
                    return true;
                }
            }
            catch (GridAccessException e) {
                return false;
            }
        }
        return false;
    }

    @Nonnull
    public Iterator<ItemSlot> iterator() {
        return new SlotIterator(this.invFluids != null ? this.invFluids.getTankProperties() : new IFluidTankProperties[]{}, this.invItems != null ? this.invItems.iterator() : Collections.emptyIterator());
    }

    private static class SlotIterator
    implements Iterator<ItemSlot> {
        private final IFluidTankProperties[] tanks;
        private final Iterator<ItemSlot> itemSlots;
        private int nextSlotIndex = 0;

        SlotIterator(IFluidTankProperties[] tanks, Iterator<ItemSlot> itemSlots) {
            this.tanks = tanks;
            this.itemSlots = itemSlots;
        }

        @Override
        public boolean hasNext() {
            return this.nextSlotIndex < this.tanks.length || this.itemSlots.hasNext();
        }

        @Override
        public ItemSlot next() {
            if (this.nextSlotIndex < this.tanks.length) {
                FluidStack fluid = this.tanks[this.nextSlotIndex].getContents();
                ItemSlot slot = new ItemSlot();
                slot.setSlot(this.nextSlotIndex++);
                slot.setItemStack(fluid != null ? FakeFluids.packFluid2Packet(fluid) : ItemStack.field_190927_a);
                Ae2Reflect.setItemSlotExtractable(slot, false);
                return slot;
            }
            ItemSlot slot = this.itemSlots.next();
            slot.setSlot(this.nextSlotIndex++);
            return slot;
        }
    }
}

