/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.inventory;

import appeng.helpers.DualityInterface;
import appeng.helpers.NonBlockingItems;
import appeng.util.inv.BlockingInventoryAdaptor;
import appeng.util.inv.ItemHandlerIterator;
import appeng.util.inv.ItemSlot;
import com.glodblock.github.inventory.FluidConvertingInventoryAdaptor;
import com.glodblock.github.util.Ae2Reflect;
import com.glodblock.github.util.ModAndClassUtil;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Iterator;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.gas.GasTankInfo;
import mekanism.api.gas.IGasHandler;
import mekanism.common.capabilities.Capabilities;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class BlockingFluidInventoryAdaptor
extends BlockingInventoryAdaptor {
    @Nullable
    private final IItemHandler invItems;
    @Nullable
    private final IFluidHandler invFluids;
    @Nullable
    private final Object invGases;
    @Nullable
    private final String domain;
    @Nullable
    private final DualityInterface dualInterface;

    public BlockingFluidInventoryAdaptor(@Nullable IItemHandler invItems, @Nullable IFluidHandler invFluids, @Nullable Object invGases, @Nullable String domain, @Nullable DualityInterface dualInterface) {
        this.invItems = invItems;
        this.invFluids = invFluids;
        this.invGases = invGases;
        this.domain = domain;
        this.dualInterface = dualInterface;
    }

    public static BlockingInventoryAdaptor getAdaptor(TileEntity te, EnumFacing d) {
        IItemHandler itemHandler = null;
        IFluidHandler fluidHandler = null;
        Object gasHandler = null;
        DualityInterface dualInterface = null;
        if (te != null) {
            TileEntity inter = te.func_145831_w().func_175625_s(te.func_174877_v().func_177971_a(d.func_176730_m()));
            dualInterface = FluidConvertingInventoryAdaptor.getInterfaceTE(inter, d) == null ? null : Objects.requireNonNull(FluidConvertingInventoryAdaptor.getInterfaceTE(inter, d)).getInterfaceDuality();
        }
        String domain = null;
        if (te != null && te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, d) && (itemHandler = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, d)) != null) {
            domain = Objects.requireNonNull(te.func_145838_q().getRegistryName()).func_110624_b();
        }
        if (te != null && te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, d) && (fluidHandler = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, d)) != null) {
            domain = Objects.requireNonNull(te.func_145838_q().getRegistryName()).func_110624_b();
        }
        if (ModAndClassUtil.GAS && te != null && te.hasCapability(Capabilities.GAS_HANDLER_CAPABILITY, d) && (gasHandler = te.getCapability(Capabilities.GAS_HANDLER_CAPABILITY, d)) != null) {
            domain = Objects.requireNonNull(te.func_145838_q().getRegistryName()).func_110624_b();
        }
        return new BlockingFluidInventoryAdaptor(itemHandler, fluidHandler, gasHandler, domain, dualInterface);
    }

    public boolean containsBlockingItems() {
        boolean itemPass = true;
        boolean fluidPass = true;
        boolean checkFluid = true;
        boolean checkItem = true;
        if (this.invItems == null && this.invFluids == null && this.invGases == null) {
            return true;
        }
        if (this.dualInterface != null) {
            int mode = Ae2Reflect.getExtendedBlockMode(this.dualInterface);
            checkFluid = mode != 1;
            boolean bl = checkItem = mode != 2;
        }
        if (this.invItems != null && checkItem) {
            int slots = this.invItems.getSlots();
            for (int slot = 0; slot < slots; ++slot) {
                ItemStack is = this.invItems.getStackInSlot(slot);
                if (is.func_190926_b() || !this.isBlockableItem(is)) continue;
                itemPass = false;
                break;
            }
        }
        if (this.invFluids != null && checkFluid) {
            for (IFluidTankProperties tank : this.invFluids.getTankProperties()) {
                if (tank == null || tank.getContents() == null || !tank.canFill() && !tank.canDrain()) continue;
                fluidPass = false;
                break;
            }
        }
        if (this.invGases != null && checkFluid && fluidPass) {
            IGasHandler gasHandler = (IGasHandler)this.invGases;
            for (GasTankInfo tank : gasHandler.getTankInfo()) {
                if (tank == null || tank.getGas() == null) continue;
                fluidPass = false;
                break;
            }
        }
        return !fluidPass || !itemPass;
    }

    @Nonnull
    public Iterator<ItemSlot> iterator() {
        return new ItemHandlerIterator(this.invItems);
    }

    boolean isBlockableItem(ItemStack stack) {
        Object2ObjectOpenHashMap map = (Object2ObjectOpenHashMap)NonBlockingItems.INSTANCE.getMap().get(this.domain);
        if (map.get((Object)stack.func_77973_b()) != null) {
            return !((IntSet)map.get((Object)stack.func_77973_b())).contains(stack.func_77952_i());
        }
        return true;
    }
}

