/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.inventory;

import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEStack;
import appeng.util.inv.IAEAppEngInventory;
import com.glodblock.github.interfaces.AeStackInventory;
import java.util.Arrays;
import java.util.Iterator;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import org.apache.logging.log4j.core.util.ObjectArrayIterator;

public class AeStackInventoryImpl<T extends IAEStack<T>>
implements AeStackInventory<T> {
    private final IStorageChannel<T> channel;
    private final T[] inv;
    @Nullable
    private final IAEAppEngInventory owner;

    public AeStackInventoryImpl(IStorageChannel<T> channel, int slotCount, @Nullable IAEAppEngInventory owner) {
        this.channel = channel;
        this.inv = new IAEStack[slotCount];
        this.owner = owner;
    }

    public AeStackInventoryImpl(IStorageChannel<T> channel, int slotCount) {
        this(channel, slotCount, null);
    }

    @Override
    public int getSlotCount() {
        return this.inv.length;
    }

    @Override
    @Nullable
    public T getStack(int slot) {
        return this.inv[slot];
    }

    @Override
    public void setStack(int slot, @Nullable T stack) {
        this.inv[slot] = stack;
        if (this.owner != null) {
            this.owner.saveChanges();
        }
    }

    @Override
    @Nonnull
    public Iterator<T> iterator() {
        return new ObjectArrayIterator((Object[])this.inv);
    }

    @Override
    public Stream<T> stream() {
        return Arrays.stream(this.inv);
    }

    public void writeToNbt(NBTTagCompound tag) {
        NBTTagList stacksTag = new NBTTagList();
        for (T stack : this.inv) {
            if (stack == null) {
                stacksTag.func_74742_a((NBTBase)new NBTTagCompound());
                continue;
            }
            NBTTagCompound stackTag = new NBTTagCompound();
            stack.writeToNBT(stackTag);
            stacksTag.func_74742_a((NBTBase)stackTag);
        }
        tag.func_74782_a("Contents", (NBTBase)stacksTag);
    }

    public void writeToNbt(NBTTagCompound parentTag, String key) {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeToNbt(tag);
        parentTag.func_74782_a(key, (NBTBase)tag);
    }

    public void readFromNbt(NBTTagCompound tag) {
        NBTTagList stacksTag = tag.func_150295_c("Contents", 10);
        for (int i = 0; i < this.inv.length; ++i) {
            NBTTagCompound stackTag = stacksTag.func_150305_b(i);
            this.inv[i] = stackTag.func_82582_d() ? null : this.channel.createFromNBT(stackTag);
        }
    }

    public void readFromNbt(NBTTagCompound parentTag, String key) {
        this.readFromNbt(parentTag.func_74775_l(key));
    }
}

