/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.integration.opencomputer;

import appeng.api.util.AEPartLocation;
import com.glodblock.github.common.tile.TileDualInterface;
import com.glodblock.github.loader.FCBlocks;
import li.cil.oc.api.driver.EnvironmentProvider;
import li.cil.oc.api.driver.NamedBlock;
import li.cil.oc.api.internal.Database;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Component;
import li.cil.oc.api.network.ManagedEnvironment;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.prefab.DriverSidedTileEntity;
import li.cil.oc.integration.ManagedTileEntityEnvironment;
import li.cil.oc.integration.appeng.NetworkControl;
import li.cil.oc.util.ExtendedArguments;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;

public class DriverBlockDualInterface
extends DriverSidedTileEntity {
    public Class<?> getTileEntityClass() {
        return TileDualInterface.class;
    }

    public ManagedEnvironment createEnvironment(World world, BlockPos blockPos, EnumFacing enumFacing) {
        return new Environment((TileDualInterface)world.func_175625_s(blockPos));
    }

    public static class Provider
    implements EnvironmentProvider {
        public Class<?> getEnvironment(ItemStack stack) {
            if (stack.func_77969_a(new ItemStack((Block)FCBlocks.DUAL_INTERFACE))) {
                return Environment.class;
            }
            return null;
        }
    }

    public static class Environment
    extends ManagedTileEntityEnvironment<TileDualInterface>
    implements NamedBlock,
    NetworkControl<TileDualInterface> {
        static final String name = "me_dual_interface";

        public Environment(TileDualInterface tile) {
            super((Object)tile, name);
        }

        @Callback(doc="function([slot:number]):table -- Get the configuration of the dual interface.")
        public Object[] getInterfaceConfiguration(Context context, Arguments args) {
            ExtendedArguments.ExtendedArguments exArg = ExtendedArguments.extendedArguments((Arguments)args);
            IItemHandler config = ((TileDualInterface)this.tileEntity).getInventoryByName("config");
            int slot = exArg.optSlot(config, 0, 0);
            ItemStack stack = config.getStackInSlot(slot);
            return new Object[]{stack};
        }

        @Callback(doc="function([slot:number][, database:address, entry:number[, size:number]]):boolean -- Configure the dual interface.")
        public Object[] setInterfaceConfiguration(Context context, Arguments args) {
            ExtendedArguments.ExtendedArguments exArg = ExtendedArguments.extendedArguments((Arguments)args);
            IItemHandler config = ((TileDualInterface)this.tileEntity).getInventoryByName("config");
            int slot = args.isString(0) ? 0 : exArg.optSlot(config, 0, 0);
            ItemStack stack = ItemStack.field_190927_a;
            if (args.count() > 1) {
                int offset = args.isString(0) ? 0 : 1;
                String address = args.checkString(offset);
                int entry = args.checkInteger(1 + offset);
                int size = args.optInteger(2 + offset, 1);
                Node n = this.node().network().node(address);
                if (!(n instanceof Component)) {
                    throw new IllegalArgumentException("no such component");
                }
                if (!(n instanceof Database)) {
                    throw new IllegalArgumentException("not a database");
                }
                Database database = (Database)n;
                ItemStack dbStack = database.getStackInSlot(entry - 1);
                if (dbStack == null || size < 1 || dbStack.func_190926_b()) {
                    dbStack = ItemStack.field_190927_a;
                } else {
                    dbStack.func_190920_e(Math.min(size, dbStack.func_77976_d()));
                }
                stack = dbStack;
            }
            config.extractItem(slot, config.getStackInSlot(slot).func_190916_E(), false);
            config.insertItem(slot, stack, false);
            context.pause(0.5);
            return new Object[]{true};
        }

        @Callback(doc="function():table -- Get a list of tables representing the available CPUs in the network.")
        public Object[] getCpus(Context context, Arguments arguments) {
            return NetworkControl.class.getCpus((NetworkControl)this, (Context)context, (Arguments)arguments);
        }

        @Callback(doc="function([filter:table]):table -- Get a list of known item recipes. These can be used to issue crafting requests.")
        public Object[] getCraftables(Context context, Arguments arguments) {
            return NetworkControl.class.getCraftables((NetworkControl)this, (Context)context, (Arguments)arguments);
        }

        @Callback(doc="function([filter:table]):table -- Get a list of the stored items in the network.")
        public Object[] getItemsInNetwork(Context context, Arguments arguments) {
            return NetworkControl.class.getItemsInNetwork((NetworkControl)this, (Context)context, (Arguments)arguments);
        }

        @Callback(doc="function([filter:table, dbAddress:string, startSlot:number, count:number]): bool -- Store items in the network matching the specified filter in the database with the specified address.")
        public Object[] store(Context context, Arguments arguments) {
            return NetworkControl.class.store((NetworkControl)this, (Context)context, (Arguments)arguments);
        }

        @Callback(doc="function():table -- Get a list of the stored fluids in the network.")
        public Object[] getFluidsInNetwork(Context context, Arguments arguments) {
            return NetworkControl.class.getFluidsInNetwork((NetworkControl)this, (Context)context, (Arguments)arguments);
        }

        @Callback(doc="function():number -- Get the average power injection into the network.")
        public Object[] getAvgPowerInjection(Context context, Arguments arguments) {
            return NetworkControl.class.getAvgPowerInjection((NetworkControl)this, (Context)context, (Arguments)arguments);
        }

        @Callback(doc="function():number -- Get the average power usage of the network.")
        public Object[] getAvgPowerUsage(Context context, Arguments arguments) {
            return NetworkControl.class.getAvgPowerUsage((NetworkControl)this, (Context)context, (Arguments)arguments);
        }

        @Callback(doc="function():number -- Get the idle power usage of the network.")
        public Object[] getIdlePowerUsage(Context context, Arguments arguments) {
            return NetworkControl.class.getIdlePowerUsage((NetworkControl)this, (Context)context, (Arguments)arguments);
        }

        @Callback(doc="function():number -- Get the maximum stored power in the network.")
        public Object[] getMaxStoredPower(Context context, Arguments arguments) {
            return NetworkControl.class.getMaxStoredPower((NetworkControl)this, (Context)context, (Arguments)arguments);
        }

        @Callback(doc="function():number -- Get the stored power in the network. ")
        public Object[] getStoredPower(Context context, Arguments arguments) {
            return NetworkControl.class.getStoredPower((NetworkControl)this, (Context)context, (Arguments)arguments);
        }

        @Callback(doc="function():boolean -- True if the AE network is considered online")
        public Object[] isNetworkPowered(Context context, Arguments arguments) {
            return NetworkControl.class.isNetworkPowered((NetworkControl)this, (Context)context, (Arguments)arguments);
        }

        @Callback(doc="function():number -- Returns the energy demand on the AE network")
        public Object[] getEnergyDemand(Context context, Arguments arguments) {
            return NetworkControl.class.getEnergyDemand((NetworkControl)this, (Context)context, (Arguments)arguments);
        }

        public String preferredName() {
            return name;
        }

        public int priority() {
            return 5;
        }

        public TileDualInterface tile() {
            return (TileDualInterface)this.tileEntity;
        }

        public AEPartLocation pos() {
            return AEPartLocation.INTERNAL;
        }
    }
}

