/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.integration.mek;

import appeng.api.storage.data.IAEItemStack;
import appeng.client.render.StackSizeRenderer;
import com.glodblock.github.client.render.FluidRenderUtils;
import com.glodblock.github.common.item.ItemGasPacket;
import com.glodblock.github.common.item.fake.FakeItemRegister;
import com.glodblock.github.integration.mek.FakeGases;
import javax.annotation.Nullable;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.client.render.MekanismRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class GasRenderUtil {
    private static TextureAtlasSprite getStillGasSprite(Gas gas) {
        TextureMap textureMapBlocks = Minecraft.func_71410_x().func_147117_R();
        ResourceLocation gasStill = gas.getIcon();
        TextureAtlasSprite gasStillSprite = null;
        if (gasStill != null) {
            gasStillSprite = textureMapBlocks.getTextureExtry(gasStill.toString());
        }
        if (gasStillSprite == null) {
            gasStillSprite = textureMapBlocks.func_174944_f();
        }
        return gasStillSprite;
    }

    public static void renderGasIntoGuiCleanly(int x, int y, int width, int height, @Nullable GasStack gasStack, int capacity) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        if (gasStack != null && gasStack.getGas() != null) {
            TextureAtlasSprite sprite = GasRenderUtil.getStillGasSprite(gasStack.getGas());
            Tessellator tess = Tessellator.func_178181_a();
            BufferBuilder buf = tess.func_178180_c();
            MekanismRenderer.color((Gas)gasStack.getGas());
            FluidRenderUtils.doRenderFluid(tess, buf, x, y, width, height, sprite, (double)gasStack.amount / (double)capacity);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static boolean renderGasIntoGuiSlot(Slot slot, @Nullable GasStack gas, StackSizeRenderer stackSizeRenderer, FontRenderer fontRenderer) {
        if (gas == null || gas.amount <= 0) {
            return false;
        }
        GasRenderUtil.renderGasIntoGuiCleanly(slot.field_75223_e, slot.field_75221_f, 16, 16, gas, gas.amount);
        stackSizeRenderer.renderStackSize(fontRenderer, FakeGases.packGas2AEDrops(gas), slot.field_75223_e, slot.field_75221_f);
        return true;
    }

    public static boolean renderGasPacketIntoGuiSlot(Slot slot, @Nullable IAEItemStack stack, StackSizeRenderer stackSizeRenderer, FontRenderer fontRenderer) {
        return stack != null && stack.getItem() instanceof ItemGasPacket && GasRenderUtil.renderGasIntoGuiSlot(slot, (GasStack)FakeItemRegister.getStack(stack), stackSizeRenderer, fontRenderer);
    }

    public static boolean renderGasPacketIntoGuiSlot(Slot slot, ItemStack stack, StackSizeRenderer stackSizeRenderer, FontRenderer fontRenderer) {
        return !stack.func_190926_b() && stack.func_77973_b() instanceof ItemGasPacket && GasRenderUtil.renderGasIntoGuiSlot(slot, (GasStack)FakeItemRegister.getStack(stack), stackSizeRenderer, fontRenderer);
    }
}

