/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.integration.jei;

import com.glodblock.github.common.item.fake.FakeFluids;
import com.glodblock.github.integration.gregtech.GregUtil;
import com.glodblock.github.integration.mek.FakeGases;
import com.glodblock.github.util.Ae2Reflect;
import com.glodblock.github.util.ModAndClassUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import mekanism.api.gas.GasStack;
import mekanism.client.jei.MekanismJEI;
import mezz.jei.api.gui.IGuiIngredient;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.gui.recipes.RecipeLayout;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class RecipeTransferBuilder {
    private static final int MAX_ITEMS = 16;
    private static Field fRecipeLayout_recipeWrapper;
    private final Int2ObjectArrayMap<ItemStack[]> in = new Int2ObjectArrayMap();
    private final List<ItemStack> out = new ArrayList<ItemStack>();
    private final IRecipeLayout recipe;
    private List<ItemStack[]> itemsIn;
    private List<FluidStack> fluidIn;
    private List<Object> gasIn;
    private List<ItemStack> itemOut;
    private List<FluidStack> fluidOut;
    private List<Object> gasOut;
    private boolean noNull = true;
    private boolean fluidFirst = false;

    public RecipeTransferBuilder(IRecipeLayout recipe) {
        this.recipe = recipe;
        this.itemsIn = new ArrayList<ItemStack[]>();
        this.itemOut = new ArrayList<ItemStack>();
        this.fluidIn = new ArrayList<FluidStack>();
        this.fluidOut = new ArrayList<FluidStack>();
        this.gasIn = new ArrayList<Object>();
        this.gasOut = new ArrayList<Object>();
        this.split();
    }

    private void split() {
        Iterator<Object> iterator = this.recipe.getItemStacks().getGuiIngredients().keySet().iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            IGuiIngredient ing = (IGuiIngredient)this.recipe.getItemStacks().getGuiIngredients().get(index);
            if (ing.isInput()) {
                if (ModAndClassUtil.GT && GregUtil.isNotConsume(this.getWrapper(this.recipe), index)) continue;
                List<Object> holder = ing.getAllIngredients().size() < 15 ? ing.getAllIngredients() : ing.getAllIngredients().subList(0, 15);
                if (ing.getDisplayedIngredient() != null) {
                    holder.add(0, ing.getDisplayedIngredient());
                }
                this.itemsIn.add(holder.toArray(new ItemStack[0]));
                continue;
            }
            this.itemOut.add((ItemStack)ing.getDisplayedIngredient());
        }
        for (IGuiIngredient ing : this.recipe.getFluidStacks().getGuiIngredients().values()) {
            if (ing.isInput()) {
                this.fluidIn.add((FluidStack)ing.getDisplayedIngredient());
                continue;
            }
            this.fluidOut.add((FluidStack)ing.getDisplayedIngredient());
        }
        if (ModAndClassUtil.GAS) {
            for (IGuiIngredient ing : this.recipe.getIngredientsGroup(MekanismJEI.TYPE_GAS).getGuiIngredients().values()) {
                if (ing.isInput()) {
                    this.gasIn.add(ing.getDisplayedIngredient());
                    continue;
                }
                this.gasOut.add(ing.getDisplayedIngredient());
            }
        }
    }

    private void setItemIn(int offset) {
        int bound = this.itemsIn.size() + offset;
        for (int index = offset; index < bound; ++index) {
            int i = index - offset;
            if (this.itemsIn.get(i) == null || this.itemsIn.get(i).length <= 0) continue;
            this.in.put(index, (Object)this.itemsIn.get(i));
        }
    }

    private void setFluidIn(int offset) {
        int bound = this.fluidIn.size() + this.gasIn.size() + offset;
        for (int index = offset; index < bound; ++index) {
            int i = index - offset;
            if (i < this.fluidIn.size()) {
                if (this.fluidIn.get(i) == null) continue;
                this.in.put(index, (Object)new ItemStack[]{FakeFluids.packFluid2Packet(this.fluidIn.get(i))});
                continue;
            }
            if (this.gasIn.get(i -= this.fluidIn.size()) == null) continue;
            this.in.put(index, (Object)new ItemStack[]{FakeGases.packGas2Packet((GasStack)this.gasIn.get(i))});
        }
    }

    private void setOutputs() {
        for (int index = 0; index < this.itemOut.size() + this.fluidOut.size() + this.gasOut.size(); ++index) {
            if (index < this.itemOut.size()) {
                this.out.add(this.itemOut.get(index));
                continue;
            }
            if (index - this.itemOut.size() < this.fluidOut.size()) {
                this.out.add(FakeFluids.packFluid2Packet(this.fluidOut.get(index - this.itemOut.size())));
                continue;
            }
            if (index - this.itemOut.size() - this.fluidOut.size() >= this.gasOut.size()) continue;
            this.out.add(FakeGases.packGas2Packet((GasStack)this.gasOut.get(index - this.itemOut.size() - this.fluidOut.size())));
        }
    }

    public RecipeTransferBuilder clearEmptySlot(boolean val) {
        this.noNull = val;
        return this;
    }

    public RecipeTransferBuilder putFluidFirst(boolean val) {
        this.fluidFirst = val;
        return this;
    }

    public RecipeTransferBuilder build() {
        if (this.noNull) {
            this.itemsIn = this.itemsIn.stream().filter(o -> o != null && ((ItemStack[])o).length > 0).collect(Collectors.toList());
            this.itemOut = this.itemOut.stream().filter(Objects::nonNull).collect(Collectors.toList());
            this.fluidIn = this.fluidIn.stream().filter(Objects::nonNull).collect(Collectors.toList());
            this.fluidOut = this.fluidOut.stream().filter(Objects::nonNull).collect(Collectors.toList());
            this.gasIn = this.gasIn.stream().filter(Objects::nonNull).collect(Collectors.toList());
            this.gasOut = this.gasOut.stream().filter(Objects::nonNull).collect(Collectors.toList());
        }
        if (this.fluidFirst) {
            this.setFluidIn(0);
            this.setItemIn(this.fluidIn.size() + this.gasIn.size());
        } else {
            this.setItemIn(0);
            this.setFluidIn(this.itemsIn.size());
        }
        this.setOutputs();
        return this;
    }

    public List<ItemStack> getOutput() {
        return this.out;
    }

    public Int2ObjectMap<ItemStack[]> getInput() {
        return this.in;
    }

    private IRecipeWrapper getWrapper(IRecipeLayout recipe) {
        if (fRecipeLayout_recipeWrapper != null) {
            return (IRecipeWrapper)Ae2Reflect.readField((Object)recipe, fRecipeLayout_recipeWrapper);
        }
        return null;
    }

    static {
        try {
            fRecipeLayout_recipeWrapper = Ae2Reflect.reflectField(RecipeLayout.class, "recipeWrapper");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
    }
}

