/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.integration.jei;

import appeng.api.storage.data.IAEItemStack;
import appeng.container.slot.IJEITargetSlot;
import appeng.container.slot.SlotFake;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketInventoryAction;
import appeng.helpers.InventoryAction;
import com.glodblock.github.common.item.fake.FakeFluids;
import com.glodblock.github.integration.mek.FakeGases;
import com.glodblock.github.util.ModAndClassUtil;
import com.glodblock.github.util.Util;
import java.awt.Rectangle;
import java.io.IOException;
import javax.annotation.Nonnull;
import mekanism.api.gas.GasStack;
import mezz.jei.api.gui.IGhostIngredientHandler;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class FluidPacketTarget
implements IGhostIngredientHandler.Target<Object> {
    private final int left;
    private final int top;
    private final Slot slot;

    public FluidPacketTarget(int guiLeft, int guiTop, Slot slot) {
        this.left = guiLeft;
        this.top = guiTop;
        this.slot = slot;
    }

    @Nonnull
    public Rectangle getArea() {
        return new Rectangle(this.left + this.slot.field_75223_e, this.top + this.slot.field_75221_f, 16, 16);
    }

    public void accept(@Nonnull Object ingredient) {
        FluidStack fluid = FluidPacketTarget.covertFluid(ingredient);
        Object gas = FluidPacketTarget.covertGas(ingredient);
        if (fluid == null && gas == null) {
            return;
        }
        IAEItemStack packet = fluid != null ? FakeFluids.packFluid2AEPacket(fluid) : FakeGases.packGas2AEPacket((GasStack)gas);
        try {
            PacketInventoryAction p = new PacketInventoryAction(InventoryAction.PLACE_JEI_GHOST_ITEM, (IJEITargetSlot)((SlotFake)this.slot), packet);
            NetworkHandler.instance().sendToServer((AppEngPacket)p);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static FluidStack covertFluid(Object ingredient) {
        if (ingredient instanceof FluidStack) {
            return (FluidStack)ingredient;
        }
        if (ingredient instanceof ItemStack) {
            return Util.getFluidFromItem((ItemStack)ingredient);
        }
        return null;
    }

    public static Object covertGas(Object ingredient) {
        if (ModAndClassUtil.GAS) {
            if (ingredient instanceof GasStack) {
                return ingredient;
            }
            if (ingredient instanceof ItemStack) {
                return Util.getGasFromItem((ItemStack)ingredient);
            }
        }
        return null;
    }
}

