/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.integration.dynamistics;

import appeng.api.storage.data.IAEItemStack;
import appeng.util.item.AEItemStack;
import com.glodblock.github.common.item.fake.FakeFluids;
import com.glodblock.github.integration.dynamistics.FluidPatternCategory;
import com.glodblock.github.loader.FCItems;
import com.glodblock.github.util.FluidPatternDetails;
import eutros.dynamistics.jei.SingletonRecipe;
import java.util.Collections;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeRegistryPlugin;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class FluidPatternPlugin
implements IRecipeRegistryPlugin {
    public static final IRecipeRegistryPlugin INSTANCE = new FluidPatternPlugin();
    private static ItemStack EXAMPLE_PATTERN;

    private FluidPatternPlugin() {
    }

    public <V> List<String> getRecipeCategoryUids(IFocus<V> focus) {
        ItemStack stack;
        if (focus.getValue() instanceof ItemStack && ((stack = (ItemStack)focus.getValue()).func_77973_b() == FCItems.DENSE_ENCODED_PATTERN || stack.func_77973_b() == FCItems.LARGE_ITEM_ENCODED_PATTERN) && stack.func_77942_o()) {
            return Collections.singletonList(FluidPatternCategory.UID);
        }
        return Collections.emptyList();
    }

    public <T extends IRecipeWrapper, V> List<T> getRecipeWrappers(IRecipeCategory<T> recipeCategory, IFocus<V> focus) {
        if (recipeCategory instanceof FluidPatternCategory && (((ItemStack)focus.getValue()).func_77973_b() == FCItems.DENSE_ENCODED_PATTERN || ((ItemStack)focus.getValue()).func_77973_b() == FCItems.LARGE_ITEM_ENCODED_PATTERN)) {
            return Collections.singletonList(new SingletonRecipe((ItemStack)focus.getValue(), focus.getMode() == IFocus.Mode.INPUT).cast());
        }
        return Collections.emptyList();
    }

    public <T extends IRecipeWrapper> List<T> getRecipeWrappers(IRecipeCategory<T> recipeCategory) {
        if (recipeCategory instanceof FluidPatternCategory) {
            return Collections.singletonList(new SingletonRecipe(FluidPatternPlugin.getExampleItem(), true).cast());
        }
        return Collections.emptyList();
    }

    private static ItemStack getExampleItem() {
        if (EXAMPLE_PATTERN == null) {
            EXAMPLE_PATTERN = new ItemStack((Item)FCItems.DENSE_ENCODED_PATTERN);
            FluidPatternDetails pattern = new FluidPatternDetails(EXAMPLE_PATTERN);
            pattern.setInputs(new IAEItemStack[]{FakeFluids.packFluid2AEDrops(FluidRegistry.getFluidStack((String)"water", (int)1000)), AEItemStack.fromItemStack((ItemStack)new ItemStack(Items.field_151133_ar))});
            pattern.setOutputs(new IAEItemStack[]{AEItemStack.fromItemStack((ItemStack)new ItemStack(Items.field_151131_as))});
            pattern.writeToStack();
        }
        return EXAMPLE_PATTERN;
    }
}

