/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.integration.dynamistics;

import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.storage.data.IAEItemStack;
import appeng.items.misc.ItemEncodedPattern;
import com.glodblock.github.FluidCraft;
import com.glodblock.github.common.item.ItemFluidCraftEncodedPattern;
import com.glodblock.github.loader.FCBlocks;
import com.glodblock.github.loader.FCItems;
import com.glodblock.github.util.FluidCraftingPatternDetails;
import eutros.dynamistics.helper.JeiHelper;
import eutros.dynamistics.jei.SingletonRecipe;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class FluidCraftPatternCategory
implements IRecipeCategory<SingletonRecipe> {
    private static final int HEIGHT = 126;
    private static final int WIDTH = 146;
    public static final String UID = FluidCraft.resource("dy_fluid_craft_pattern").toString();
    private final IDrawableStatic background;
    private final IDrawableStatic slot;
    private final ItemStack interfaceStack;
    private final IDrawableStatic craftingBackground;
    private final IDrawable icon;
    private final IDrawableStatic arrow;
    private final int guiStartX;
    private final int guiStartY;

    public FluidCraftPatternCategory(IJeiHelpers helpers) {
        IGuiHelper guiHelper = helpers.getGuiHelper();
        this.slot = JeiHelper.getSlotDrawable();
        this.craftingBackground = guiHelper.createDrawable(new ResourceLocation("appliedenergistics2", "textures/guis/pattern.png"), 9, 85, 126, 68);
        this.background = guiHelper.createBlankDrawable(146, 126);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((Item)FCItems.DENSE_CRAFT_ENCODED_PATTERN));
        this.interfaceStack = new ItemStack((Block)FCBlocks.FLUID_ASSEMBLER);
        this.arrow = guiHelper.createDrawable(new ResourceLocation("dynamistics", "textures/gui/arrows.png"), 64, 16, 32, 32);
        this.guiStartY = 126 - this.craftingBackground.getHeight();
        this.guiStartX = (146 - this.craftingBackground.getWidth()) / 2;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    @Nonnull
    public String getUid() {
        return UID;
    }

    @Nonnull
    public String getTitle() {
        return I18n.func_135052_a((String)"ae2fc.dynamistics.category.title.craft_pattern", (Object[])new Object[0]);
    }

    @Nonnull
    public String getModName() {
        return "Fluid Craft for AE2";
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(IRecipeLayout recipeLayout, @Nonnull SingletonRecipe recipe, @Nonnull IIngredients ingredients) {
        IGuiItemStackGroup stacks = recipeLayout.getItemStacks();
        ItemStack patternStack = recipe.stack;
        if (patternStack == null) {
            patternStack = (ItemStack)((List)ingredients.getInputs(VanillaTypes.ITEM).get(0)).get(0);
        }
        stacks.init(13, true, 65, 8);
        stacks.set(13, patternStack);
        stacks.setBackground(13, (IDrawable)this.slot);
        stacks.init(14, true, 65, 29);
        stacks.set(14, this.interfaceStack);
        if (patternStack.func_77973_b() instanceof ItemFluidCraftEncodedPattern) {
            ItemEncodedPattern pattern = (ItemEncodedPattern)patternStack.func_77973_b();
            ICraftingPatternDetails details = pattern.getPatternForItem(patternStack, null);
            if (!(details instanceof FluidCraftingPatternDetails)) {
                return;
            }
            IAEItemStack[] inputs = ((FluidCraftingPatternDetails)details).getOriginInputs();
            IAEItemStack[] outputs = details.getOutputs();
            int gridStartY = 7;
            int gridStartX = 8;
            int gridSize = 18;
            for (int i = 0; i < inputs.length; ++i) {
                if (inputs[i] == null) continue;
                stacks.init(i, true, this.guiStartX + gridStartX + gridSize * (i % 3), this.guiStartY + gridStartY + gridSize * (i / 3));
                stacks.set(i, inputs[i].createItemStack());
            }
            int outStartX = 100;
            if (outputs.length > 0 && outputs[0] != null) {
                stacks.init(9, false, this.guiStartX + outStartX, this.guiStartY + gridStartY + gridSize);
                stacks.set(9, outputs[0].createItemStack());
            }
        }
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        this.arrow.draw(minecraft, (146 - this.arrow.getWidth()) / 2, 27);
        this.craftingBackground.draw(minecraft, this.guiStartX, this.guiStartY);
    }
}

