/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.handler;

import com.glodblock.github.common.item.ItemFluidDrop;
import com.glodblock.github.common.item.ItemFluidPacket;
import com.glodblock.github.common.item.fake.FakeFluids;
import com.glodblock.github.common.item.fake.FakeItemRegister;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class FluidConvertingItemHandler
implements IItemHandler {
    @Nullable
    private final IItemHandler invItems;
    @Nullable
    private final IFluidHandler invFluids;

    public static FluidConvertingItemHandler wrap(ICapabilityProvider capProvider, EnumFacing face) {
        return new FluidConvertingItemHandler(capProvider.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, face) ? (IItemHandler)Objects.requireNonNull(capProvider.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, face)) : null, capProvider.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, face) ? (IFluidHandler)Objects.requireNonNull(capProvider.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, face)) : null);
    }

    private FluidConvertingItemHandler(@Nullable IItemHandler invItems, @Nullable IFluidHandler invFluids) {
        this.invItems = invItems;
        this.invFluids = invFluids;
    }

    public int getSlots() {
        int slots = 0;
        if (this.invItems != null) {
            slots += this.invItems.getSlots();
        }
        if (this.invFluids != null) {
            slots += this.invFluids.getTankProperties().length;
        }
        return slots;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return this.slotOp(slot, IItemHandler::getStackInSlot, (fh, i) -> FakeFluids.packFluid2Drops(fh.getTankProperties()[i].getContents()));
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        return this.slotOp(slot, (ih, i) -> stack.func_77973_b() instanceof ItemFluidDrop || stack.func_77973_b() instanceof ItemFluidPacket ? stack : ih.insertItem(i, stack, simulate), (fh, i) -> {
            int insertable;
            FluidStack contained;
            FluidStack toInsert;
            if (stack.func_77973_b() instanceof ItemFluidDrop) {
                FluidStack contained2;
                FluidStack toInsert2 = (FluidStack)FakeItemRegister.getStack(stack);
                if (toInsert2 != null && toInsert2.amount > 0 && ((contained2 = fh.getTankProperties()[i].getContents()) == null || contained2.amount == 0 || contained2.isFluidEqual(toInsert2))) {
                    toInsert2.amount = toInsert2.amount - fh.fill(toInsert2, !simulate);
                    return FakeFluids.packFluid2Drops(toInsert2);
                }
            } else if (stack.func_77973_b() instanceof ItemFluidPacket && (toInsert = (FluidStack)FakeItemRegister.getStack(stack)) != null && toInsert.amount > 0 && ((contained = fh.getTankProperties()[i].getContents()) == null || contained.amount == 0 || contained.isFluidEqual(toInsert)) && (insertable = fh.fill(toInsert, false)) >= toInsert.amount) {
                if (!simulate) {
                    fh.fill(toInsert, true);
                }
                return ItemStack.field_190927_a;
            }
            return stack;
        });
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.slotOp(slot, (ih, i) -> ih.extractItem(i, slot, simulate), (fh, i) -> {
            FluidStack contained = fh.getTankProperties()[i].getContents();
            if (contained != null && contained.amount > 0) {
                return FakeFluids.packFluid2Drops(fh.drain(contained, !simulate));
            }
            return ItemStack.field_190927_a;
        });
    }

    public int getSlotLimit(int slot) {
        return this.slotOp(slot, IItemHandler::getSlotLimit, (fh, i) -> fh.getTankProperties()[i].getCapacity());
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return this.slotOp(slot, (ih, i) -> ih.isItemValid(i, stack), (fh, i) -> stack.func_77973_b() instanceof ItemFluidDrop || stack.func_77973_b() instanceof ItemFluidPacket);
    }

    private <T> T slotOp(int slot, Op<IItemHandler, T> itemConsumer, Op<IFluidHandler, T> fluidConsumer) {
        if (slot >= 0) {
            IFluidTankProperties[] tanks;
            int fluidSlot = slot;
            if (this.invItems != null) {
                if (slot < this.invItems.getSlots()) {
                    return itemConsumer.apply(this.invItems, slot);
                }
                fluidSlot -= this.invItems.getSlots();
            }
            if (this.invFluids != null && fluidSlot < (tanks = this.invFluids.getTankProperties()).length) {
                return fluidConsumer.apply(this.invFluids, fluidSlot);
            }
        }
        throw new IndexOutOfBoundsException(String.format("Slot index %d out of bounds! |items| = %d, |fluids| = %d", slot, this.invItems != null ? this.invItems.getSlots() : 0, this.invFluids != null ? this.invFluids.getTankProperties().length : 0));
    }

    @FunctionalInterface
    private static interface Op<C, T> {
        public T apply(C var1, int var2);
    }
}

