/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.coremod;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IMachineSet;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.crafting.ICraftingJob;
import appeng.api.networking.crafting.ICraftingLink;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.channels.IFluidStorageChannel;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.container.ContainerOpenContext;
import appeng.container.implementations.ContainerCraftConfirm;
import appeng.container.implementations.ContainerPatternEncoder;
import appeng.container.implementations.CraftingCPURecord;
import appeng.crafting.MECraftingInventory;
import appeng.fluids.parts.PartFluidInterface;
import appeng.fluids.tile.TileFluidInterface;
import appeng.helpers.DualityInterface;
import appeng.helpers.IInterfaceHost;
import appeng.helpers.WirelessTerminalGuiObject;
import appeng.me.cluster.implementations.CraftingCPUCluster;
import appeng.parts.misc.PartInterface;
import appeng.tile.misc.TileInterface;
import appeng.util.InventoryAdaptor;
import appeng.util.inv.BlockingInventoryAdaptor;
import appeng.util.item.AEItemStack;
import com.glodblock.github.client.container.ContainerFCCraftConfirm;
import com.glodblock.github.common.item.ItemFluidCraftEncodedPattern;
import com.glodblock.github.common.item.ItemFluidEncodedPattern;
import com.glodblock.github.common.item.ItemFluidPacket;
import com.glodblock.github.common.item.ItemLargeEncodedPattern;
import com.glodblock.github.common.item.fake.FakeFluids;
import com.glodblock.github.common.item.fake.FakeItemRegister;
import com.glodblock.github.common.part.PartDualInterface;
import com.glodblock.github.common.part.PartExtendedFluidPatternTerminal;
import com.glodblock.github.common.part.PartFluidPatternTerminal;
import com.glodblock.github.common.tile.TileDualInterface;
import com.glodblock.github.handler.FluidConvertingItemHandler;
import com.glodblock.github.integration.mek.FCGasItems;
import com.glodblock.github.integration.mek.FakeGases;
import com.glodblock.github.integration.mek.GasInterfaceUtil;
import com.glodblock.github.inventory.BlockingFluidInventoryAdaptor;
import com.glodblock.github.inventory.FluidConvertingInventoryAdaptor;
import com.glodblock.github.inventory.FluidConvertingInventoryCrafting;
import com.glodblock.github.inventory.GuiType;
import com.glodblock.github.inventory.InventoryHandler;
import com.glodblock.github.loader.FCItems;
import com.glodblock.github.util.Ae2Reflect;
import com.glodblock.github.util.ModAndClassUtil;
import com.glodblock.github.util.SetBackedMachineSet;
import com.google.common.base.Preconditions;
import com.mekeng.github.common.me.data.IAEGasStack;
import com.mekeng.github.common.me.storage.IGasStorageChannel;
import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nullable;
import mekanism.api.gas.GasStack;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class CoreModHooks {
    public static InventoryCrafting wrapCraftingBuffer(InventoryCrafting inv) {
        int s = inv.func_174922_i() > 3 ? 10 : 3;
        return new FluidConvertingInventoryCrafting(Ae2Reflect.getCraftContainer(inv), s, s);
    }

    public static IAEItemStack wrapFluidPacketStack(IAEItemStack stack) {
        IAEItemStack dropStack;
        if (stack.getItem() == FCItems.FLUID_PACKET && (dropStack = FakeFluids.packFluid2AEDrops((FluidStack)FakeItemRegister.getStack(stack))) != null) {
            return dropStack;
        }
        if (ModAndClassUtil.GAS && stack.getItem() == FCGasItems.GAS_PACKET && (dropStack = FakeGases.packGas2AEDrops((GasStack)FakeItemRegister.getStack(stack))) != null) {
            return dropStack;
        }
        return stack;
    }

    @Nullable
    public static InventoryAdaptor wrapInventory(@Nullable TileEntity tile, EnumFacing face) {
        return tile != null ? FluidConvertingInventoryAdaptor.wrap((ICapabilityProvider)tile, face) : null;
    }

    @Nullable
    public static BlockingInventoryAdaptor wrapBlockInventory(@Nullable TileEntity tile, EnumFacing face) {
        return tile != null ? BlockingFluidInventoryAdaptor.getAdaptor(tile, face) : null;
    }

    public static void writeExtraNBTInterface(DualityInterface dual, NBTTagCompound nbt) {
        nbt.func_74757_a("fluidPacket", Ae2Reflect.getFluidPacketMode(dual));
        nbt.func_74757_a("allowSplitting", Ae2Reflect.getSplittingMode(dual));
        nbt.func_74768_a("blockModeEx", Ae2Reflect.getExtendedBlockMode(dual));
    }

    public static void readExtraNBTInterface(DualityInterface dual, NBTTagCompound nbt) {
        Ae2Reflect.setFluidPacketMode(dual, nbt.func_74767_n("fluidPacket"));
        Ae2Reflect.setSplittingMode(dual, !nbt.func_74764_b("allowSplitting") || nbt.func_74767_n("allowSplitting"));
        Ae2Reflect.setExtendedBlockMode(dual, nbt.func_74762_e("blockModeEx"));
    }

    public static ItemStack removeFluidPackets(InventoryCrafting inv, int index) {
        ItemStack stack = inv.func_70301_a(index);
        if (!stack.func_190926_b() && stack.func_77973_b() == FCItems.FLUID_PACKET) {
            FluidStack fluid = (FluidStack)FakeItemRegister.getStack(stack);
            return FakeFluids.packFluid2Drops(fluid);
        }
        if (ModAndClassUtil.GAS && !stack.func_190926_b() && stack.func_77973_b() == FCGasItems.GAS_PACKET) {
            GasStack gas = (GasStack)FakeItemRegister.getStack(stack);
            return FakeGases.packGas2Drops(gas);
        }
        return stack;
    }

    public static long getCraftingByteCost(IAEItemStack stack) {
        if (stack.getItem() == FCItems.FLUID_DROP) {
            return (long)Math.ceil((double)stack.getStackSize() / 1000.0);
        }
        if (ModAndClassUtil.GAS && stack.getItem() == FCGasItems.GAS_DROP) {
            return (long)Math.ceil((double)stack.getStackSize() / 4000.0);
        }
        return stack.getStackSize();
    }

    public static long getCraftingByteCost(long originBytes, long missingBytes, IAEItemStack stack) {
        if (stack != null && stack.getItem() == FCItems.FLUID_DROP) {
            return (long)Math.ceil((double)missingBytes / 1000.0) + originBytes;
        }
        if (ModAndClassUtil.GAS && stack != null && stack.getItem() == FCGasItems.GAS_DROP) {
            return (long)Math.ceil((double)missingBytes / 4000.0) + originBytes;
        }
        return missingBytes + originBytes;
    }

    public static boolean checkForItemHandler(ICapabilityProvider capProvider, Capability<?> capability, EnumFacing side) {
        return capProvider.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side) || capProvider.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side);
    }

    public static IItemHandler wrapItemHandler(ICapabilityProvider capProvider, Capability<?> capability, EnumFacing side) {
        return FluidConvertingItemHandler.wrap(capProvider, side);
    }

    public static IAEItemStack[] flattenFluidPackets(IAEItemStack[] stacks) {
        for (int i = 0; i < stacks.length; ++i) {
            if (stacks[i] == null || !(stacks[i].getItem() instanceof ItemFluidPacket)) continue;
            stacks[i] = FakeFluids.packFluid2AEDrops((FluidStack)FakeItemRegister.getStack(stacks[i]));
        }
        return stacks;
    }

    public static IMachineSet getMachines(IGrid grid, Class<? extends IGridHost> c) {
        if (c == TileInterface.class || c == TileFluidInterface.class) {
            if (ModAndClassUtil.GAS) {
                return CoreModHooks.unionMachineSets(grid.getMachines(c), grid.getMachines(TileDualInterface.class), GasInterfaceUtil.getGasInterface(grid));
            }
            return CoreModHooks.unionMachineSets(grid.getMachines(c), grid.getMachines(TileDualInterface.class));
        }
        if (c == PartInterface.class || c == PartFluidInterface.class) {
            if (ModAndClassUtil.GAS) {
                return CoreModHooks.unionMachineSets(grid.getMachines(c), grid.getMachines(PartDualInterface.class), GasInterfaceUtil.getGasPartInterface(grid));
            }
            return CoreModHooks.unionMachineSets(grid.getMachines(c), grid.getMachines(PartDualInterface.class));
        }
        if (ModAndClassUtil.GAS && GasInterfaceUtil.isGasInterfaceTile(c)) {
            return CoreModHooks.unionMachineSets(grid.getMachines(c), GasInterfaceUtil.getGasInterface(grid));
        }
        if (ModAndClassUtil.GAS && GasInterfaceUtil.isGasInterfacePart(c)) {
            return CoreModHooks.unionMachineSets(grid.getMachines(c), GasInterfaceUtil.getGasPartInterface(grid));
        }
        return grid.getMachines(c);
    }

    public static Object wrapFluidPacket(ItemStack stack) {
        if (FakeFluids.isFluidFakeItem(stack)) {
            return FakeItemRegister.getStack(stack);
        }
        if (ModAndClassUtil.GAS && FakeGases.isGasFakeItem(stack)) {
            return FakeItemRegister.getStack(stack);
        }
        return stack;
    }

    private static IMachineSet unionMachineSets(IMachineSet ... sets) {
        return SetBackedMachineSet.combine(TileInterface.class, sets);
    }

    public static ItemStack displayFluid(ItemStack drop) {
        if (!drop.func_190926_b() && drop.func_77973_b() == FCItems.FLUID_DROP) {
            FluidStack fluid = (FluidStack)FakeItemRegister.getStack(drop);
            return FakeFluids.displayFluid(fluid);
        }
        if (!drop.func_190926_b() && ModAndClassUtil.GAS && drop.func_77973_b() == FCGasItems.GAS_DROP) {
            GasStack gas = (GasStack)FakeItemRegister.getStack(drop);
            return FakeGases.displayGas(gas);
        }
        return drop;
    }

    public static IAEItemStack displayAEFluid(IAEItemStack drop) {
        if (!drop.getDefinition().func_190926_b() && drop.getItem() == FCItems.FLUID_DROP) {
            FluidStack fluid = (FluidStack)FakeItemRegister.getStack(drop);
            return AEItemStack.fromItemStack((ItemStack)FakeFluids.displayFluid(fluid));
        }
        if (!drop.getDefinition().func_190926_b() && ModAndClassUtil.GAS && drop.getItem() == FCGasItems.GAS_DROP) {
            GasStack gas = (GasStack)FakeItemRegister.getStack(drop);
            return AEItemStack.fromItemStack((ItemStack)FakeGases.displayGas(gas));
        }
        return drop;
    }

    public static IAEItemStack displayAEFluidAmount(IAEItemStack drop) {
        if (drop != null && !drop.getDefinition().func_190926_b()) {
            if (drop.getItem() == FCItems.FLUID_DROP) {
                FluidStack fluid = (FluidStack)FakeItemRegister.getStack(drop);
                AEItemStack stack = AEItemStack.fromItemStack((ItemStack)FakeFluids.displayFluid(fluid));
                return stack == null ? null : (IAEItemStack)stack.setStackSize(drop.getStackSize());
            }
            if (ModAndClassUtil.GAS && drop.getItem() == FCGasItems.GAS_DROP) {
                GasStack gas = (GasStack)FakeItemRegister.getStack(drop);
                AEItemStack stack = AEItemStack.fromItemStack((ItemStack)FakeGases.displayGas(gas));
                return stack == null ? null : (IAEItemStack)stack.setStackSize(drop.getStackSize());
            }
        }
        return drop;
    }

    public static long getFluidSize(IAEItemStack aeStack) {
        if (aeStack.getDefinition() != null && !aeStack.getDefinition().func_190926_b()) {
            if (aeStack.getDefinition().func_77973_b() == FCItems.FLUID_DROP) {
                return (long)Math.max((double)aeStack.getStackSize() / 1000.0, 1.0);
            }
            if (ModAndClassUtil.GAS && aeStack.getDefinition().func_77973_b() == FCGasItems.GAS_DROP) {
                return (long)Math.max((double)aeStack.getStackSize() / 4000.0, 1.0);
            }
        }
        return aeStack.getStackSize();
    }

    public static void storeFluidItem(CraftingCPUCluster instance) {
        Preconditions.checkState((boolean)Ae2Reflect.getCPUComplete(instance), (Object)"CPU should be complete to prevent re-insertion when dumping items");
        IGrid g = Ae2Reflect.getGrid(instance);
        if (g == null) {
            return;
        }
        IStorageGrid sg = (IStorageGrid)g.getCache(IStorageGrid.class);
        IMEMonitor ii = sg.getInventory(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class));
        IMEMonitor jj = sg.getInventory(AEApi.instance().storage().getStorageChannel(IFluidStorageChannel.class));
        MECraftingInventory inventory = Ae2Reflect.getCPUInventory(instance);
        IMEMonitor kk = ModAndClassUtil.GAS ? sg.getInventory(AEApi.instance().storage().getStorageChannel(IGasStorageChannel.class)) : null;
        for (IAEItemStack is : inventory.getItemList()) {
            IAEFluidStack drop;
            Ae2Reflect.postCPUChange(instance, is, Ae2Reflect.getCPUSource(instance));
            if (is.getItem() == FCItems.FLUID_DROP) {
                drop = (IAEFluidStack)FakeItemRegister.getAEStack(is);
                IAEFluidStack fluidRemainder = (IAEFluidStack)jj.injectItems((IAEStack)drop, Actionable.MODULATE, Ae2Reflect.getCPUSource(instance));
                if (fluidRemainder != null) {
                    is.setStackSize(fluidRemainder.getStackSize());
                    continue;
                }
                is.reset();
                continue;
            }
            if (ModAndClassUtil.GAS && is.getItem() == FCGasItems.GAS_DROP && kk != null) {
                drop = (IAEGasStack)FakeItemRegister.getAEStack(is);
                IAEGasStack gasRemainder = (IAEGasStack)kk.injectItems((IAEStack)drop, Actionable.MODULATE, Ae2Reflect.getCPUSource(instance));
                if (gasRemainder != null) {
                    is.setStackSize(gasRemainder.getStackSize());
                    continue;
                }
                is.reset();
                continue;
            }
            IAEItemStack remainder = (IAEItemStack)ii.injectItems((IAEStack)is.copy(), Actionable.MODULATE, Ae2Reflect.getCPUSource(instance));
            if (remainder != null) {
                is.setStackSize(remainder.getStackSize());
                continue;
            }
            is.reset();
        }
        if (inventory.getItemList().isEmpty()) {
            Ae2Reflect.setCPUInventory(instance, new MECraftingInventory());
        }
        Ae2Reflect.markCPUDirty(instance);
    }

    public static void downloadExtraNBT(Object host, NBTTagCompound tag) {
        if (host instanceof IInterfaceHost) {
            DualityInterface dual = ((IInterfaceHost)host).getInterfaceDuality();
            NBTTagCompound extra = new NBTTagCompound();
            extra.func_74757_a("fluidPacket", Ae2Reflect.getFluidPacketMode(dual));
            extra.func_74757_a("allowSplitting", Ae2Reflect.getSplittingMode(dual));
            extra.func_74768_a("blockModeEx", Ae2Reflect.getExtendedBlockMode(dual));
            tag.func_74782_a("extraNBTData", (NBTBase)extra);
        }
    }

    public static void uploadExtraNBT(Object host, NBTTagCompound tag) {
        if (host instanceof IInterfaceHost && tag != null && tag.func_74764_b("extraNBTData")) {
            DualityInterface dual = ((IInterfaceHost)host).getInterfaceDuality();
            NBTTagCompound extra = tag.func_74775_l("extraNBTData");
            Ae2Reflect.setFluidPacketMode(dual, extra.func_74767_n("fluidPacket"));
            Ae2Reflect.setSplittingMode(dual, extra.func_74767_n("allowSplitting"));
            Ae2Reflect.setExtendedBlockMode(dual, extra.func_74762_e("blockModeEx"));
        }
    }

    public static ItemStack transformPattern(ContainerPatternEncoder container, ItemStack output) {
        Optional maybePattern;
        if ((output.func_77973_b() instanceof ItemFluidEncodedPattern || output.func_77973_b() instanceof ItemFluidCraftEncodedPattern || output.func_77973_b() instanceof ItemLargeEncodedPattern) && (maybePattern = AEApi.instance().definitions().items().encodedPattern().maybeStack(1)).isPresent()) {
            return (ItemStack)maybePattern.get();
        }
        return output;
    }

    public static boolean startJob(ContainerCraftConfirm ccc, ArrayList<CraftingCPURecord> cpus, ICraftingJob result) {
        ItemStack tool;
        GuiType originalGui = null;
        if (!(ccc instanceof ContainerFCCraftConfirm)) {
            return false;
        }
        ContainerFCCraftConfirm container = (ContainerFCCraftConfirm)ccc;
        IActionHost ah = container.getActionHost();
        if (ah instanceof WirelessTerminalGuiObject && (tool = ((WirelessTerminalGuiObject)ah).getItemStack()).func_77973_b() == FCItems.WIRELESS_FLUID_PATTERN_TERMINAL) {
            originalGui = GuiType.WIRELESS_FLUID_PATTERN_TERMINAL;
        }
        if (ah instanceof PartFluidPatternTerminal) {
            originalGui = GuiType.FLUID_PATTERN_TERMINAL;
        }
        if (ah instanceof PartExtendedFluidPatternTerminal) {
            originalGui = GuiType.FLUID_EXTENDED_PATTERN_TERMINAL;
        }
        if (originalGui == null) {
            return false;
        }
        IActionHost h = (IActionHost)container.getTarget();
        if (h != null) {
            IGridNode node = h.getActionableNode();
            IGrid grid = node.getGrid();
            if (result != null && !container.isSimulation()) {
                ICraftingGrid cc = (ICraftingGrid)grid.getCache(ICraftingGrid.class);
                ICraftingLink g = cc.submitJob(result, null, container.getSelectedCpu() == -1 ? null : Ae2Reflect.getCraftingCPU(cpus.get(container.getSelectedCpu())), true, container.getActionSrc());
                container.setAutoStart(false);
                if (g == null) {
                    container.setJob(cc.beginCraftingJob(container.getWorld(), grid, container.getActionSrc(), result.getOutput(), null));
                } else if (container.getOpenContext() != null) {
                    ContainerOpenContext context = container.getOpenContext();
                    InventoryHandler.openGui(container.getInventoryPlayer().field_70458_d, container.getInventoryPlayer().field_70458_d.field_70170_p, new BlockPos(Ae2Reflect.getContextX(context), Ae2Reflect.getContextY(context), Ae2Reflect.getContextZ(context)), container.getOpenContext().getSide().getFacing(), originalGui);
                }
            }
        }
        return true;
    }
}

