/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.common.tile;

import appeng.fluids.util.AEFluidInventory;
import appeng.fluids.util.IAEFluidInventory;
import appeng.fluids.util.IAEFluidTank;
import appeng.tile.AEBaseInvTile;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.inv.IAEAppEngInventory;
import appeng.util.inv.InvOperation;
import com.glodblock.github.util.Util;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileIngredientBuffer
extends AEBaseInvTile
implements IAEFluidInventory {
    private final AppEngInternalInventory invItems = new AppEngInternalInventory((IAEAppEngInventory)this, 9);
    private final AEFluidInventory invFluids = new AEFluidInventory((IAEFluidInventory)this, 4, 16000);

    @Nonnull
    public IItemHandler getInternalInventory() {
        return this.invItems;
    }

    public IAEFluidTank getFluidInventory() {
        return this.invFluids;
    }

    public boolean canBeRotated() {
        return false;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.invItems;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.invFluids;
        }
        return null;
    }

    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
        this.markForUpdate();
    }

    public void onFluidInventoryChanged(IAEFluidTank inv, int slot) {
        this.saveChanges();
        this.markForUpdate();
    }

    public void onFluidInventoryChanged(IAEFluidTank inv, int slot, InvOperation operation, FluidStack added, FluidStack removed) {
        this.onFluidInventoryChanged(inv, slot);
    }

    protected void writeToStream(ByteBuf data) throws IOException {
        super.writeToStream(data);
        for (int i = 0; i < this.invItems.getSlots(); ++i) {
            ByteBufUtils.writeItemStack((ByteBuf)data, (ItemStack)this.invItems.getStackInSlot(i));
        }
        Util.writeFluidInventoryToBuffer(this.invFluids, data);
    }

    protected boolean readFromStream(ByteBuf data) throws IOException {
        boolean changed = super.readFromStream(data);
        for (int i = 0; i < this.invItems.getSlots(); ++i) {
            ItemStack stack = ByteBufUtils.readItemStack((ByteBuf)data);
            if (ItemStack.func_77989_b((ItemStack)stack, (ItemStack)this.invItems.getStackInSlot(i))) continue;
            this.invItems.setStackInSlot(i, stack);
            changed = true;
        }
        return changed |= Util.readFluidInventoryToBuffer(this.invFluids, data);
    }

    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.invItems.readFromNBT(data, "ItemInv");
        this.invFluids.readFromNBT(data, "FluidInv");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound data) {
        super.func_189515_b(data);
        this.invItems.writeToNBT(data, "ItemInv");
        this.invFluids.writeToNBT(data, "FluidInv");
        return data;
    }
}

