/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.common.tile;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.networking.GridFlags;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.events.MENetworkCellArrayUpdate;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.events.MENetworkStorageEvent;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.ICellContainer;
import appeng.api.storage.ICellInventory;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.me.GridAccessException;
import appeng.me.cache.CraftingGridCache;
import appeng.me.helpers.MachineSource;
import appeng.me.storage.MEInventoryHandler;
import appeng.tile.grid.AENetworkTile;
import com.glodblock.github.common.item.fake.FakeItemRegister;
import com.glodblock.github.integration.mek.FakeGases;
import com.glodblock.github.util.Util;
import com.mekeng.github.common.me.data.IAEGasStack;
import com.mekeng.github.common.me.storage.IGasStorageChannel;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;

public class TileGasDiscretizer
extends AENetworkTile
implements ICellContainer {
    private final GasDiscretizingInventory gasDropInv = new GasDiscretizingInventory();
    private final GasCraftingInventory gasCraftInv = new GasCraftingInventory();
    private final IActionSource ownActionSource = new MachineSource((IActionHost)this);
    private boolean prevActiveState = false;

    public TileGasDiscretizer() {
        this.getProxy().setIdlePowerUsage(3.0);
        this.getProxy().setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
    }

    public boolean canBeRotated() {
        return false;
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    public List<IMEInventoryHandler> getCellArray(IStorageChannel<?> channel) {
        try {
            if (this.getProxy().isActive() && this.getProxy().getGrid().getMachines(((Object)((Object)this)).getClass()).size() < 2) {
                if (channel == Util.getItemChannel()) {
                    return Collections.singletonList(this.gasDropInv.invHandler);
                }
                if (channel == TileGasDiscretizer.getGasChannel()) {
                    return Collections.singletonList(this.gasCraftInv.invHandler);
                }
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        return Collections.emptyList();
    }

    public void saveChanges(@Nullable ICellInventory<?> cellInventory) {
        this.field_145850_b.func_175646_b(this.field_174879_c, (TileEntity)this);
    }

    public void gridChanged() {
        IMEMonitor<IAEGasStack> gasGrid = this.getGasGrid();
        if (gasGrid != null) {
            gasGrid.addListener((IMEMonitorHandlerReceiver)this.gasDropInv, gasGrid);
        }
    }

    @MENetworkEventSubscribe
    public void onPowerUpdate(MENetworkPowerStatusChange event) {
        this.updateState();
    }

    @MENetworkEventSubscribe
    public void onChannelUpdate(MENetworkChannelsChanged event) {
        this.updateState();
    }

    @MENetworkEventSubscribe
    public void onStorageUpdate(MENetworkStorageEvent event) {
        this.updateState();
    }

    private void updateState() {
        boolean isActive = this.getProxy().isActive();
        if (isActive != this.prevActiveState) {
            this.prevActiveState = isActive;
            try {
                this.getProxy().getGrid().postEvent((MENetworkEvent)new MENetworkCellArrayUpdate());
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
    }

    public void blinkCell(int slot) {
    }

    @Nullable
    private IEnergyGrid getEnergyGrid() {
        try {
            return (IEnergyGrid)this.getProxy().getGrid().getCache(IEnergyGrid.class);
        }
        catch (GridAccessException e) {
            return null;
        }
    }

    @Nullable
    private IMEMonitor<IAEGasStack> getGasGrid() {
        try {
            return ((IStorageGrid)this.getProxy().getGrid().getCache(IStorageGrid.class)).getInventory(TileGasDiscretizer.getGasChannel());
        }
        catch (GridAccessException e) {
            return null;
        }
    }

    private static IStorageChannel<IAEGasStack> getGasChannel() {
        return AEApi.instance().storage().getStorageChannel(IGasStorageChannel.class);
    }

    private class GasCraftingInventory
    implements IMEInventory {
        private final MEInventoryHandler invHandler = new MEInventoryHandler((IMEInventory)this, this.getChannel());

        GasCraftingInventory() {
            this.invHandler.setPriority(Integer.MAX_VALUE);
        }

        @Nullable
        public IAEStack injectItems(IAEStack aeStack, Actionable type, IActionSource src) {
            IAEItemStack remaining;
            ICraftingGrid craftingGrid;
            if (!(aeStack instanceof IAEGasStack)) {
                return null;
            }
            IAEGasStack input = (IAEGasStack)aeStack;
            try {
                craftingGrid = (ICraftingGrid)TileGasDiscretizer.this.getProxy().getGrid().getCache(ICraftingGrid.class);
            }
            catch (GridAccessException e) {
                return null;
            }
            if (craftingGrid instanceof CraftingGridCache && (remaining = ((CraftingGridCache)craftingGrid).injectItems(FakeGases.packGas2AEDrops(input), type, TileGasDiscretizer.this.ownActionSource)) != null) {
                return (IAEStack)FakeItemRegister.getAEStack(remaining);
            }
            return null;
        }

        @Nullable
        public IAEStack extractItems(IAEStack request, Actionable mode, IActionSource src) {
            return null;
        }

        public IItemList getAvailableItems(IItemList out) {
            return out;
        }

        public IStorageChannel<IAEGasStack> getChannel() {
            return TileGasDiscretizer.getGasChannel();
        }
    }

    private class GasDiscretizingInventory
    implements IMEInventory<IAEItemStack>,
    IMEMonitorHandlerReceiver<IAEGasStack> {
        private final MEInventoryHandler<IAEItemStack> invHandler = new MEInventoryHandler((IMEInventory)this, this.getChannel());
        @Nullable
        private ObjectArrayList<IAEItemStack> itemCache = null;

        GasDiscretizingInventory() {
            this.invHandler.setPriority(Integer.MAX_VALUE);
        }

        @Nullable
        public IAEItemStack extractItems(IAEItemStack request, Actionable mode, IActionSource src) {
            Object gasStack = FakeItemRegister.getAEStack(request);
            if (!(gasStack instanceof IAEGasStack)) {
                return null;
            }
            IMEMonitor gasGrid = TileGasDiscretizer.this.getGasGrid();
            if (gasGrid == null) {
                return null;
            }
            IEnergyGrid energyGrid = TileGasDiscretizer.this.getEnergyGrid();
            if (energyGrid == null) {
                return null;
            }
            System.out.print(gasStack + "\n");
            return FakeGases.packGas2AEDrops((IAEGasStack)gasGrid.extractItems((IAEStack)((IAEGasStack)gasStack), mode, TileGasDiscretizer.this.ownActionSource));
        }

        @Nullable
        public IAEItemStack injectItems(IAEItemStack input, Actionable type, IActionSource src) {
            Object gasStack = FakeItemRegister.getAEStack(input);
            if (!(gasStack instanceof IAEGasStack)) {
                return input;
            }
            IMEMonitor gasGrid = TileGasDiscretizer.this.getGasGrid();
            if (gasGrid == null) {
                return input;
            }
            IEnergyGrid energyGrid = TileGasDiscretizer.this.getEnergyGrid();
            if (energyGrid == null) {
                return input;
            }
            return FakeGases.packGas2AEDrops((IAEGasStack)gasGrid.injectItems((IAEStack)((IAEGasStack)gasStack), type, TileGasDiscretizer.this.ownActionSource));
        }

        public IItemList<IAEItemStack> getAvailableItems(IItemList<IAEItemStack> out) {
            if (this.itemCache == null) {
                this.itemCache = new ObjectArrayList();
                IMEMonitor gasGrid = TileGasDiscretizer.this.getGasGrid();
                if (gasGrid != null) {
                    for (IAEGasStack gas : gasGrid.getStorageList()) {
                        IAEItemStack stack = FakeGases.packGas2AEDrops(gas);
                        if (stack == null) continue;
                        this.itemCache.add((Object)stack);
                    }
                }
            }
            for (IAEItemStack stack : this.itemCache) {
                out.addStorage((IAEStack)stack);
            }
            return out;
        }

        public boolean isValid(Object verificationToken) {
            IMEMonitor gasGrid = TileGasDiscretizer.this.getGasGrid();
            return gasGrid != null && gasGrid == verificationToken;
        }

        public void postChange(IBaseMonitor<IAEGasStack> monitor, Iterable<IAEGasStack> change, IActionSource actionSource) {
            this.itemCache = null;
            try {
                ObjectArrayList mappedChanges = new ObjectArrayList();
                for (IAEGasStack gasStack : change) {
                    IAEItemStack itemStack;
                    boolean isNg = false;
                    if (gasStack.getStackSize() < 0L) {
                        isNg = true;
                        gasStack.setStackSize(-gasStack.getStackSize());
                    }
                    if ((itemStack = FakeGases.packGas2AEDrops(gasStack)) == null) continue;
                    if (isNg) {
                        itemStack.setStackSize(-itemStack.getStackSize());
                    }
                    mappedChanges.add((Object)itemStack);
                }
                ((IStorageGrid)TileGasDiscretizer.this.getProxy().getGrid().getCache(IStorageGrid.class)).postAlterationOfStoredItems(this.getChannel(), (Iterable)mappedChanges, TileGasDiscretizer.this.ownActionSource);
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }

        public void onListUpdate() {
        }

        public IStorageChannel<IAEItemStack> getChannel() {
            return Util.getItemChannel();
        }
    }
}

